/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.lang;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class BaseException
extends Exception {
    private static final long serialVersionUID = 2943182462526701811L;
    private String mErrorCode;
    private Exception mCause = null;
    private boolean mIsRetry = false;
    private static final String C_NONE = "";
    private static final String C_CAUSE = "Caused by: ";

    public BaseException() {
        this.mErrorCode = C_NONE;
    }

    public BaseException(String errCode, String errMsg, Exception cause) {
        super(errMsg);
        this.mErrorCode = errCode;
        this.mCause = cause;
    }

    public BaseException(String errCode, String errMsg) {
        super(errMsg);
        this.mErrorCode = errCode;
    }

    public BaseException(String errCode, String errMsg, Exception cause, boolean isRetry) {
        super(errMsg);
        this.mErrorCode = errCode;
        this.mCause = cause;
        this.mIsRetry = isRetry;
    }

    public BaseException(String errCode, String errMsg, boolean isRetry) {
        super(errMsg);
        this.mErrorCode = errCode;
        this.mIsRetry = isRetry;
    }

    public boolean IsRetry() {
        return this.mIsRetry;
    }

    public String getErrCode() {
        return this.mErrorCode;
    }

    public Throwable getCause() {
        return this.mCause == this ? null : this.mCause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            super.printStackTrace(s);
            Throwable ourCause = this.getCause();
            if (ourCause != null) {
                s.println(C_CAUSE + ourCause);
            }
        }
    }

    public String getStackTraceString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.printStackTrace(pw);
        pw.close();
        String tmp = sw.toString();
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            this.printStackTrace(new PrintWriter(System.err, true));
        }
    }
}

