/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InterceptorChainList;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.Invoker;

public class DefaultInterceptorChain
implements InterceptorChain,
Serializable,
Cloneable {
    private static final long serialVersionUID = 3689361711046717596L;
    protected int currentIndex = -1;
    protected transient InterceptorChainList interceptorChainList;
    protected ServiceName interceptorChainListServiceName;
    protected transient Invoker invoker;
    protected ServiceName invokerServiceName;

    public DefaultInterceptorChain() {
    }

    public DefaultInterceptorChain(InterceptorChainList list, Invoker invoker) {
        this.setInterceptorChainList(list);
        this.setInvoker(invoker);
    }

    public DefaultInterceptorChain(ServiceName listServiceName, ServiceName invokerServiceName) {
        this.setInterceptorChainListServiceName(listServiceName);
        this.setInvokerServiceName(invokerServiceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeNext(InvocationContext context) throws Throwable {
        InterceptorChainList list = this.getInterceptorChainList();
        Invoker ivk = this.getInvoker();
        if (list == null) {
            if (ivk != null) {
                return ivk.invoke(context);
            }
            return null;
        }
        int index = this.getCurrentInterceptorIndex();
        try {
            this.setCurrentInterceptorIndex(++index);
            Interceptor interceptor = list.getInterceptor(context, index);
            if (interceptor != null) {
                Object object = interceptor.invoke(context, this);
                return object;
            }
            if (ivk != null) {
                Object object = ivk.invoke(context);
                return object;
            }
            Object var6_8 = null;
            return var6_8;
        }
        finally {
            this.setCurrentInterceptorIndex(--index);
        }
    }

    public int getCurrentInterceptorIndex() {
        return this.currentIndex;
    }

    public void setCurrentInterceptorIndex(int index) {
        this.currentIndex = index;
    }

    public InterceptorChainList getInterceptorChainList() {
        if (this.interceptorChainListServiceName != null) {
            try {
                return (InterceptorChainList)ServiceManagerFactory.getServiceObject(this.interceptorChainListServiceName);
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
        }
        return this.interceptorChainList;
    }

    public void setInterceptorChainList(InterceptorChainList list) {
        Service service;
        if (this.interceptorChainList instanceof ServiceBase) {
            this.interceptorChainListServiceName = ((ServiceBase)((Object)list)).getServiceNameObject();
        } else if (this.interceptorChainList instanceof Service && (service = (Service)((Object)list)).getServiceManagerName() != null) {
            this.interceptorChainListServiceName = new ServiceName(service.getServiceManagerName(), service.getServiceName());
        }
        if (this.interceptorChainListServiceName == null) {
            this.interceptorChainList = list;
        }
    }

    public void setInterceptorChainListServiceName(ServiceName name) {
        this.interceptorChainListServiceName = name;
    }

    public Invoker getInvoker() {
        if (this.invokerServiceName != null) {
            try {
                return (Invoker)ServiceManagerFactory.getServiceObject(this.invokerServiceName);
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
        }
        return this.invoker;
    }

    public void setInvoker(Invoker invoker) {
        Service service;
        if (invoker instanceof ServiceBase) {
            this.invokerServiceName = ((ServiceBase)((Object)invoker)).getServiceNameObject();
        } else if (invoker instanceof Service && (service = (Service)((Object)invoker)).getServiceManagerName() != null) {
            this.invokerServiceName = new ServiceName(service.getServiceManagerName(), service.getServiceName());
        }
        if (this.invokerServiceName == null) {
            this.invoker = invoker;
        }
    }

    public void setInvokerServiceName(ServiceName name) {
        this.invokerServiceName = name;
    }

    public InterceptorChain cloneChain() {
        try {
            return (InterceptorChain)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.interceptorChainListServiceName == null) {
            out.writeObject(this.interceptorChainList);
        }
        if (this.invokerServiceName == null) {
            out.writeObject(this.invoker);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.interceptorChainList = this.interceptorChainListServiceName == null ? (InterceptorChainList)in.readObject() : (InterceptorChainList)ServiceManagerFactory.getServiceObject(this.interceptorChainListServiceName);
        this.invoker = this.invokerServiceName == null ? (Invoker)in.readObject() : (Invoker)ServiceManagerFactory.getServiceObject(this.invokerServiceName);
    }
}

