/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class SerializableMethod
implements Serializable {
    private static final long serialVersionUID = 1134596120912054986L;
    private String declaringClassName;
    private String methodName;
    private List paramTypes;
    private transient Method method;

    public SerializableMethod(Method method) {
        this.declaringClassName = method.getDeclaringClass().getName();
        this.methodName = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes != null && paramTypes.length != 0) {
            this.paramTypes = new ArrayList();
            for (int i = 0; i < paramTypes.length; ++i) {
                this.paramTypes.add(paramTypes[i].getName());
            }
        }
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public String toString() {
        return this.method.toString();
    }

    public boolean equalsSignature(Method method) {
        if (!this.declaringClassName.equals(method.getDeclaringClass().getName())) {
            return false;
        }
        if (!this.methodName.equals(method.getName())) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        if (this.paramTypes == null && paramTypes.length != 0 || this.paramTypes != null && paramTypes.length == 0) {
            return false;
        }
        if (this.paramTypes != null && paramTypes.length != 0) {
            if (this.paramTypes.size() != paramTypes.length) {
                return false;
            }
            for (int i = 0; i < paramTypes.length; ++i) {
                if (this.paramTypes.get(i).equals(paramTypes[i].getName())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SerializableMethod)) {
            return false;
        }
        SerializableMethod method = (SerializableMethod)obj;
        if (!this.declaringClassName.equals(method.declaringClassName)) {
            return false;
        }
        if (!this.methodName.equals(method.methodName)) {
            return false;
        }
        if (this.paramTypes == null && method.paramTypes != null || this.paramTypes != null && method.paramTypes == null) {
            return false;
        }
        return this.paramTypes == null || method.paramTypes == null || ((Object)this.paramTypes).equals(method.paramTypes);
    }

    public int hashCode() {
        int hashCode = this.declaringClassName.hashCode() + this.methodName.hashCode();
        if (this.paramTypes != null) {
            hashCode += ((Object)this.paramTypes).hashCode();
        }
        return hashCode;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            Class<?> clazz = Class.forName(this.declaringClassName, true, Thread.currentThread().getContextClassLoader());
            if (this.paramTypes == null) {
                this.method = clazz.getDeclaredMethod(this.methodName, new Class[0]);
            } else {
                ArrayList<Class<Byte>> list = new ArrayList<Class<Byte>>();
                int max = this.paramTypes.size();
                for (int i = 0; i < max; ++i) {
                    String paramType = (String)this.paramTypes.get(i);
                    Class<Constable> paramClass = null;
                    paramClass = paramType.equals(Byte.TYPE.getName()) ? Byte.TYPE : (paramType.equals(Character.TYPE.getName()) ? Character.TYPE : (paramType.equals(Short.TYPE.getName()) ? Short.TYPE : (paramType.equals(Integer.TYPE.getName()) ? Integer.TYPE : (paramType.equals(Long.TYPE.getName()) ? Long.TYPE : (paramType.equals(Float.TYPE.getName()) ? Float.TYPE : (paramType.equals(Double.TYPE.getName()) ? Double.TYPE : (paramType.equals(Boolean.TYPE.getName()) ? Boolean.TYPE : Class.forName(paramType, true, Thread.currentThread().getContextClassLoader()))))))));
                    list.add(paramClass);
                }
                this.method = clazz.getDeclaredMethod(this.methodName, list.toArray(new Class[list.size()]));
            }
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e.getMessage());
        }
    }
}

