/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.converter;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.converter.BeanFlowConverterServiceMBean;
import jp.ossc.nimbus.util.ClassMappingTree;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.Converter;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class BeanFlowConverterService
extends ServiceBase
implements Converter,
BeanFlowConverterServiceMBean {
    private static final long serialVersionUID = -5396783198786410663L;
    private static final String ARRAY_CLASS_SUFFIX = "[]";
    private Map classMapping;
    private ClassMappingTree classMap;
    private String[] conditions;
    private List conditionList;
    private String defaultBeanFlowKey;
    private ServiceName beanFlowInvokerFactoryServiceName;
    private BeanFlowInvokerFactory beanFlowInvokerFactory;

    public void setClassMapping(Map mapping) {
        this.classMapping = mapping;
    }

    public Map getClassMapping() {
        return this.classMapping;
    }

    public void setConditions(String[] conditions) {
        this.conditions = conditions;
    }

    public String[] getConditions() {
        return this.conditions;
    }

    public void setDefaultBeanFlowKey(String beanFlowKey) {
        this.defaultBeanFlowKey = beanFlowKey;
    }

    public String getDefaultBeanFlowKey() {
        return this.defaultBeanFlowKey;
    }

    public void setBeanFlowInvokerFactoryServiceName(ServiceName name) {
        this.beanFlowInvokerFactoryServiceName = name;
    }

    public ServiceName getBeanFlowInvokerFactoryServiceName() {
        return this.beanFlowInvokerFactoryServiceName;
    }

    public void setBeanFlowInvokerFactory(BeanFlowInvokerFactory factory) {
        this.beanFlowInvokerFactory = factory;
    }

    public BeanFlowInvokerFactory getBeanFlowInvokerFactory() {
        return this.beanFlowInvokerFactory;
    }

    public void startService() throws Exception {
        if (this.beanFlowInvokerFactoryServiceName != null) {
            this.beanFlowInvokerFactory = (BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject(this.beanFlowInvokerFactoryServiceName);
        }
        if (this.beanFlowInvokerFactory == null) {
            throw new IllegalArgumentException("BeanFlowInvoker is null.");
        }
        Set flowKeySet = this.beanFlowInvokerFactory.getBeanFlowKeySet();
        if (this.classMapping != null && this.classMapping.size() != 0) {
            this.classMap = new ClassMappingTree(null);
            Iterator entries = this.classMapping.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Class clazz = BeanFlowConverterService.convertStringToClass((String)entry.getKey());
                String beanFlowKey = (String)entry.getValue();
                if (!flowKeySet.contains(beanFlowKey)) {
                    throw new IllegalArgumentException("BeanFlow is not found : " + beanFlowKey);
                }
                this.classMap.add(clazz, beanFlowKey);
            }
        } else if (this.classMap != null) {
            this.classMap.clear();
        }
        if (this.conditions != null && this.conditions.length != 0) {
            if (this.conditionList != null) {
                this.conditionList.clear();
            } else {
                this.conditionList = new ArrayList();
            }
            for (int i = 0; i < this.conditions.length; ++i) {
                String condition = this.conditions[i];
                int index = condition.lastIndexOf(61);
                if (index == 0 || index == -1 || index == condition.length() - 1) {
                    throw new IllegalArgumentException("Condition is illegal : " + condition);
                }
                String cond = condition.substring(0, index);
                String beanFlowKey = condition.substring(index + 1);
                if (!flowKeySet.contains(beanFlowKey)) {
                    throw new IllegalArgumentException("BeanFlow is not found : " + beanFlowKey);
                }
                this.conditionList.add(new Condition(cond, beanFlowKey));
            }
        } else if (this.conditionList != null) {
            this.conditionList.clear();
        }
        if (this.defaultBeanFlowKey != null && !flowKeySet.contains(this.defaultBeanFlowKey)) {
            throw new IllegalArgumentException("BeanFlow is not found : " + this.defaultBeanFlowKey);
        }
        if (!(this.classMapping != null && this.classMapping.size() != 0 || this.conditionList != null && this.conditionList.size() != 0 || this.defaultBeanFlowKey != null)) {
            throw new IllegalArgumentException("BeanFlowKey is not specified.");
        }
    }

    public Object convert(Object obj) throws ConvertException {
        String beanFlowKey = null;
        if (obj != null && this.classMap != null) {
            beanFlowKey = (String)this.classMap.getValue(obj.getClass());
        }
        if (beanFlowKey == null && this.conditionList != null && this.conditionList.size() != 0) {
            int imax = this.conditionList.size();
            for (int i = 0; i < imax; ++i) {
                Condition condition = (Condition)this.conditionList.get(i);
                if (!condition.evaluate(obj)) continue;
                beanFlowKey = condition.beanFlowKey;
                break;
            }
        }
        if (beanFlowKey == null) {
            beanFlowKey = this.defaultBeanFlowKey;
        }
        if (beanFlowKey == null) {
            return obj;
        }
        try {
            return this.beanFlowInvokerFactory.createFlow(beanFlowKey).invokeFlow(obj);
        }
        catch (Exception e) {
            throw new ConvertException(e);
        }
    }

    private static Class convertStringToClass(String typeStr) throws ClassNotFoundException {
        Class<Comparable<Byte>> type = null;
        if (typeStr != null) {
            if (Byte.TYPE.getName().equals(typeStr)) {
                type = Byte.TYPE;
            } else if (Character.TYPE.getName().equals(typeStr)) {
                type = Character.TYPE;
            } else if (Short.TYPE.getName().equals(typeStr)) {
                type = Short.TYPE;
            } else if (Integer.TYPE.getName().equals(typeStr)) {
                type = Integer.TYPE;
            } else if (Long.TYPE.getName().equals(typeStr)) {
                type = Long.TYPE;
            } else if (Float.TYPE.getName().equals(typeStr)) {
                type = Float.TYPE;
            } else if (Double.TYPE.getName().equals(typeStr)) {
                type = Double.TYPE;
            } else if (Boolean.TYPE.getName().equals(typeStr)) {
                type = Boolean.TYPE;
            } else if (typeStr.endsWith(ARRAY_CLASS_SUFFIX) && typeStr.length() > 2) {
                Class elementType = BeanFlowConverterService.convertStringToClass(typeStr.substring(0, typeStr.length() - 2));
                type = Array.newInstance(elementType, 0).getClass();
            } else {
                type = Class.forName(typeStr, true, NimbusClassLoader.getInstance());
            }
        }
        return type;
    }

    private class Condition {
        public String beanFlowKey;
        private List properties;
        private Expression expression;
        private List keyList;
        private static final String DELIMITER = "@";
        private static final String VALUE = "value";

        Condition(String cond, String beanFlowKey) throws Exception {
            this.beanFlowKey = beanFlowKey;
            this.keyList = new ArrayList();
            this.properties = new ArrayList();
            StringTokenizer token = new StringTokenizer(cond, DELIMITER, true);
            boolean keyFlg = false;
            String beforeToken = null;
            StringBuffer condBuf = new StringBuffer();
            while (token.hasMoreTokens()) {
                String str = token.nextToken();
                if (!keyFlg) {
                    if (DELIMITER.equals(str)) {
                        keyFlg = true;
                    } else {
                        condBuf.append(str);
                    }
                } else if (DELIMITER.equals(str)) {
                    keyFlg = false;
                    if (beforeToken != null) {
                        String tmpKey = "_conditionKey$" + this.keyList.size();
                        this.keyList.add(tmpKey);
                        condBuf.append(tmpKey);
                        this.properties.add(PropertyFactory.createProperty(beforeToken));
                    } else {
                        condBuf.append(str);
                    }
                }
                beforeToken = str;
            }
            this.expression = ExpressionFactory.createExpression((String)condBuf.toString());
            this.evaluate("", true);
        }

        public boolean evaluate(Object object) throws ConvertException {
            return this.evaluate(object, false);
        }

        protected boolean evaluate(Object object, boolean isTest) throws ConvertException {
            JexlContext jexlContext = JexlHelper.createContext();
            jexlContext.getVars().put(VALUE, object);
            if (object != null) {
                int size = this.keyList.size();
                for (int i = 0; i < size; ++i) {
                    String keyString = (String)this.keyList.get(i);
                    Property property = (Property)this.properties.get(i);
                    Object val = null;
                    try {
                        val = property.getProperty(object);
                    }
                    catch (NoSuchPropertyException e) {
                    }
                    catch (InvocationTargetException e) {
                        // empty catch block
                    }
                    jexlContext.getVars().put(keyString, val);
                }
            }
            try {
                Object exp = this.expression.evaluate(jexlContext);
                if (exp instanceof Boolean) {
                    return (Boolean)exp;
                }
                if (exp == null && isTest) {
                    return true;
                }
                throw new ConvertException(this.expression.getExpression());
            }
            catch (Exception e) {
                throw new ConvertException(e);
            }
        }
    }
}

