/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.crypt;

import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.crypt.CipherCryptServiceMBean;
import jp.ossc.nimbus.service.crypt.Crypt;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.ReversibleConverter;
import jp.ossc.nimbus.util.converter.StringConverter;

public class CipherCryptService
extends ServiceBase
implements Crypt,
StringConverter,
ReversibleConverter,
CipherCryptServiceMBean {
    private static final long serialVersionUID = 5230161454391953789L;
    private static final String CC___00001 = "CC___00001";
    private static final String CC___00002 = "CC___00002";
    private static final String CC___00003 = "CC___00003";
    protected String transformation = "DES/ECB/PKCS5Padding";
    protected Key key;
    protected Provider cipherProvider;
    protected String cipherProviderName;
    protected Provider messageDigestProvider;
    protected String messageDigestProviderName;
    protected AlgorithmParameters algorithmParameters;
    protected AlgorithmParameterSpec algorithmParameterSpec;
    protected SecureRandom secureRandom;
    protected String encoding = "ISO_8859-1";
    protected String hashAlgorithm = "MD5";
    protected int convertType;

    public void setTransformation(String trans) {
        this.transformation = trans;
    }

    public String getTransformation() {
        return this.transformation;
    }

    public void setKey(Key k) {
        this.key = k;
    }

    public Key getKey() {
        return this.key;
    }

    public void setCipherProvider(Provider p) {
        this.cipherProvider = p;
    }

    public Provider getCipherProvider() {
        return this.cipherProvider;
    }

    public void setCipherProviderName(String name) {
        this.cipherProviderName = name;
    }

    public String getCipherProviderName() {
        return this.cipherProviderName;
    }

    public void setAlgorithmParameters(AlgorithmParameters params) {
        this.algorithmParameters = params;
    }

    public AlgorithmParameters getAlgorithmParameters() {
        return this.algorithmParameters;
    }

    public void setAlgorithmParameterSpec(AlgorithmParameterSpec params) {
        this.algorithmParameterSpec = params;
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.algorithmParameterSpec;
    }

    public void setSecureRandom(SecureRandom random) {
        this.secureRandom = random;
    }

    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setHashAlgorithm(String algorithm) {
        this.hashAlgorithm = algorithm;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setMessageDigestProvider(Provider p) {
        this.messageDigestProvider = p;
    }

    public Provider getMessageDigestProvider() {
        return this.messageDigestProvider;
    }

    public void setMessageDigestProviderName(String name) {
        this.messageDigestProviderName = name;
    }

    public String getMessageDigestProviderName() {
        return this.messageDigestProviderName;
    }

    public void setConvertType(int type) {
        this.convertType = type;
    }

    public int getConvertType() {
        return this.convertType;
    }

    public void startService() throws Exception {
        String encodeStr;
        String decodeStr;
        if (this.key != null && !"test".equals(decodeStr = this.doDecodeInternal(encodeStr = this.doEncodeInternal("test")))) {
            throw new IllegalArgumentException("This encryption cannot convert reversible.");
        }
        if (this.hashAlgorithm != null) {
            this.doHashInternal("test");
        }
        if (this.key == null && this.hashAlgorithm == null) {
            throw new IllegalArgumentException("It is necessary to specify either of key or hashAlgorithm.");
        }
    }

    public String doEncode(String str) {
        try {
            return this.doEncodeInternal(str);
        }
        catch (NoSuchAlgorithmException e) {
            this.getLogger().write(CC___00001, e);
        }
        catch (NoSuchProviderException e) {
            this.getLogger().write(CC___00001, e);
        }
        catch (NoSuchPaddingException e) {
            this.getLogger().write(CC___00001, e);
        }
        catch (InvalidKeyException e) {
            this.getLogger().write(CC___00001, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            this.getLogger().write(CC___00001, e);
        }
        catch (IllegalBlockSizeException e) {
            this.getLogger().write(CC___00001, e);
        }
        catch (BadPaddingException e) {
            this.getLogger().write(CC___00001, e);
        }
        catch (UnsupportedEncodingException e) {
            this.getLogger().write(CC___00001, e);
        }
        return str;
    }

    protected String doEncodeInternal(String str) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        if (this.transformation == null || this.key == null) {
            throw new UnsupportedOperationException("Transformation or key is not specified.");
        }
        if (str == null) {
            return null;
        }
        Cipher c = this.createCipher();
        this.intiCipher(c, 1);
        return CipherCryptService.toHexString(c.doFinal(str.getBytes(this.encoding)));
    }

    protected Cipher createCipher() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        if (this.cipherProvider != null) {
            return Cipher.getInstance(this.transformation, this.cipherProvider);
        }
        if (this.cipherProviderName != null) {
            return Cipher.getInstance(this.transformation, this.cipherProviderName);
        }
        return Cipher.getInstance(this.transformation);
    }

    protected void intiCipher(Cipher c, int opmode) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.algorithmParameters != null) {
            if (this.secureRandom == null) {
                c.init(opmode, this.key, this.algorithmParameters);
            } else {
                c.init(opmode, this.key, this.algorithmParameters, this.secureRandom);
            }
        } else if (this.algorithmParameterSpec != null) {
            if (this.secureRandom == null) {
                c.init(opmode, this.key, this.algorithmParameterSpec);
            } else {
                c.init(opmode, this.key, this.algorithmParameterSpec, this.secureRandom);
            }
        } else if (this.secureRandom != null) {
            c.init(opmode, this.key, this.secureRandom);
        } else {
            c.init(opmode, this.key);
        }
    }

    protected static String toHexString(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        int max = bytes.length;
        for (int i = 0; i < max; ++i) {
            int intValue = bytes[i];
            String str = Integer.toHexString(intValue &= 0xFF).toUpperCase();
            if (str.length() == 1) {
                buf.append('0');
            }
            buf.append(str);
        }
        return buf.toString();
    }

    public String doDecode(String str) {
        try {
            return this.doDecodeInternal(str);
        }
        catch (NoSuchAlgorithmException e) {
            this.getLogger().write(CC___00002, e);
        }
        catch (NoSuchProviderException e) {
            this.getLogger().write(CC___00002, e);
        }
        catch (NoSuchPaddingException e) {
            this.getLogger().write(CC___00002, e);
        }
        catch (InvalidKeyException e) {
            this.getLogger().write(CC___00002, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            this.getLogger().write(CC___00002, e);
        }
        catch (IllegalBlockSizeException e) {
            this.getLogger().write(CC___00002, e);
        }
        catch (BadPaddingException e) {
            this.getLogger().write(CC___00002, e);
        }
        catch (UnsupportedEncodingException e) {
            this.getLogger().write(CC___00002, e);
        }
        return str;
    }

    protected String doDecodeInternal(String str) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        Cipher c = this.createCipher();
        this.intiCipher(c, 2);
        return new String(c.doFinal(CipherCryptService.toBytes(str)), this.encoding);
    }

    protected static byte[] toBytes(String hex) {
        byte[] bytes = new byte[hex.length() / 2];
        int max = hex.length();
        for (int i = 0; i < max; i += 2) {
            bytes[i / 2] = (byte)(Integer.parseInt(hex.substring(i, i + 2), 16) & 0xFF);
        }
        return bytes;
    }

    public String doHash(String str) {
        try {
            return this.doHashInternal(str);
        }
        catch (NoSuchProviderException e) {
            this.getLogger().write(CC___00003, e);
        }
        catch (NoSuchAlgorithmException e) {
            this.getLogger().write(CC___00003, e);
        }
        catch (UnsupportedEncodingException e) {
            this.getLogger().write(CC___00003, e);
        }
        return str;
    }

    protected String doHashInternal(String str) throws NoSuchProviderException, NoSuchAlgorithmException, UnsupportedEncodingException {
        if (this.hashAlgorithm == null) {
            throw new UnsupportedOperationException("HashAlgorithm is not specified.");
        }
        if (str == null) {
            return null;
        }
        MessageDigest messageDigest = null;
        messageDigest = this.messageDigestProvider != null ? MessageDigest.getInstance(this.hashAlgorithm, this.messageDigestProvider) : (this.messageDigestProviderName != null ? MessageDigest.getInstance(this.hashAlgorithm, this.messageDigestProviderName) : MessageDigest.getInstance(this.hashAlgorithm));
        return CipherCryptService.toHexString(messageDigest.digest(str.getBytes(this.encoding)));
    }

    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        return this.convert((String)(obj instanceof String ? obj : String.valueOf(obj)));
    }

    public String convert(String str) throws ConvertException {
        switch (this.convertType) {
            case 2: {
                return this.doDecode(str);
            }
        }
        return this.doEncode(str);
    }
}

