/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.cui.CuiTagDefine;
import jp.ossc.nimbus.service.cui.DisplayConstructer;
import jp.ossc.nimbus.service.cui.InputChecker;

public class DataInputStep
implements CuiTagDefine {
    private String mMyName;
    private ArrayList mDisplayList = null;
    private InputChecker mChecker = null;
    private HashMap mWhereToGoHash = null;
    private String mSelectedValue = null;
    private String mNextStepName = null;
    private String mEndMessage = "";

    public DataInputStep(String name) {
        this.mMyName = name;
        this.mDisplayList = new ArrayList();
        this.mWhereToGoHash = new HashMap();
        this.mEndMessage = "";
    }

    public String invoke() {
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            this.mSelectedValue = null;
            ListIterator iterator = this.mDisplayList.listIterator();
            while (iterator.hasNext()) {
                DisplayConstructer ds = (DisplayConstructer)iterator.next();
                System.out.println(ds.display());
            }
            String answer = null;
            try {
                answer = input.readLine();
            }
            catch (IOException e) {
                continue;
            }
            if (answer.equals("Redo") || answer.equals("Interrupt")) {
                return answer;
            }
            this.mSelectedValue = this.mChecker.check(answer);
            if (this.mSelectedValue != null) break;
        }
        String distination = (String)this.mWhereToGoHash.get(this.mSelectedValue);
        if (distination != null) {
            return distination;
        }
        return this.mNextStepName;
    }

    public String invoke(String in) {
        this.mSelectedValue = this.mChecker.check(in);
        if (this.mSelectedValue == null) {
            throw new ServiceException();
        }
        String distination = (String)this.mWhereToGoHash.get(this.mSelectedValue);
        if (distination != null) {
            return distination;
        }
        return this.mNextStepName;
    }

    public String getSelectedValue() {
        return this.mSelectedValue;
    }

    public void addDisplay(DisplayConstructer display) {
        this.mDisplayList.add(display);
    }

    public void setNextStepName(String name) {
        this.mNextStepName = name;
    }

    public String getNextStepName() {
        return this.mNextStepName;
    }

    public void addWhereToGo(String condition, String gotoStepName) {
        this.mWhereToGoHash.put(condition, gotoStepName);
    }

    public void setEndMessage(String msg) {
        this.mEndMessage = msg;
    }

    public String getEndMessage() {
        return this.mEndMessage;
    }

    public String getName() {
        return this.mMyName;
    }

    public InputChecker getChecker() {
        return this.mChecker;
    }

    public void setChecker(InputChecker checker) {
        this.mChecker = checker;
    }
}

