/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import jp.ossc.nimbus.service.jms.ReconnectableConnection;

public class ReconnectableConnectionConsumer
implements ConnectionConsumer {
    protected ReconnectableConnection connection;
    protected ConnectionConsumer connectionConsumer;
    protected Destination destination;
    protected String messageSelector;
    protected String subscriptionName;
    protected int maxMessages;
    protected boolean isClose;
    protected ServerSessionPool serverSessionPool;

    public ReconnectableConnectionConsumer(ReconnectableConnection connection, Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.connection = connection;
        this.destination = destination;
        this.messageSelector = messageSelector;
        this.maxMessages = maxMessages;
        this.connectionConsumer = this.createConnectionConsumer(connection, destination, messageSelector, sessionPool, maxMessages);
    }

    public ReconnectableConnectionConsumer(ReconnectableConnection connection, Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.connection = connection;
        this.subscriptionName = subscriptionName;
        this.destination = topic;
        this.messageSelector = messageSelector;
        this.maxMessages = maxMessages;
        this.connectionConsumer = this.createConnectionConsumer(connection, topic, subscriptionName, messageSelector, sessionPool, maxMessages);
    }

    protected ConnectionConsumer createConnectionConsumer(ReconnectableConnection connection, Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.serverSessionPool = sessionPool;
        if (destination instanceof Queue) {
            return ((QueueConnection)connection.getConnection()).createConnectionConsumer((Queue)destination, messageSelector, sessionPool, maxMessages);
        }
        return ((TopicConnection)connection.getConnection()).createConnectionConsumer((Topic)destination, messageSelector, sessionPool, maxMessages);
    }

    protected ConnectionConsumer createConnectionConsumer(ReconnectableConnection connection, Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return ((TopicConnection)connection.getConnection()).createDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        return this.connectionConsumer.getServerSessionPool();
    }

    public void close() throws JMSException {
        this.isClose = true;
        this.connection.removeConnectionConsumer(this);
        this.connectionConsumer.close();
    }

    public void reconnect() throws JMSException {
        ConnectionConsumer newConnectionConsumer;
        if (this.isClose) {
            return;
        }
        this.connectionConsumer = newConnectionConsumer = this.createConnectionConsumer(this.connection, this.destination, this.messageSelector, this.serverSessionPool, this.maxMessages);
    }
}

