/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import jp.ossc.nimbus.service.jms.ReconnectableSession;

public class ReconnectableMessageProducer
implements MessageProducer {
    protected ReconnectableSession session;
    protected MessageProducer messageProducer;
    protected boolean isClose;
    protected Destination destination;

    public ReconnectableMessageProducer(ReconnectableSession session, Destination destination) throws JMSException {
        this.session = session;
        this.messageProducer = this.createMessageProducer(session, destination);
    }

    protected MessageProducer createMessageProducer(ReconnectableSession session, Destination destination) throws JMSException {
        this.destination = destination;
        return session.getRealSession().createProducer(destination);
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.messageProducer.setDisableMessageID(value);
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.messageProducer.getDisableMessageID();
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.messageProducer.setDisableMessageTimestamp(value);
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.messageProducer.getDisableMessageTimestamp();
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.messageProducer.setDeliveryMode(deliveryMode);
    }

    public int getDeliveryMode() throws JMSException {
        return this.messageProducer.getDeliveryMode();
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.messageProducer.setPriority(defaultPriority);
    }

    public int getPriority() throws JMSException {
        return this.messageProducer.getPriority();
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.messageProducer.setTimeToLive(timeToLive);
    }

    public long getTimeToLive() throws JMSException {
        return this.messageProducer.getTimeToLive();
    }

    public Destination getDestination() throws JMSException {
        return this.messageProducer.getDestination();
    }

    public void close() throws JMSException {
        this.isClose = true;
        this.session.removeMessageProducer(this.messageProducer);
        this.messageProducer.close();
    }

    public void send(Message message) throws JMSException {
        this.messageProducer.send(message);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.messageProducer.send(message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.messageProducer.send(destination, message);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.messageProducer.send(destination, message, deliveryMode, priority, timeToLive);
    }

    public void reconnect() throws JMSException {
        MessageProducer newMessageProducer;
        if (this.isClose) {
            return;
        }
        this.messageProducer = newMessageProducer = this.createMessageProducer(this.session, this.destination);
    }
}

