/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import jp.ossc.nimbus.service.jms.ReconnectableMessageConsumer;
import jp.ossc.nimbus.service.jms.ReconnectableSession;

public class ReconnectableTopicSubscriber
extends ReconnectableMessageConsumer
implements TopicSubscriber {
    public ReconnectableTopicSubscriber(ReconnectableSession session, Topic topic) throws JMSException {
        super(session, (Destination)topic);
    }

    public ReconnectableTopicSubscriber(ReconnectableSession session, Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        super(session, (Destination)topic, messageSelector, noLocal);
    }

    public ReconnectableTopicSubscriber(ReconnectableSession session, Topic topic, String name) throws JMSException {
        super(session, topic, name);
    }

    public ReconnectableTopicSubscriber(ReconnectableSession session, Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        super(session, topic, name, messageSelector, noLocal);
    }

    protected Destination getDestination() throws JMSException {
        return this.getTopic();
    }

    protected MessageConsumer createMessageConsumer(ReconnectableSession session, Destination destination) throws JMSException {
        this.destination = destination;
        return ((TopicSession)session.getRealSession()).createSubscriber((Topic)destination);
    }

    protected MessageConsumer createMessageConsumer(ReconnectableSession session, Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        this.noLocal = noLocal;
        this.destination = destination;
        this.messageSelector = messageSelector;
        return ((TopicSession)session.getRealSession()).createSubscriber((Topic)destination, messageSelector, noLocal);
    }

    protected TopicSubscriber createDurableSubscriber(ReconnectableSession session, Topic topic, String name) throws JMSException {
        this.destination = topic;
        return ((TopicSession)session.getRealSession()).createDurableSubscriber(topic, name);
    }

    protected TopicSubscriber createDurableSubscriber(ReconnectableSession session, Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.noLocal = noLocal;
        this.destination = topic;
        this.messageSelector = messageSelector;
        return ((TopicSession)session.getRealSession()).createDurableSubscriber(topic, name, messageSelector, noLocal);
    }

    public Topic getTopic() throws JMSException {
        return ((TopicSubscriber)this.messageConsumer).getTopic();
    }

    public boolean getNoLocal() throws JMSException {
        return ((TopicSubscriber)this.messageConsumer).getNoLocal();
    }
}

