/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import jp.ossc.nimbus.ioc.Command;
import jp.ossc.nimbus.service.journal.editor.BlockJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.CommandJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class CommandJournalEditorService
extends BlockJournalEditorServiceBase
implements CommandJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = 5955054609085701115L;
    protected static final String HEADER = "[Command]";
    private static final String FLOW_KEY_HEADER = "Flow key : ";
    private static final String INPUT_HEADER = "Input : ";
    private static final String OUTPUT_HEADER = "Output : ";
    private static final String STATUS_HEADER = "Status : ";
    private static final String EXCEPTION_HEADER = "Exception : ";
    private static final String STATUS_BEFORE = "Before";
    private static final String STATUS_COMPLETE = "Complete";
    private static final String STATUS_ERROR = "Error";
    private static final String STATUS_UNKNOWN = "Unknown";
    private boolean isOutputFlowKey = true;
    private boolean isOutputInput = true;
    private boolean isOutputOutput = true;
    private boolean isOutputStatus = true;
    private boolean isOutputException = true;

    public CommandJournalEditorService() {
        this.setHeader(HEADER);
    }

    public void setOutputFlowKey(boolean isOutput) {
        this.isOutputFlowKey = isOutput;
    }

    public boolean isOutputFlowKey() {
        return this.isOutputFlowKey;
    }

    public void setOutputInput(boolean isOutput) {
        this.isOutputInput = isOutput;
    }

    public boolean isOutputInput() {
        return this.isOutputInput;
    }

    public void setOutputOutput(boolean isOutput) {
        this.isOutputOutput = isOutput;
    }

    public boolean isOutputOutput() {
        return this.isOutputOutput;
    }

    public void setOutputStatus(boolean isOutput) {
        this.isOutputStatus = isOutput;
    }

    public boolean isOutputStatus() {
        return this.isOutputStatus;
    }

    public void setOutputException(boolean isOutput) {
        this.isOutputException = isOutput;
    }

    public boolean isOutputException() {
        return this.isOutputException;
    }

    protected boolean processBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        Command command = (Command)value;
        boolean isMake = false;
        if (this.isOutputFlowKey()) {
            this.makeFlowKeyFormat(finder, key, command, buf);
            isMake = true;
        }
        if (this.isOutputInput()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeInputFormat(finder, key, command, buf);
            isMake = true;
        }
        if (this.isOutputOutput()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeOutputFormat(finder, key, command, buf);
            isMake = true;
        }
        if (this.isOutputStatus()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeStatusFormat(finder, key, command, buf);
            isMake = true;
        }
        if (this.isOutputException()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeExceptionFormat(finder, key, command, buf);
            isMake = true;
        }
        return isMake;
    }

    protected StringBuffer makeFlowKeyFormat(EditorFinder finder, Object key, Command command, StringBuffer buf) {
        return buf.append(FLOW_KEY_HEADER).append(command.getFlowKey());
    }

    protected StringBuffer makeInputFormat(EditorFinder finder, Object key, Command command, StringBuffer buf) {
        buf.append(INPUT_HEADER);
        this.makeObjectFormat(finder, null, command.getInputObject(), buf);
        return buf;
    }

    protected StringBuffer makeOutputFormat(EditorFinder finder, Object key, Command command, StringBuffer buf) {
        buf.append(OUTPUT_HEADER);
        this.makeObjectFormat(finder, null, command.getOutputObject(), buf);
        return buf;
    }

    protected StringBuffer makeStatusFormat(EditorFinder finder, Object key, Command command, StringBuffer buf) {
        buf.append(STATUS_HEADER);
        switch (command.getStatus()) {
            case -1: {
                buf.append(STATUS_BEFORE);
                break;
            }
            case 0: {
                buf.append(STATUS_COMPLETE);
                break;
            }
            case 1: {
                buf.append(STATUS_ERROR);
                break;
            }
            default: {
                buf.append(STATUS_UNKNOWN);
            }
        }
        return buf;
    }

    protected StringBuffer makeExceptionFormat(EditorFinder finder, Object key, Command command, StringBuffer buf) {
        buf.append(EXCEPTION_HEADER);
        this.makeObjectFormat(finder, null, command.getException(), buf);
        return buf;
    }
}

