/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.resource.datasource;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.performance.PerformanceStatistics;
import jp.ossc.nimbus.service.resource.datasource.NimbusCallableStatement;
import jp.ossc.nimbus.service.resource.datasource.NimbusPreparedStatement;
import jp.ossc.nimbus.service.resource.datasource.NimbusStatement;
import jp.ossc.nimbus.service.sequence.Sequence;

public class NimbusJdbcConnection
implements Connection {
    private Journal journalService;
    private PerformanceStatistics performanceService;
    private Sequence sequenceService;
    private int journalLevel;
    private boolean mIsFakeClose = false;
    private Connection mConn = null;
    private ArrayList mStatementList = new ArrayList();

    public void setJournalService(Journal journal) {
        this.journalService = journal;
    }

    public void setPerformanceService(PerformanceStatistics perform) {
        this.performanceService = perform;
    }

    public void setSequenceService(Sequence sequenceService) {
        this.sequenceService = sequenceService;
    }

    public void setJournalLevel(int level) {
        this.journalLevel = level;
    }

    public int getJournalLevel() {
        return this.journalLevel;
    }

    public void setFakeMode(boolean isFake) {
        this.mIsFakeClose = isFake;
    }

    public NimbusJdbcConnection(Connection conn) {
        this.mConn = conn;
    }

    public int getHoldability() throws SQLException {
        return this.mConn.getHoldability();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.mConn.getTransactionIsolation();
    }

    public void clearWarnings() throws SQLException {
        this.mConn.clearWarnings();
    }

    public void trueClose() throws SQLException {
        for (int cnt = 0; cnt < this.mStatementList.size(); ++cnt) {
            Statement st = (Statement)this.mStatementList.get(cnt);
            st.close();
        }
        this.mStatementList.clear();
        this.mConn.close();
    }

    public void close() throws SQLException {
        if (!this.mIsFakeClose) {
            this.trueClose();
        }
    }

    public void commit() throws SQLException {
        this.mConn.commit();
    }

    public void rollback() throws SQLException {
        this.mConn.rollback();
    }

    public boolean getAutoCommit() throws SQLException {
        return this.mConn.getAutoCommit();
    }

    public boolean isClosed() throws SQLException {
        return this.mConn.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        return this.mConn.isReadOnly();
    }

    public void setHoldability(int arg0) throws SQLException {
        this.mConn.setHoldability(arg0);
    }

    public void setTransactionIsolation(int arg0) throws SQLException {
        this.mConn.setTransactionIsolation(arg0);
    }

    public void setTrueAutoCommit(boolean arg0) throws SQLException {
        this.mConn.setAutoCommit(arg0);
    }

    public void setAutoCommit(boolean arg0) throws SQLException {
        if (!this.mIsFakeClose) {
            this.mConn.setAutoCommit(arg0);
        }
    }

    public void setReadOnly(boolean arg0) throws SQLException {
        this.mConn.setReadOnly(arg0);
    }

    public String getCatalog() throws SQLException {
        return this.mConn.getCatalog();
    }

    public void setCatalog(String arg0) throws SQLException {
        this.mConn.setCatalog(arg0);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.mConn.getMetaData();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.mConn.getWarnings();
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.mConn.setSavepoint();
    }

    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        this.mConn.releaseSavepoint(arg0);
    }

    public void rollback(Savepoint arg0) throws SQLException {
        this.mConn.rollback(arg0);
    }

    public Statement createStatement() throws SQLException {
        Statement tmp = this.mConn.createStatement();
        NimbusStatement ret = new NimbusStatement(tmp);
        if (this.journalService != null) {
            ret.setJournalService(this.journalService, this.sequenceService, this.journalLevel);
        }
        if (this.performanceService != null) {
            ret.setPerformanceService(this.performanceService);
        }
        this.mStatementList.add(ret);
        return ret;
    }

    public Statement createStatement(int arg0, int arg1) throws SQLException {
        Statement tmp = this.mConn.createStatement(arg0, arg1);
        NimbusStatement ret = new NimbusStatement(tmp);
        if (this.journalService != null) {
            ret.setJournalService(this.journalService, this.sequenceService, this.journalLevel);
        }
        if (this.performanceService != null) {
            ret.setPerformanceService(this.performanceService);
        }
        this.mStatementList.add(ret);
        return ret;
    }

    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        Statement tmp = this.mConn.createStatement(arg0, arg1, arg2);
        NimbusStatement ret = new NimbusStatement(tmp);
        if (this.journalService != null) {
            ret.setJournalService(this.journalService, this.sequenceService, this.journalLevel);
        }
        if (this.performanceService != null) {
            ret.setPerformanceService(this.performanceService);
        }
        this.mStatementList.add(ret);
        return ret;
    }

    public Map getTypeMap() throws SQLException {
        return this.mConn.getTypeMap();
    }

    public void setTypeMap(Map arg0) throws SQLException {
        this.mConn.setTypeMap(arg0);
    }

    public String nativeSQL(String arg0) throws SQLException {
        return this.mConn.nativeSQL(arg0);
    }

    public CallableStatement prepareCall(String arg0) throws SQLException {
        CallableStatement tmp = this.mConn.prepareCall(arg0);
        NimbusCallableStatement ret = new NimbusCallableStatement(tmp, arg0);
        if (this.journalService != null) {
            ret.setJournalService(this.journalService, this.sequenceService, this.journalLevel);
        }
        if (this.performanceService != null) {
            ret.setPerformanceService(this.performanceService);
        }
        this.mStatementList.add(ret);
        return ret;
    }

    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        CallableStatement tmp = this.mConn.prepareCall(arg0, arg1, arg2);
        NimbusCallableStatement ret = new NimbusCallableStatement(tmp, arg0);
        if (this.journalService != null) {
            ret.setJournalService(this.journalService, this.sequenceService, this.journalLevel);
        }
        if (this.performanceService != null) {
            ret.setPerformanceService(this.performanceService);
        }
        this.mStatementList.add(ret);
        return ret;
    }

    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        CallableStatement tmp = this.mConn.prepareCall(arg0, arg1, arg2, arg3);
        NimbusCallableStatement ret = new NimbusCallableStatement(tmp, arg0);
        if (this.journalService != null) {
            ret.setJournalService(this.journalService, this.sequenceService, this.journalLevel);
        }
        if (this.performanceService != null) {
            ret.setPerformanceService(this.performanceService);
        }
        this.mStatementList.add(ret);
        return ret;
    }

    public PreparedStatement prepareStatement(String arg0) throws SQLException {
        PreparedStatement tmp = this.mConn.prepareStatement(arg0);
        NimbusPreparedStatement ret = new NimbusPreparedStatement(tmp, arg0);
        if (this.journalService != null) {
            ret.setJournalService(this.journalService, this.sequenceService, this.journalLevel);
        }
        if (this.performanceService != null) {
            ret.setPerformanceService(this.performanceService);
        }
        this.mStatementList.add(ret);
        return ret;
    }

    public PreparedStatement prepareStatement(String arg0, int arg1) throws SQLException {
        PreparedStatement tmp = this.mConn.prepareStatement(arg0, arg1);
        NimbusPreparedStatement ret = new NimbusPreparedStatement(tmp, arg0);
        if (this.journalService != null) {
            ret.setJournalService(this.journalService, this.sequenceService, this.journalLevel);
        }
        if (this.performanceService != null) {
            ret.setPerformanceService(this.performanceService);
        }
        this.mStatementList.add(ret);
        return ret;
    }

    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2) throws SQLException {
        PreparedStatement tmp = this.mConn.prepareStatement(arg0, arg1, arg2);
        NimbusPreparedStatement ret = new NimbusPreparedStatement(tmp, arg0);
        if (this.journalService != null) {
            ret.setJournalService(this.journalService, this.sequenceService, this.journalLevel);
        }
        if (this.performanceService != null) {
            ret.setPerformanceService(this.performanceService);
        }
        this.mStatementList.add(ret);
        return ret;
    }

    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        PreparedStatement tmp = this.mConn.prepareStatement(arg0, arg1, arg2, arg3);
        NimbusPreparedStatement ret = new NimbusPreparedStatement(tmp, arg0);
        if (this.journalService != null) {
            ret.setJournalService(this.journalService, this.sequenceService, this.journalLevel);
        }
        if (this.performanceService != null) {
            ret.setPerformanceService(this.performanceService);
        }
        this.mStatementList.add(ret);
        return ret;
    }

    public PreparedStatement prepareStatement(String arg0, int[] arg1) throws SQLException {
        PreparedStatement tmp = this.mConn.prepareStatement(arg0, arg1);
        NimbusPreparedStatement ret = new NimbusPreparedStatement(tmp, arg0);
        if (this.journalService != null) {
            ret.setJournalService(this.journalService, this.sequenceService, this.journalLevel);
        }
        if (this.performanceService != null) {
            ret.setPerformanceService(this.performanceService);
        }
        this.mStatementList.add(ret);
        return ret;
    }

    public Savepoint setSavepoint(String arg0) throws SQLException {
        return this.mConn.setSavepoint(arg0);
    }

    public PreparedStatement prepareStatement(String arg0, String[] arg1) throws SQLException {
        PreparedStatement tmp = this.mConn.prepareStatement(arg0, arg1);
        NimbusPreparedStatement ret = new NimbusPreparedStatement(tmp, arg0);
        if (this.journalService != null) {
            ret.setJournalService(this.journalService, this.sequenceService, this.journalLevel);
        }
        if (this.performanceService != null) {
            ret.setPerformanceService(this.performanceService);
        }
        this.mStatementList.add(ret);
        return ret;
    }
}

