/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import jp.ossc.nimbus.service.scheduler2.Schedule;

public class DefaultSchedule
implements Schedule,
Serializable,
Comparable {
    private static final long serialVersionUID = -2668833951199708052L;
    protected String id;
    protected String masterId;
    protected Date time;
    protected String taskName;
    protected Object input;
    protected String[] depends;
    protected Object output;
    protected boolean isRetry;
    protected Date initialTime;
    protected long retryInterval;
    protected Date retryEndTime;
    protected int state = 1;
    protected int controlState = 1;
    protected String executorKey;
    protected boolean isAbort;

    public DefaultSchedule() {
    }

    public DefaultSchedule(String id) {
        this.setId(id);
    }

    public DefaultSchedule(Date time) {
        this.setTime(time);
        this.setInitialTime(time);
    }

    public DefaultSchedule(String masterId, Date time, String taskName, Object input, String[] depends) {
        this(masterId, time, taskName, input, depends, 0L, null);
    }

    public DefaultSchedule(String masterId, Date time, String taskName, Object input, String[] depends, long retryInterval, Date retryEndTime) {
        this.setMasterId(masterId);
        this.setTime(time);
        this.setTaskName(taskName);
        this.setInput(input);
        this.setDepends(depends);
        this.setInitialTime(time);
        this.setRetryInterval(retryInterval);
        this.setRetryEndTime(retryEndTime);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMasterId() {
        return this.masterId;
    }

    public void setMasterId(String id) {
        this.masterId = id;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String name) {
        this.taskName = name;
    }

    public Object getInput() {
        return this.input;
    }

    public void setInput(Object data) {
        this.input = data;
    }

    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] ids) {
        this.depends = ids;
    }

    public Object getOutput() {
        return this.output;
    }

    public void setOutput(Object out) {
        this.output = out;
    }

    public Date getInitialTime() {
        return this.initialTime == null ? this.time : this.initialTime;
    }

    public void setInitialTime(Date time) {
        this.initialTime = time;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long interval) {
        this.retryInterval = interval;
    }

    public Date getRetryEndTime() {
        return this.retryEndTime;
    }

    public void setRetryEndTime(Date time) {
        this.retryEndTime = time;
    }

    public boolean isRetry() {
        return this.isRetry;
    }

    public void setRetry(boolean retry) {
        this.isRetry = retry;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getControlState() {
        return this.controlState;
    }

    public void setControlState(int state) {
        this.controlState = state;
    }

    public void setExecutorKey(String key) {
        this.executorKey = key;
    }

    public String getExecutorKey() {
        return this.executorKey;
    }

    public boolean isAbort() {
        return this.isAbort;
    }

    public void setAbort(boolean isAbort) {
        this.isAbort = isAbort;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule cmp = (Schedule)obj;
        return this.id == null && cmp.getId() == null || this.id != null && this.id.equals(cmp.getId());
    }

    public int compareTo(Object o) {
        int result;
        if (o == null || !(o instanceof Schedule)) {
            return -1;
        }
        if (o == this) {
            return 0;
        }
        Schedule cmp = (Schedule)o;
        if (this.time != null && cmp.getTime() == null) {
            return -1;
        }
        if (this.time == null && cmp.getTime() != null) {
            return 1;
        }
        if (this.time != null && cmp.getTime() != null && (result = this.time.compareTo(cmp.getTime())) != 0) {
            return result;
        }
        if (this.id == null && cmp.getId() == null) {
            return 0;
        }
        if (this.id != null && cmp.getId() == null) {
            return -1;
        }
        if (this.id == null && cmp.getId() != null) {
            return 1;
        }
        return this.id.compareTo(cmp.getId());
    }

    public String toString() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss SSS");
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append('{');
        buf.append("id=").append(this.id);
        buf.append(",masterId=").append(this.masterId);
        buf.append(",time=").append(this.time == null ? null : format.format(this.time));
        buf.append(",taskName=").append(this.taskName);
        buf.append(",input=").append(this.input);
        buf.append(",output=").append(this.output);
        buf.append(",isRetry=").append(this.isRetry);
        buf.append(",initialTime=").append(this.initialTime == null ? null : format.format(this.initialTime));
        buf.append(",retryInterval=").append(this.retryInterval);
        buf.append(",retryEndTime=").append(this.retryEndTime == null ? null : format.format(this.retryEndTime));
        buf.append(",executorKey=").append(this.executorKey);
        buf.append('}');
        return buf.toString();
    }
}

