/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.QueueSender;
import javax.jms.Session;
import javax.jms.TopicPublisher;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.jms.JMSMessageConsumerFactory;
import jp.ossc.nimbus.service.jms.JMSMessageProducerFactory;
import jp.ossc.nimbus.service.jms.JMSSessionFactory;
import jp.ossc.nimbus.service.scheduler2.AbstractSchedulerService;
import jp.ossc.nimbus.service.scheduler2.JMSSchedulerServiceMBean;
import jp.ossc.nimbus.service.scheduler2.Schedule;
import jp.ossc.nimbus.service.scheduler2.ScheduleStateControlException;

public class JMSSchedulerService
extends AbstractSchedulerService
implements MessageListener,
JMSSchedulerServiceMBean {
    private static final long serialVersionUID = 2070423795604696380L;
    protected static final String JMS_HEADER_SCHEDULE_ID = "SCHEDULE_ID";
    protected static final String JMS_HEADER_SCHEDULE_TASK_NAME = "SCHEDULE_TASK_NAME";
    protected static final String JMS_HEADER_SCHEDULE_REQUEST_ID = "SCHEDULE_REQUEST_ID";
    protected ServiceName sessionFactoryServiceName;
    protected JMSSessionFactory sessionFactory;
    protected ServiceName messageProducerFactoryServiceName;
    protected JMSMessageProducerFactory messageProducerFactory;
    protected ServiceName messageConsumerFactoryServiceName;
    protected JMSMessageConsumerFactory messageConsumerFactory;
    protected MessageConsumer[] messageConsumers;
    protected int messageConsumerSize = 1;
    protected int deliveryMode = 2;
    protected int priority = 4;
    protected long timeToLive = 0L;

    public void setJMSSessionFactoryServiceName(ServiceName name) {
        this.sessionFactoryServiceName = name;
    }

    public ServiceName getJMSSessionFactoryServiceName() {
        return this.sessionFactoryServiceName;
    }

    public void setJMSMessageProducerFactoryServiceName(ServiceName name) {
        this.messageProducerFactoryServiceName = name;
    }

    public ServiceName getJMSMessageProducerFactoryServiceName() {
        return this.messageProducerFactoryServiceName;
    }

    public void setJMSMessageConsumerFactoryServiceName(ServiceName name) {
        this.messageConsumerFactoryServiceName = name;
    }

    public ServiceName getJMSMessageConsumerFactoryServiceName() {
        return this.messageConsumerFactoryServiceName;
    }

    public void setMessageConsumerSize(int size) {
        if (this.messageConsumerSize <= 0) {
            throw new IllegalArgumentException("MessageConsumerSize > 0. size=" + size);
        }
        this.messageConsumerSize = size;
    }

    public int getMessageConsumerSize() {
        return this.messageConsumerSize;
    }

    public void setDeliveryMode(int mode) {
        this.deliveryMode = mode;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setTimeToLive(long millis) {
        this.timeToLive = millis;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void startService() throws Exception {
        if (this.sessionFactoryServiceName != null) {
            this.sessionFactory = (JMSSessionFactory)ServiceManagerFactory.getServiceObject(this.sessionFactoryServiceName);
        }
        if (this.sessionFactory == null) {
            throw new IllegalArgumentException("JMSSsessionFactory is null.");
        }
        if (this.messageProducerFactoryServiceName != null) {
            this.messageProducerFactory = (JMSMessageProducerFactory)ServiceManagerFactory.getServiceObject(this.messageProducerFactoryServiceName);
        }
        if (this.messageProducerFactory == null) {
            throw new IllegalArgumentException("JMSMessageProducerFactory is null.");
        }
        if (this.messageConsumerFactoryServiceName != null) {
            this.messageConsumerFactory = (JMSMessageConsumerFactory)ServiceManagerFactory.getServiceObject(this.messageConsumerFactoryServiceName);
        }
        if (this.messageConsumerFactory == null) {
            throw new IllegalArgumentException("JMSMessageConsumerFactory is null.");
        }
        this.messageConsumers = new MessageConsumer[this.messageConsumerSize];
        for (int i = 0; i < this.messageConsumerSize; ++i) {
            this.messageConsumers[i] = this.messageConsumerFactory.createConsumer();
            this.messageConsumers[i].setMessageListener((MessageListener)this);
        }
        this.messageConsumerFactory.getSessionFactory().getConnection().start();
    }

    public void stopService() throws Exception {
        try {
            this.messageConsumerFactory.getSessionFactory().getConnection().stop();
        }
        catch (JMSException e) {
            // empty catch block
        }
        for (int i = 0; i < this.messageConsumerSize; ++i) {
            try {
                this.messageConsumers[i].close();
                continue;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        this.messageConsumers = null;
    }

    protected boolean isTransactableQueue() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void entrySchedule(AbstractSchedulerService.ScheduleRequest request) throws Throwable {
        Session session;
        block8: {
            session = null;
            MessageProducer messageProducer = null;
            try {
                session = this.sessionFactory.getSession(this.isTransactionControl, 1);
                messageProducer = this.messageProducerFactory.createProducer(session, this.messageProducerFactory.getDestination());
                ObjectMessage message = session.createObjectMessage((Serializable)request);
                if (request.getRequestId() != null) {
                    message.setStringProperty(JMS_HEADER_SCHEDULE_REQUEST_ID, request.getRequestId());
                }
                Schedule schedule = request.getSchedule();
                message.setStringProperty(JMS_HEADER_SCHEDULE_ID, schedule.getId());
                message.setStringProperty(JMS_HEADER_SCHEDULE_TASK_NAME, schedule.getTaskName());
                if (messageProducer instanceof QueueSender) {
                    ((QueueSender)messageProducer).send((Message)message, this.deliveryMode, this.priority, this.timeToLive);
                } else {
                    ((TopicPublisher)messageProducer).send((Message)message, this.deliveryMode, this.priority, this.timeToLive);
                }
                Object var7_6 = null;
                if (messageProducer == null) break block8;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (messageProducer != null) {
                    messageProducer.close();
                }
                if (session != null) {
                    session.close();
                }
                throw throwable;
            }
            messageProducer.close();
        }
        if (session != null) {
            session.close();
        }
    }

    public void onMessage(Message message) {
        if (message == null) {
            return;
        }
        String requestId = null;
        String id = "UNKNOWN";
        String taskName = "UNKNOWN";
        AbstractSchedulerService.ScheduleRequest request = null;
        try {
            requestId = message.getStringProperty(JMS_HEADER_SCHEDULE_REQUEST_ID);
            if (requestId != null && this.threadContext != null) {
                this.threadContext.put("REQUEST_ID", requestId);
            }
            id = message.getStringProperty(JMS_HEADER_SCHEDULE_ID);
            taskName = message.getStringProperty(JMS_HEADER_SCHEDULE_TASK_NAME);
            request = (AbstractSchedulerService.ScheduleRequest)((ObjectMessage)message).getObject();
        }
        catch (JMSException e) {
            this.getLogger().write("AS___00002", new Object[]{id, taskName}, (Throwable)e);
            try {
                this.scheduleManager.changeState(id, 5);
            }
            catch (ScheduleStateControlException e2) {
                this.getLogger().write("AS___00001", new Object[]{id, taskName, new Integer(5)}, (Throwable)e2);
            }
        }
        this.dispatchSchedule(request);
    }
}

