/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jp.ossc.nimbus.beans.dataset.DataSet;
import jp.ossc.nimbus.beans.dataset.DataSetException;
import jp.ossc.nimbus.beans.dataset.Header;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.beans.dataset.RecordListPropertySchema;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.DOMHTMLConverter;
import jp.ossc.nimbus.util.converter.StreamConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DataSetXMLConverter
implements StreamConverter {
    private static final long serialVersionUID = -7027099857625192227L;
    private static final String ELEMENT_DATASET = "dataSet";
    private static final String ELEMENT_SCHEMA = "schema";
    private static final String ELEMENT_HEADER = "header";
    private static final String ELEMENT_RECORD_LIST = "recordList";
    private static final String ELEMENT_NESTED_RECORD_LIST = "nestedRecordList";
    private static final String ELEMENT_RECORD = "record";
    private static final String ATTRIBUTE_NAME = "name";
    public static final int DATASET_FROM_XML = 1;
    public static final int XML_FROM_DATASET = 2;
    protected int convertType;
    protected Map dataSetMap = new HashMap();
    protected boolean isOutputSchema = true;
    protected String xslFilePath;
    protected String characterEncodingToStream;
    protected String characterEncodingToObject;
    protected boolean isIgnoreUnknownElement;

    public DataSetXMLConverter() {
        this(1);
    }

    public DataSetXMLConverter(int type) {
        this.convertType = type;
    }

    public void setConvertType(int type) {
        this.convertType = type;
    }

    public int getConvertType() {
        return this.convertType;
    }

    public void setDataSet(String name, DataSet dataSet) {
        if (dataSet.getName() == null) {
            dataSet.setName(name);
        }
        this.dataSetMap.put(name, dataSet);
    }

    public void setOutputSchema(boolean isOutput) {
        this.isOutputSchema = isOutput;
    }

    public boolean isOutputSchema() {
        return this.isOutputSchema;
    }

    public void setXSLFilePath(String path) {
        this.xslFilePath = path;
    }

    public String getXSLFilePath() {
        return this.xslFilePath;
    }

    public void setCharacterEncodingToStream(String encoding) {
        this.characterEncodingToStream = encoding;
    }

    public String getCharacterEncodingToStream() {
        return this.characterEncodingToStream;
    }

    public void setCharacterEncodingToObject(String encoding) {
        this.characterEncodingToObject = encoding;
    }

    public String getCharacterEncodingToObject() {
        return this.characterEncodingToObject;
    }

    public void setIgnoreUnknownElement(boolean isIgnore) {
        this.isIgnoreUnknownElement = isIgnore;
    }

    public boolean isIgnoreUnknownElement() {
        return this.isIgnoreUnknownElement;
    }

    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        switch (this.convertType) {
            case 1: {
                return this.convertToStream(obj);
            }
            case 2: {
                if (obj instanceof File) {
                    return this.toDataSet((File)obj);
                }
                if (obj instanceof InputStream) {
                    return this.toDataSet((InputStream)obj);
                }
                throw new ConvertException("Invalid input type : " + obj.getClass());
            }
        }
        throw new ConvertException("Invalid convert type : " + this.convertType);
    }

    public InputStream convertToStream(Object obj) throws ConvertException {
        if (obj instanceof DataSet) {
            return this.toXML((DataSet)obj);
        }
        throw new ConvertException("Invalid input type : " + obj.getClass());
    }

    public Object convertToObject(InputStream is) throws ConvertException {
        return this.toDataSet(is);
    }

    protected DataSet toDataSet(InputStream is) throws ConvertException {
        DataSet dataSet = null;
        try {
            DocumentBuilderFactory domFactory;
            DocumentBuilder builder;
            Document doc;
            Element dataSetElement;
            String dataSetName;
            InputSource inputSource = new InputSource(is);
            if (this.characterEncodingToObject != null) {
                String encoding = (String)DOMHTMLConverter.IANA2JAVA_ENCODING_MAP.get(this.characterEncodingToObject);
                if (encoding == null) {
                    encoding = this.characterEncodingToObject;
                }
                inputSource.setEncoding(encoding);
            }
            if ((dataSet = (DataSet)this.dataSetMap.get(dataSetName = MetaData.getOptionalAttribute(dataSetElement = (doc = (builder = (domFactory = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(inputSource)).getDocumentElement(), ATTRIBUTE_NAME))) != null) {
                dataSet = dataSet.cloneSchema();
            } else {
                String schema;
                String recListName;
                Element recListElement;
                Element schemaElement = MetaData.getOptionalChild(dataSetElement, ELEMENT_SCHEMA);
                if (schemaElement == null) {
                    throw new ConvertException("Dataset is not found. name=" + dataSetName);
                }
                dataSet = new DataSet(dataSetName);
                Iterator headerElements = MetaData.getChildrenByTagName(schemaElement, ELEMENT_HEADER);
                while (headerElements.hasNext()) {
                    Element headerElement = (Element)headerElements.next();
                    String headerName = MetaData.getUniqueAttribute(headerElement, ATTRIBUTE_NAME);
                    String schema2 = MetaData.getElementContent(headerElement);
                    dataSet.setHeaderSchema(headerName, schema2);
                }
                Iterator recListElements = MetaData.getChildrenByTagName(schemaElement, ELEMENT_RECORD_LIST);
                while (recListElements.hasNext()) {
                    recListElement = (Element)recListElements.next();
                    recListName = MetaData.getUniqueAttribute(recListElement, ATTRIBUTE_NAME);
                    schema = MetaData.getElementContent(recListElement);
                    dataSet.setRecordListSchema(recListName, schema);
                }
                recListElements = MetaData.getChildrenByTagName(schemaElement, ELEMENT_NESTED_RECORD_LIST);
                while (recListElements.hasNext()) {
                    recListElement = (Element)recListElements.next();
                    recListName = MetaData.getUniqueAttribute(recListElement, ATTRIBUTE_NAME);
                    schema = MetaData.getElementContent(recListElement);
                    dataSet.setNestedRecordListSchema(recListName, schema);
                }
            }
            Iterator headerElements = MetaData.getChildrenByTagName(dataSetElement, ELEMENT_HEADER);
            while (headerElements.hasNext()) {
                Element headerElement = (Element)headerElements.next();
                this.readHeader(dataSet, headerElement);
            }
            Iterator recListElements = MetaData.getChildrenByTagName(dataSetElement, ELEMENT_RECORD_LIST);
            while (recListElements.hasNext()) {
                Element recListElement = (Element)recListElements.next();
                this.readRecordList(dataSet, recListElement);
            }
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ConvertException(e);
        }
        catch (SAXException e) {
            throw new ConvertException(e);
        }
        catch (DeploymentException e) {
            throw new ConvertException(e);
        }
        catch (DataSetException e) {
            throw new ConvertException(e);
        }
        return dataSet;
    }

    private DataSet readHeader(DataSet dataSet, Element headerElement) throws DeploymentException {
        String headerName = MetaData.getUniqueAttribute(headerElement, ATTRIBUTE_NAME);
        Header header = dataSet.getHeader(headerName);
        if (header == null) {
            if (this.isIgnoreUnknownElement) {
                return dataSet;
            }
            throw new ConvertException("Unknown header : " + headerName);
        }
        return this.readRecord(dataSet, header, headerElement);
    }

    private DataSet readRecord(DataSet dataSet, Record record, Element recordElement) throws DeploymentException {
        Iterator propElements = MetaData.getChildren(recordElement);
        RecordSchema recSchema = record.getRecordSchema();
        while (propElements.hasNext()) {
            Element propElement = (Element)propElements.next();
            String propName = propElement.getTagName();
            PropertySchema propSchema = recSchema.getPropertySchema(propName);
            if (propSchema == null && this.isIgnoreUnknownElement) continue;
            if (propSchema instanceof RecordListPropertySchema) {
                RecordList recList;
                RecordListPropertySchema recListPropSchema = (RecordListPropertySchema)propSchema;
                Element recListElement = MetaData.getOptionalChild(propElement, ELEMENT_RECORD_LIST);
                if (recListElement == null || (recList = dataSet.createNestedRecordList(recListPropSchema.getRecordListName())) == null) continue;
                this.readRecordList(dataSet, recList, recListElement);
                record.setProperty(propName, (Object)recList);
                continue;
            }
            record.setParseProperty(propName, (Object)MetaData.getElementContent(propElement));
        }
        return dataSet;
    }

    private DataSet readRecordList(DataSet dataSet, Element recListElement) throws DeploymentException {
        String recListName = MetaData.getUniqueAttribute(recListElement, ATTRIBUTE_NAME);
        RecordList recList = dataSet.getRecordList(recListName);
        if (recList == null) {
            if (this.isIgnoreUnknownElement) {
                return dataSet;
            }
            throw new ConvertException("Unknown recordList : " + recListName);
        }
        return this.readRecordList(dataSet, recList, recListElement);
    }

    private DataSet readRecordList(DataSet dataSet, RecordList recList, Element recListElement) throws DeploymentException {
        Iterator recordElements = MetaData.getChildrenByTagName(recListElement, ELEMENT_RECORD);
        while (recordElements.hasNext()) {
            Element recordElement = (Element)recordElements.next();
            Record record = recList.createRecord();
            this.readRecord(dataSet, record, recordElement);
            recList.addRecord(record);
        }
        return dataSet;
    }

    protected DataSet toDataSet(File file) throws ConvertException {
        try {
            return this.toDataSet(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
    }

    protected InputStream toXML(DataSet dataSet) throws ConvertException {
        ByteArrayInputStream is = null;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element dataSetElement = document.createElement(ELEMENT_DATASET);
            if (dataSet.getName() != null) {
                dataSetElement.setAttribute(ATTRIBUTE_NAME, dataSet.getName());
            }
            document.appendChild(dataSetElement);
            if (this.isOutputSchema) {
                Text schemaNode;
                Element recListElement;
                int i;
                Element schemaElement = document.createElement(ELEMENT_SCHEMA);
                dataSetElement.appendChild(schemaElement);
                String[] headerNames = dataSet.getHeaderNames();
                for (int i2 = 0; i2 < headerNames.length; ++i2) {
                    Header header = dataSet.getHeader(headerNames[i2]);
                    Element headerElement = document.createElement(ELEMENT_HEADER);
                    headerElement.setAttribute(ATTRIBUTE_NAME, headerNames[i2]);
                    schemaElement.appendChild(headerElement);
                    Text schemaNode2 = document.createTextNode(header.getSchema());
                    headerElement.appendChild(schemaNode2);
                }
                String[] recListNames = dataSet.getRecordListNames();
                for (i = 0; i < recListNames.length; ++i) {
                    RecordList recList = dataSet.getRecordList(recListNames[i]);
                    recListElement = document.createElement(ELEMENT_RECORD_LIST);
                    recListElement.setAttribute(ATTRIBUTE_NAME, recListNames[i]);
                    schemaElement.appendChild(recListElement);
                    schemaNode = document.createTextNode(recList.getSchema());
                    recListElement.appendChild(schemaNode);
                }
                recListNames = dataSet.getNestedRecordListSchemaNames();
                for (i = 0; i < recListNames.length; ++i) {
                    RecordSchema recSchema = dataSet.getNestedRecordListSchema(recListNames[i]);
                    recListElement = document.createElement(ELEMENT_NESTED_RECORD_LIST);
                    recListElement.setAttribute(ATTRIBUTE_NAME, recListNames[i]);
                    schemaElement.appendChild(recListElement);
                    schemaNode = document.createTextNode(recSchema.getSchema());
                    recListElement.appendChild(schemaNode);
                }
            }
            String[] headerNames = dataSet.getHeaderNames();
            for (int i = 0; i < headerNames.length; ++i) {
                Header header = dataSet.getHeader(headerNames[i]);
                this.appendRecord(dataSet, document, dataSetElement, header, ELEMENT_HEADER);
            }
            String[] recListNames = dataSet.getRecordListNames();
            for (int i = 0; i < recListNames.length; ++i) {
                RecordList recList = dataSet.getRecordList(recListNames[i]);
                this.appendRecordList(dataSet, document, dataSetElement, recList, ELEMENT_RECORD_LIST);
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = null;
            transformer = this.xslFilePath == null ? tFactory.newTransformer() : tFactory.newTransformer(new StreamSource(this.xslFilePath));
            if (this.characterEncodingToStream != null) {
                String encoding = (String)DOMHTMLConverter.IANA2JAVA_ENCODING_MAP.get(this.characterEncodingToStream);
                if (encoding == null) {
                    encoding = this.characterEncodingToStream;
                }
                transformer.setOutputProperty("encoding", encoding);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(document), new StreamResult(baos));
            is = new ByteArrayInputStream(baos.toByteArray());
        }
        catch (ParserConfigurationException e) {
            throw new ConvertException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new ConvertException(e);
        }
        catch (TransformerException e) {
            throw new ConvertException(e);
        }
        catch (DataSetException e) {
            throw new ConvertException(e);
        }
        return is;
    }

    private Element appendRecord(DataSet dataSet, Document document, Element parent, Record record, String elementName) {
        Element recordElement = document.createElement(elementName);
        if (record instanceof Header) {
            recordElement.setAttribute(ATTRIBUTE_NAME, ((Header)record).getName());
        }
        parent.appendChild(recordElement);
        RecordSchema recSchema = record.getRecordSchema();
        int jmax = recSchema.getPropertySize();
        for (int j = 0; j < jmax; ++j) {
            PropertySchema propSchema = recSchema.getPropertySchema(j);
            Element propElement = document.createElement(propSchema.getName());
            if (propSchema instanceof RecordListPropertySchema) {
                RecordList recList = (RecordList)record.getProperty(propSchema.getName());
                if (recList == null || recList.size() == 0) continue;
                this.appendRecordList(dataSet, document, propElement, recList, ELEMENT_RECORD_LIST);
                recordElement.appendChild(propElement);
                continue;
            }
            Object prop = record.getFormatProperty(propSchema.getName());
            if (prop == null) continue;
            Text valNode = document.createTextNode(prop.toString());
            propElement.appendChild(valNode);
            recordElement.appendChild(propElement);
        }
        return parent;
    }

    private Element appendRecordList(DataSet dataSet, Document document, Element parent, RecordList recList, String elementName) {
        if (recList == null || recList.size() == 0) {
            return parent;
        }
        Element recListElement = document.createElement(elementName);
        recListElement.setAttribute(ATTRIBUTE_NAME, recList.getName());
        parent.appendChild(recListElement);
        int jmax = recList.size();
        for (int j = 0; j < jmax; ++j) {
            Record record = recList.getRecord(j);
            this.appendRecord(dataSet, document, recListElement, record, ELEMENT_RECORD);
        }
        return parent;
    }
}

