/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.text.DecimalFormat;
import java.text.ParseException;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.FormatConverter;

public class DecimalFormatConverter
implements FormatConverter {
    private static final long serialVersionUID = -1183874197480695923L;
    public static final int NUMBER_FROM_STRING = 1;
    public static final int STRING_FROM_NUMBER = 2;
    protected static final String DOUBLE_NAN_STR;
    protected static final String DOUBLE_POSITIVE_INFINITY_STR;
    protected static final String DOUBLE_NEGATIVE_INFINITY_STR;
    protected int convertType;
    protected String format;

    public DecimalFormatConverter() {
        this(1, "");
    }

    public DecimalFormatConverter(int type, String format) {
        this.convertType = type;
        this.format = format;
        new DecimalFormat(format);
    }

    public void setConvertType(int type) {
        this.convertType = type;
    }

    public int getConvertType() {
        return this.convertType;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public Object convert(Object obj) throws ConvertException {
        switch (this.convertType) {
            case 1: {
                if (obj == null) {
                    return new DecimalFormat(this.format).format(new Long(0L));
                }
                return new DecimalFormat(this.format).format(obj);
            }
            case 2: {
                if (obj == null) {
                    return new Long(0L);
                }
                if (obj instanceof String) {
                    String val = (String)obj;
                    if (DOUBLE_NAN_STR.equals(val)) {
                        return new Double(Double.NaN);
                    }
                    if (DOUBLE_NEGATIVE_INFINITY_STR.equals(val)) {
                        return new Double(Double.NEGATIVE_INFINITY);
                    }
                    if (DOUBLE_POSITIVE_INFINITY_STR.equals(val)) {
                        return new Double(Double.POSITIVE_INFINITY);
                    }
                }
                try {
                    return new DecimalFormat(this.format).parse((String)obj);
                }
                catch (ParseException e) {
                    throw new ConvertException(e);
                }
            }
        }
        throw new ConvertException("Invalid convert type : " + this.convertType);
    }

    static {
        DecimalFormat f = new DecimalFormat("#.#");
        DOUBLE_NAN_STR = f.format(Double.NaN);
        DOUBLE_POSITIVE_INFINITY_STR = f.format(Double.POSITIVE_INFINITY);
        DOUBLE_NEGATIVE_INFINITY_STR = f.format(Double.NEGATIVE_INFINITY);
    }
}

