/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.validator;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import jp.ossc.nimbus.util.validator.ValidateException;
import jp.ossc.nimbus.util.validator.Validator;

public class NumberValidator
implements Validator,
Serializable {
    private static final long serialVersionUID = -1507930380189770984L;
    protected boolean isAllowNull = true;
    protected boolean isAllowNaN = true;
    protected boolean isAllowInfinity = true;
    protected boolean isAllowNumberString;
    protected BigDecimal moreThanValue;
    protected BigDecimal moreEqualValue;
    protected BigDecimal lessThanValue;
    protected BigDecimal lessEqualValue;
    protected BigDecimal equalValue;
    protected BigDecimal notEqualValue;

    public void setAllowNull(boolean isAllow) {
        this.isAllowNull = isAllow;
    }

    public boolean isAllowNull() {
        return this.isAllowNull;
    }

    public void setAllowNaN(boolean isAllow) {
        this.isAllowNaN = isAllow;
    }

    public boolean isAllowNaN() {
        return this.isAllowNaN;
    }

    public void setAllowInfinity(boolean isAllow) {
        this.isAllowInfinity = isAllow;
    }

    public boolean isAllowInfinity() {
        return this.isAllowInfinity;
    }

    public void setAllowNumberString(boolean isAllow) {
        this.isAllowNumberString = isAllow;
    }

    public boolean isAllowNumberString() {
        return this.isAllowNumberString;
    }

    public void setMoreThanValue(BigDecimal max) {
        this.moreThanValue = max;
    }

    public BigDecimal getMoreThanValue() {
        return this.moreThanValue;
    }

    public void setMoreEqualValue(BigDecimal max) {
        this.moreEqualValue = max;
    }

    public BigDecimal getMoreEqualValue() {
        return this.moreEqualValue;
    }

    public void setLessThanValue(BigDecimal min) {
        this.lessThanValue = min;
    }

    public BigDecimal getLessThanValue() {
        return this.lessThanValue;
    }

    public void setLessEqualValue(BigDecimal min) {
        this.lessEqualValue = min;
    }

    public BigDecimal getLessEqualValue() {
        return this.lessEqualValue;
    }

    public void setEqualValue(BigDecimal eq) {
        this.equalValue = eq;
    }

    public BigDecimal getEqualValue() {
        return this.equalValue;
    }

    public void setNotEqualValue(BigDecimal neq) {
        this.notEqualValue = neq;
    }

    public BigDecimal getNotEqualValue() {
        return this.notEqualValue;
    }

    public boolean validate(Object obj) throws ValidateException {
        if (obj == null) {
            return this.isAllowNull;
        }
        if (!(obj instanceof Number)) {
            if (obj instanceof String && this.isAllowNumberString) {
                return this.validateString((String)obj);
            }
            return false;
        }
        if (obj instanceof Byte) {
            return this.validate((Byte)obj);
        }
        if (obj instanceof Short) {
            return this.validate((Short)obj);
        }
        if (obj instanceof Integer) {
            return this.validate((Integer)obj);
        }
        if (obj instanceof Long) {
            return this.validate((Long)obj);
        }
        if (obj instanceof Float) {
            return this.validate(((Float)obj).floatValue());
        }
        if (obj instanceof Double) {
            return this.validate((Double)obj);
        }
        if (obj instanceof BigInteger) {
            return this.validateBigInteger((BigInteger)obj);
        }
        if (obj instanceof BigDecimal) {
            return this.validateBigDecimal((BigDecimal)obj);
        }
        throw new ValidateException("Not support number." + obj.getClass().getName());
    }

    public boolean validate(byte val) throws ValidateException {
        if (this.moreThanValue != null && this.moreThanValue.byteValue() >= val) {
            return false;
        }
        if (this.moreEqualValue != null && this.moreEqualValue.byteValue() > val) {
            return false;
        }
        if (this.lessThanValue != null && this.lessThanValue.byteValue() <= val) {
            return false;
        }
        if (this.lessEqualValue != null && this.lessEqualValue.byteValue() < val) {
            return false;
        }
        if (this.equalValue != null && this.equalValue.byteValue() != val) {
            return false;
        }
        return this.notEqualValue == null || this.notEqualValue.byteValue() != val;
    }

    public boolean validate(short val) throws ValidateException {
        if (this.moreThanValue != null && this.moreThanValue.shortValue() >= val) {
            return false;
        }
        if (this.moreEqualValue != null && this.moreEqualValue.shortValue() > val) {
            return false;
        }
        if (this.lessThanValue != null && this.lessThanValue.shortValue() <= val) {
            return false;
        }
        if (this.lessEqualValue != null && this.lessEqualValue.shortValue() < val) {
            return false;
        }
        if (this.equalValue != null && this.equalValue.shortValue() != val) {
            return false;
        }
        return this.notEqualValue == null || this.notEqualValue.shortValue() != val;
    }

    public boolean validate(int val) throws ValidateException {
        if (this.moreThanValue != null && this.moreThanValue.intValue() >= val) {
            return false;
        }
        if (this.moreEqualValue != null && this.moreEqualValue.intValue() > val) {
            return false;
        }
        if (this.lessThanValue != null && this.lessThanValue.intValue() <= val) {
            return false;
        }
        if (this.lessEqualValue != null && this.lessEqualValue.intValue() < val) {
            return false;
        }
        if (this.equalValue != null && this.equalValue.intValue() != val) {
            return false;
        }
        return this.notEqualValue == null || this.notEqualValue.intValue() != val;
    }

    public boolean validate(long val) throws ValidateException {
        if (this.moreThanValue != null && this.moreThanValue.longValue() >= val) {
            return false;
        }
        if (this.moreEqualValue != null && this.moreEqualValue.longValue() > val) {
            return false;
        }
        if (this.lessThanValue != null && this.lessThanValue.longValue() <= val) {
            return false;
        }
        if (this.lessEqualValue != null && this.lessEqualValue.longValue() < val) {
            return false;
        }
        if (this.equalValue != null && this.equalValue.longValue() != val) {
            return false;
        }
        return this.notEqualValue == null || this.notEqualValue.longValue() != val;
    }

    public boolean validate(float val) throws ValidateException {
        if (Float.isNaN(val)) {
            return this.isAllowNaN;
        }
        if (Float.isInfinite(val)) {
            return this.isAllowInfinity;
        }
        if (this.moreThanValue != null && this.moreThanValue.floatValue() >= val) {
            return false;
        }
        if (this.moreEqualValue != null && this.moreEqualValue.floatValue() > val) {
            return false;
        }
        if (this.lessThanValue != null && this.lessThanValue.floatValue() <= val) {
            return false;
        }
        if (this.lessEqualValue != null && this.lessEqualValue.floatValue() < val) {
            return false;
        }
        if (this.equalValue != null && this.equalValue.floatValue() != val) {
            return false;
        }
        return this.notEqualValue == null || this.notEqualValue.floatValue() != val;
    }

    public boolean validate(double val) throws ValidateException {
        if (Double.isNaN(val)) {
            return this.isAllowNaN;
        }
        if (Double.isInfinite(val)) {
            return this.isAllowInfinity;
        }
        if (this.moreThanValue != null && this.moreThanValue.doubleValue() >= val) {
            return false;
        }
        if (this.moreEqualValue != null && this.moreEqualValue.doubleValue() > val) {
            return false;
        }
        if (this.lessThanValue != null && this.lessThanValue.doubleValue() <= val) {
            return false;
        }
        if (this.lessEqualValue != null && this.lessEqualValue.doubleValue() < val) {
            return false;
        }
        if (this.equalValue != null && this.equalValue.doubleValue() != val) {
            return false;
        }
        return this.notEqualValue == null || this.notEqualValue.doubleValue() != val;
    }

    protected boolean validateBigInteger(BigInteger val) throws ValidateException {
        int comp;
        if (val == null) {
            return this.isAllowNull;
        }
        if (this.moreThanValue != null && (comp = this.moreThanValue.toBigInteger().compareTo(val)) >= 0) {
            return false;
        }
        if (this.moreEqualValue != null && (comp = this.moreEqualValue.toBigInteger().compareTo(val)) > 0) {
            return false;
        }
        if (this.lessThanValue != null && (comp = this.lessThanValue.toBigInteger().compareTo(val)) <= 0) {
            return false;
        }
        if (this.lessEqualValue != null && (comp = this.lessEqualValue.toBigInteger().compareTo(val)) < 0) {
            return false;
        }
        if (this.equalValue != null && (comp = this.equalValue.toBigInteger().compareTo(val)) != 0) {
            return false;
        }
        return this.notEqualValue == null || (comp = this.notEqualValue.toBigInteger().compareTo(val)) != 0;
    }

    protected boolean validateBigDecimal(BigDecimal val) throws ValidateException {
        int comp;
        if (val == null) {
            return this.isAllowNull;
        }
        if (this.moreThanValue != null && (comp = this.moreThanValue.compareTo(val)) >= 0) {
            return false;
        }
        if (this.moreEqualValue != null && (comp = this.moreEqualValue.compareTo(val)) > 0) {
            return false;
        }
        if (this.lessThanValue != null && (comp = this.lessThanValue.compareTo(val)) <= 0) {
            return false;
        }
        if (this.lessEqualValue != null && (comp = this.lessEqualValue.compareTo(val)) < 0) {
            return false;
        }
        if (this.equalValue != null && (comp = this.equalValue.compareTo(val)) != 0) {
            return false;
        }
        return this.notEqualValue == null || (comp = this.notEqualValue.compareTo(val)) != 0;
    }

    protected boolean validateString(String val) throws ValidateException {
        if (val == null) {
            return this.isAllowNull;
        }
        if (Double.toString(Double.NaN).equals(val)) {
            return this.isAllowNaN;
        }
        if (Double.toString(Double.NEGATIVE_INFINITY).equals(val) || Double.toString(Double.POSITIVE_INFINITY).equals(val)) {
            return this.isAllowInfinity;
        }
        try {
            return this.validateBigDecimal(new BigDecimal(val));
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

