/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.IfDefMetaData;
import jp.ossc.nimbus.core.ManagerPropertyMetaData;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.core.ServiceNameMetaData;
import org.w3c.dom.Element;

public class ManagerMetaData
extends MetaData
implements Serializable {
    private static final long serialVersionUID = 710269838167389543L;
    public static final String MANAGER_TAG_NAME = "manager";
    private static final String REPOSITORY_TAG_NAME = "repository";
    private static final String LOG_TAG_NAME = "log";
    private static final String MESSAGE_TAG_NAME = "message";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String SHUTDOWN_HOOK_ATTRIBUTE_NAME = "shutdown-hook";
    private String name;
    private boolean isExistShutdownHook;
    private final Map services = new LinkedHashMap();
    private ServiceNameMetaData repository;
    private ServiceNameMetaData log;
    private ServiceNameMetaData message;
    private ServiceLoader myLoader;
    private Map properties = new LinkedHashMap();
    private List ifDefMetaDataList;

    public ManagerMetaData() {
    }

    public ManagerMetaData(ServiceLoader loader, MetaData parent) {
        super(parent);
        this.myLoader = loader;
    }

    public ServiceLoader getServiceLoader() {
        return this.myLoader;
    }

    public void setServiceLoader(ServiceLoader loader) {
        this.myLoader = loader;
    }

    public String getName() {
        if (this.name == null) {
            return "Nimbus";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isExistShutdownHook() {
        return this.isExistShutdownHook;
    }

    public void setExistShutdownHook(boolean flg) {
        this.isExistShutdownHook = flg;
    }

    public ServiceNameMetaData getRepository() {
        return this.repository;
    }

    public void setRepository(ServiceNameMetaData data) {
        this.repository = data;
    }

    public ServiceNameMetaData getLog() {
        return this.log;
    }

    public void setLog(ServiceNameMetaData data) {
        this.log = data;
    }

    public ServiceNameMetaData getMessage() {
        return this.message;
    }

    public void setMessage(ServiceNameMetaData data) {
        this.message = data;
    }

    public ServiceMetaData getService(String name) {
        return (ServiceMetaData)this.services.get(name);
    }

    public Map getServices() {
        return this.services;
    }

    public void addService(ServiceMetaData service) {
        service.setServiceLoader(this.getServiceLoader());
        service.setManager(this);
        this.services.put(service.getName(), service);
    }

    public void removeService(String name) {
        this.services.remove(name);
    }

    public void clearServices() {
        this.services.clear();
    }

    public Set getPropertyNameSet() {
        return this.properties.keySet();
    }

    public String getProperty(String property) {
        ManagerPropertyMetaData propData = (ManagerPropertyMetaData)this.properties.get(property);
        return propData == null ? null : propData.getValue();
    }

    public Properties getProperties() {
        Properties props = new Properties();
        Iterator propDatas = this.properties.values().iterator();
        while (propDatas.hasNext()) {
            ManagerPropertyMetaData propData = (ManagerPropertyMetaData)propDatas.next();
            props.setProperty(propData.getName(), propData.getValue() == null ? "" : propData.getValue());
        }
        return props;
    }

    public void setProperty(String property, String value) {
        ManagerPropertyMetaData propData = (ManagerPropertyMetaData)this.properties.get(property);
        if (propData == null) {
            propData = new ManagerPropertyMetaData(this);
        }
        propData.setName(property);
        propData.setValue(value);
        this.properties.put(property, propData);
    }

    public void removeProperty(String property) {
        this.properties.remove(property);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public ServiceNameMetaData createRepositoryMetaData(String managerName, String serviceName) {
        return new ServiceNameMetaData(this, REPOSITORY_TAG_NAME, managerName, serviceName);
    }

    public ServiceNameMetaData createLogMetaData(String managerName, String serviceName) {
        return new ServiceNameMetaData(this, LOG_TAG_NAME, managerName, serviceName);
    }

    public ServiceNameMetaData createMessageMetaData(String managerName, String serviceName) {
        return new ServiceNameMetaData(this, MESSAGE_TAG_NAME, managerName, serviceName);
    }

    public void importXML(Element element) throws DeploymentException {
        super.importXML(element);
        if (!element.getTagName().equals(MANAGER_TAG_NAME)) {
            throw new DeploymentException("Tag must be manager : " + element.getTagName());
        }
        this.name = ManagerMetaData.getOptionalAttribute(element, NAME_ATTRIBUTE_NAME);
        String shutdownHook = ManagerMetaData.getOptionalAttribute(element, SHUTDOWN_HOOK_ATTRIBUTE_NAME);
        if (shutdownHook != null && shutdownHook.length() != 0) {
            this.isExistShutdownHook = Boolean.valueOf(shutdownHook);
        }
        this.importXMLInner(element, null);
        Iterator ifDefElements = ManagerMetaData.getChildrenByTagName(element, "ifdef");
        while (ifDefElements.hasNext()) {
            if (this.ifDefMetaDataList == null) {
                this.ifDefMetaDataList = new ArrayList();
            }
            IfDefMetaData ifdefData = new IfDefMetaData(this);
            ifdefData.importXML((Element)ifDefElements.next());
            this.ifDefMetaDataList.add(ifdefData);
        }
        if (this.ifDefMetaDataList == null || this.ifDefMetaDataList.size() == 0) {
            return;
        }
        int imax = this.ifDefMetaDataList.size();
        for (int i = 0; i < imax; ++i) {
            IfDefMetaData ifdefData = (IfDefMetaData)this.ifDefMetaDataList.get(i);
            Element ifDefElement = ifdefData.getElement();
            if (ifDefElement == null) continue;
            this.importXMLInner(ifDefElement, ifdefData);
            ifdefData.setElement(null);
        }
    }

    protected void importXMLInner(Element element, IfDefMetaData ifdefData) throws DeploymentException {
        Element messageElement;
        Element logElement;
        boolean ifdefMatch = ifdefData == null ? true : ifdefData.isMatch();
        Iterator propElements = ManagerMetaData.getChildrenByTagName(element, "manager-property");
        while (propElements.hasNext()) {
            ManagerPropertyMetaData propData = new ManagerPropertyMetaData(this);
            if (ifdefData != null) {
                propData.setIfDefMetaData(ifdefData);
                ifdefData.addChild(propData);
            }
            propData.importXML((Element)propElements.next());
            if (!ifdefMatch) continue;
            this.properties.put(propData.getName(), propData);
        }
        Element repositoryElement = ManagerMetaData.getOptionalChild(element, REPOSITORY_TAG_NAME);
        if (repositoryElement != null) {
            if (ifdefMatch && this.repository != null) {
                throw new DeploymentException("Element of repository is duplicated.");
            }
            ServiceNameMetaData tmp = new ServiceNameMetaData(this, this.getName());
            if (ifdefData != null) {
                tmp.setIfDefMetaData(ifdefData);
                ifdefData.addChild(tmp);
            }
            tmp.importXML(repositoryElement);
            if (ifdefMatch) {
                this.repository = tmp;
            }
        }
        if ((logElement = ManagerMetaData.getOptionalChild(element, LOG_TAG_NAME)) != null) {
            if (ifdefMatch && this.log != null) {
                throw new DeploymentException("Element of log is duplicated.");
            }
            ServiceNameMetaData tmp = new ServiceNameMetaData(this, this.getName());
            if (ifdefData != null) {
                tmp.setIfDefMetaData(ifdefData);
                ifdefData.addChild(tmp);
            }
            tmp.importXML(logElement);
            if (ifdefMatch) {
                this.log = tmp;
            }
        }
        if ((messageElement = ManagerMetaData.getOptionalChild(element, MESSAGE_TAG_NAME)) != null) {
            if (ifdefMatch && this.message != null) {
                throw new DeploymentException("Element of message is duplicated.");
            }
            ServiceNameMetaData tmp = new ServiceNameMetaData(this, this.getName());
            if (ifdefData != null) {
                tmp.setIfDefMetaData(ifdefData);
                ifdefData.addChild(tmp);
            }
            tmp.importXML(messageElement);
            if (ifdefMatch) {
                this.message = tmp;
            }
        }
        Iterator serviceElements = ManagerMetaData.getChildrenByTagName(element, "service");
        while (serviceElements.hasNext()) {
            ServiceMetaData serviceData = new ServiceMetaData(this.myLoader, (MetaData)this, this);
            if (ifdefData != null) {
                serviceData.setIfDefMetaData(ifdefData);
                ifdefData.addChild(serviceData);
            }
            serviceData.importXML((Element)serviceElements.next());
            if (ifdefMatch && this.services.containsKey(serviceData.getName())) {
                throw new DeploymentException("Dupulicated service name : " + serviceData.getName());
            }
            if (!ifdefMatch) continue;
            this.addService(serviceData);
        }
    }

    public StringBuffer toXML(StringBuffer buf) {
        this.appendComment(buf);
        buf.append('<').append(MANAGER_TAG_NAME);
        if (this.name != null) {
            buf.append(' ').append(NAME_ATTRIBUTE_NAME).append("=\"").append(this.name).append("\"");
        }
        if (this.isExistShutdownHook) {
            buf.append(' ').append(SHUTDOWN_HOOK_ATTRIBUTE_NAME).append("=\"").append(this.isExistShutdownHook).append("\"");
        }
        buf.append('>');
        if (this.properties.size() != 0) {
            buf.append(LINE_SEPARATOR);
            StringBuffer subBuf = new StringBuffer();
            Iterator props = this.properties.values().iterator();
            while (props.hasNext()) {
                ManagerPropertyMetaData propData = (ManagerPropertyMetaData)props.next();
                if (propData.getIfDefMetaData() != null) continue;
                propData.toXML(subBuf);
                if (!props.hasNext()) continue;
                subBuf.append(LINE_SEPARATOR);
            }
            buf.append(this.addIndent(subBuf));
        }
        if (this.repository != null && this.repository.getIfDefMetaData() == null) {
            buf.append(LINE_SEPARATOR);
            buf.append(this.addIndent(this.repository.toXML(new StringBuffer())));
        }
        if (this.log != null && this.log.getIfDefMetaData() == null) {
            buf.append(LINE_SEPARATOR);
            buf.append(this.addIndent(this.log.toXML(new StringBuffer())));
        }
        if (this.message != null && this.message.getIfDefMetaData() == null) {
            buf.append(LINE_SEPARATOR);
            buf.append(this.addIndent(this.message.toXML(new StringBuffer())));
        }
        if (this.services.size() != 0) {
            buf.append(LINE_SEPARATOR);
            Iterator datas = this.services.values().iterator();
            while (datas.hasNext()) {
                MetaData data = (MetaData)datas.next();
                if (data.getIfDefMetaData() != null) continue;
                buf.append(this.addIndent(data.toXML(new StringBuffer())));
                if (!datas.hasNext()) continue;
                buf.append(LINE_SEPARATOR);
            }
        }
        buf.append(LINE_SEPARATOR);
        if (this.ifDefMetaDataList != null && this.ifDefMetaDataList.size() != 0) {
            int imax = this.ifDefMetaDataList.size();
            for (int i = 0; i < imax; ++i) {
                IfDefMetaData ifdefData = (IfDefMetaData)this.ifDefMetaDataList.get(i);
                buf.append(this.addIndent(ifdefData.toXML(new StringBuffer())));
                buf.append(LINE_SEPARATOR);
            }
        }
        buf.append("</").append(MANAGER_TAG_NAME).append('>');
        return buf;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('{');
        if (this.getName() != null) {
            buf.append(NAME_ATTRIBUTE_NAME);
            buf.append('=');
            buf.append(this.getName());
            buf.append(',');
        }
        buf.append(SHUTDOWN_HOOK_ATTRIBUTE_NAME);
        buf.append('=');
        buf.append(this.isExistShutdownHook);
        buf.append('}');
        return buf.toString();
    }
}

