/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.ioc.ejb;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.ioc.Command;
import jp.ossc.nimbus.ioc.CommandBase;
import jp.ossc.nimbus.ioc.FacadeValue;
import jp.ossc.nimbus.ioc.FacadeValueAccess;
import jp.ossc.nimbus.ioc.IOCException;
import jp.ossc.nimbus.ioc.UnitOfWork;
import jp.ossc.nimbus.ioc.ejb.UtilTool;
import jp.ossc.nimbus.ioc.ejb.command.SLSBCommandHomeLocal;
import jp.ossc.nimbus.ioc.ejb.command.SLSBCommandLocal;
import jp.ossc.nimbus.ioc.ejb.unitofwork.SLSBUnitOfWorkHomeLocal;
import jp.ossc.nimbus.ioc.ejb.unitofwork.SLSBUnitOfWorkLocal;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InterceptorChainFactory;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorChainInvoker;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorChainInvokerFactory;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorException;
import jp.ossc.nimbus.service.aspect.interfaces.TargetCheckedException;
import jp.ossc.nimbus.service.aspect.interfaces.TargetUncheckedException;
import jp.ossc.nimbus.service.log.Logger;

public abstract class EJBDriveDispatcher {
    private SessionContext mContext = null;
    private SLSBUnitOfWorkHomeLocal mUnitOfWorkInvokerHome = null;
    private SLSBUnitOfWorkLocal mUnitOfWorkInvokerRemote = null;
    private SLSBCommandHomeLocal mCommandInvokerHome = null;
    private SLSBCommandLocal mCommandInvokerRemote = null;
    private InterceptorChainInvokerFactory mFactory = null;
    private InterceptorChainFactory chainFactory = null;
    private String mInterceptorKey = null;
    private Logger mLogger = null;
    protected final String IOC__00001 = "IOC__00001";
    protected final String IOC__00002 = "IOC__00002";
    protected final String IOC__00003 = "IOC__00003";

    public void init(String unitOfWorkKey, String commandKey, String intercetorFactrySvcName, String interceptorCreateKey, String loggerServiceName) throws NamingException, CreateException {
        ServiceName serviceName;
        InitialContext ctx = new InitialContext();
        String value = null;
        try {
            value = (String)ctx.lookup(loggerServiceName);
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (value == null || value.length() == 0) {
            this.mLogger = null;
        } else {
            serviceName = UtilTool.convertServiceName(value);
            this.mLogger = (Logger)((Object)ServiceManagerFactory.getService(serviceName));
        }
        value = (String)ctx.lookup(unitOfWorkKey);
        this.mUnitOfWorkInvokerHome = (SLSBUnitOfWorkHomeLocal)ctx.lookup(value);
        value = (String)ctx.lookup(commandKey);
        this.mCommandInvokerHome = (SLSBCommandHomeLocal)ctx.lookup(value);
        value = (String)ctx.lookup(intercetorFactrySvcName);
        if (value == null || value.length() == 0) {
            this.mFactory = null;
        } else {
            serviceName = UtilTool.convertServiceName(value);
            Service factory = ServiceManagerFactory.getService(serviceName);
            if (factory instanceof InterceptorChainInvokerFactory) {
                this.mFactory = (InterceptorChainInvokerFactory)((Object)factory);
            } else if (factory instanceof InterceptorChainFactory) {
                this.chainFactory = (InterceptorChainFactory)((Object)factory);
            }
            this.mInterceptorKey = value = (String)ctx.lookup(interceptorCreateKey);
        }
        if (this.getLogger() != null) {
            this.getLogger().write("IOC__00001", (Object)"InterceptorChainInvokerFactory get completed.");
        }
    }

    protected Logger getLogger() {
        return this.mLogger;
    }

    public Object invokeInterceptor(Object input) throws InterceptorException, TargetCheckedException, TargetUncheckedException {
        Object ret;
        block16: {
            ret = null;
            if (this.mFactory == null && this.chainFactory == null) {
                try {
                    ret = this.invokeUnitOfWorkBase((UnitOfWork)input);
                }
                catch (IOCException e) {
                    throw new TargetUncheckedException(e.getCause());
                }
                catch (Throwable e) {
                    if (this.getLogger() != null) {
                        this.getLogger().write("IOC__00018", e);
                    }
                    throw new TargetUncheckedException(e);
                }
            }
            if (this.getLogger() != null) {
                this.getLogger().write("IOC__00004", (Object)this.getInterceptorKey());
            }
            if (this.mFactory != null) {
                InterceptorChainInvoker ici = this.mFactory.createInterceptorInvoker(this.getInterceptorKey());
                ret = ici.invokeChain(this, input);
            } else if (this.chainFactory != null) {
                try {
                    InterceptorChain chain = this.chainFactory.getInterceptorChain(this.getInterceptorKey());
                    ret = chain.invokeNext(this.createInvocationContext(input));
                }
                catch (TargetUncheckedException e) {
                    throw e;
                }
                catch (TargetCheckedException e) {
                    throw e;
                }
                catch (InterceptorException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOCException(e);
                }
                catch (Throwable th) {
                    if (!(th instanceof Error)) break block16;
                    throw (Error)th;
                }
            }
        }
        return ret;
    }

    public UnitOfWork invokeUnitOfWorkBase(UnitOfWork uow) throws Exception {
        FacadeValue retUow = FacadeValueAccess.createCommandsValue();
        boolean cmdErrFlg = false;
        if (this.getLogger() != null) {
            this.getLogger().write("IOC__00002");
        }
        for (int rcnt = 0; rcnt < uow.size(); ++rcnt) {
            CommandBase tmp = uow.getCommand(rcnt);
            try {
                CommandBase ret;
                if (tmp.isCommand()) {
                    if (!cmdErrFlg) {
                        if (this.mCommandInvokerRemote == null) {
                            this.mCommandInvokerRemote = this.mCommandInvokerHome.create();
                            if (this.getLogger() != null) {
                                this.getLogger().write("IOC__00001", (Object)"SLSBCommandHomeLocal get cmpleted.");
                            }
                        }
                        if ((ret = this.mCommandInvokerRemote.invokeCommand((Command)tmp)).getStatus() == 1) {
                            if (this.getLogger() != null) {
                                this.getLogger().write("IOC__00020");
                            }
                            this.getContext().setRollbackOnly();
                            cmdErrFlg = true;
                        }
                        retUow.addCommand((Command)ret);
                        continue;
                    }
                    if (this.getLogger() != null) {
                        this.getLogger().write("IOC__00021");
                    }
                    retUow.addCommand((Command)tmp);
                    continue;
                }
                if (this.getLogger() != null) {
                    this.getLogger().write("IOC__00015");
                }
                if (this.mUnitOfWorkInvokerRemote == null) {
                    this.mUnitOfWorkInvokerRemote = this.mUnitOfWorkInvokerHome.create();
                    if (this.getLogger() != null) {
                        this.getLogger().write("IOC__00001", (Object)"SLSBUnitOfWorkHomeLocal get cmpleted.");
                    }
                }
                ret = this.mUnitOfWorkInvokerRemote.invokeUnitOfWork((UnitOfWork)tmp);
                retUow.addUnitOfWork((UnitOfWork)ret);
                continue;
            }
            catch (EJBException e) {
                if (this.getLogger() != null) {
                    this.getLogger().write("IOC__00017", e.getCausedByException());
                }
                Exception ex = e.getCausedByException();
                throw ex;
            }
            catch (Throwable e) {
                if (this.getLogger() != null) {
                    this.getLogger().write("IOC__00017", e);
                }
                IOCException ex = new IOCException("EJBDispatcher#invokeUnitOfWorkBase Unrecognized Error ", e);
                throw ex;
            }
        }
        return retUow;
    }

    public SessionContext getContext() {
        return this.mContext;
    }

    public InterceptorChainInvokerFactory getFactory() {
        return this.mFactory;
    }

    public String getInterceptorKey() {
        return this.mInterceptorKey;
    }

    public void setContext(SessionContext context) {
        this.mContext = context;
    }

    public void setInterceptorKey(String string) {
        this.mInterceptorKey = string;
    }

    public InterceptorChainFactory getInterceptorChainFactory() {
        return this.chainFactory;
    }

    protected abstract InvocationContext createInvocationContext(Object var1);
}

