/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.CheckPointInterceptorServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.CheckPointTracer;

public class CheckPointInterceptorService
extends ServiceBase
implements Interceptor,
CheckPointInterceptorServiceMBean {
    private static final long serialVersionUID = -7319984801053501636L;
    private String checkPointName;
    private boolean enabled = true;
    private List passOverThreads = new ArrayList();
    private ServiceName checkPointTracerServiceName;
    private CheckPointTracer checkPointTracer;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List passOverThreads() {
        List list = this.passOverThreads;
        synchronized (list) {
            return new ArrayList(this.passOverThreads);
        }
    }

    public void clear() {
        if (this.passOverThreads != null) {
            this.passOverThreads.clear();
        }
    }

    public void setCheckPointName(String name) {
        this.checkPointName = name;
    }

    public String getCheckPointName() {
        if (this.checkPointName == null && this.getServiceNameObject() != null) {
            return this.getServiceNameObject().toString();
        }
        return this.checkPointName;
    }

    public void setCheckPointTracerServiceName(ServiceName name) {
        this.checkPointTracerServiceName = name;
    }

    public ServiceName getCheckPointTracerServiceName() {
        return this.checkPointTracerServiceName;
    }

    public void setCheckPointTracer(CheckPointTracer tracer) {
        this.checkPointTracer = tracer;
    }

    public void startService() throws Exception {
        if (this.checkPointTracerServiceName != null) {
            this.checkPointTracer = (CheckPointTracer)ServiceManagerFactory.getServiceObject(this.checkPointTracerServiceName);
        }
    }

    public void stopService() throws Exception {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3 && this.enabled) {
            String threadName = Thread.currentThread().getName();
            List list = this.passOverThreads;
            synchronized (list) {
                this.passOverThreads.add(threadName);
            }
            if (this.checkPointTracer != null) {
                this.checkPointTracer.passedCheckPoint(threadName, this);
            }
        }
        return chain.invokeNext(context);
    }
}

