/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.connection;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.connection.TableCreatorServiceMBean;
import jp.ossc.nimbus.util.ClassMappingTree;
import jp.ossc.nimbus.util.converter.BindingStreamConverter;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.StreamConverter;

public class TableCreatorService
extends ServiceBase
implements TableCreatorServiceMBean {
    private static final long serialVersionUID = 3473661138375595733L;
    private ServiceName connectionFactoryServiceName;
    private ConnectionFactory connectionFactory;
    private ServiceName recordListConverterServiceName;
    private StreamConverter recordListConverter;
    private String existsTableQuery;
    private String selectQuery;
    private String createTableQuery;
    private String[] preCreateTableQueries;
    private String[] postCreateTableQueries;
    private String dropTableQuery;
    private String[] preDropTableQueries;
    private String[] postDropTableQueries;
    private String deleteQuery;
    private String insertQuery;
    private String insertRecords;
    private String insertRecordsFilePath;
    private String recordListSchema;
    private RecordList recordList;
    private String backupFilePath;
    private RecordList backupRecordList;
    private int insertBatchSize = 0;
    private boolean isBackupOnStart = false;
    private boolean isRestoreOnStart = false;
    private boolean isDropTableOnStart = false;
    private boolean isCreateTableOnStart = false;
    private boolean isDeleteOnStart = false;
    private boolean isInsertOnStart = false;
    private boolean isDeleteOnStop = false;
    private boolean isInsertOnStop = false;
    private boolean isDropTableOnStop = false;
    private boolean isRestoreOnStop = false;
    private boolean isBackupOnStop = false;
    private int[] ignoreSQLExceptionErrorCodeOnSelect;
    private int[] ignoreSQLExceptionErrorCodeOnDropTable;
    private int[] ignoreSQLExceptionErrorCodeOnDelete;
    private int[] ignoreSQLExceptionErrorCodeOnCreateTable;
    private int[] ignoreSQLExceptionErrorCodeOnInsert;
    private boolean isTransacted = false;
    private ClassMappingTree sqlTypeMap;

    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    public void setRecordListConverterServiceName(ServiceName name) {
        this.recordListConverterServiceName = name;
    }

    public ServiceName getRecordListConverterServiceName() {
        return this.recordListConverterServiceName;
    }

    public void setExistsTableQuery(String query) {
        this.existsTableQuery = query;
    }

    public String getExistsTableQuery() {
        return this.existsTableQuery;
    }

    public void setSelectQuery(String query) {
        this.selectQuery = query;
    }

    public String getSelectQuery() {
        return this.selectQuery;
    }

    public void setCreateTableQuery(String query) {
        this.createTableQuery = query;
    }

    public String getCreateTableQuery() {
        return this.createTableQuery;
    }

    public void setPreCreateTableQueries(String[] queries) {
        this.preCreateTableQueries = queries;
    }

    public String[] getPreCreateTableQueries() {
        return this.preCreateTableQueries;
    }

    public void setPostCreateTableQueries(String[] queries) {
        this.postCreateTableQueries = queries;
    }

    public String[] getPostCreateTableQueries() {
        return this.postCreateTableQueries;
    }

    public void setDropTableQuery(String query) {
        this.dropTableQuery = query;
    }

    public String getDropTableQuery() {
        return this.dropTableQuery;
    }

    public void setPreDropTableQueries(String[] queries) {
        this.preDropTableQueries = queries;
    }

    public String[] getPreDropTableQueries() {
        return this.preDropTableQueries;
    }

    public void setPostDropTableQueries(String[] queries) {
        this.postDropTableQueries = queries;
    }

    public String[] getPostDropTableQueries() {
        return this.postDropTableQueries;
    }

    public void setDeleteQuery(String query) {
        this.deleteQuery = query;
    }

    public String getDeleteQuery() {
        return this.deleteQuery;
    }

    public void setInsertQuery(String query) {
        this.insertQuery = query;
    }

    public String getInsertQuery() {
        return this.insertQuery;
    }

    public void setInsertRecords(String records) {
        this.insertRecords = records;
    }

    public String getInsertRecords() {
        return this.insertRecords;
    }

    public void setInsertRecordsFilePath(String path) {
        this.insertRecordsFilePath = path;
    }

    public String getInsertRecordsFilePath() {
        return this.insertRecordsFilePath;
    }

    public void setRecordListSchema(String schema) {
        this.recordListSchema = schema;
    }

    public String getRecordListSchema() {
        return this.recordListSchema;
    }

    public void setRecordList(RecordList list) {
        this.recordList = list;
    }

    public RecordList getRecordList() {
        return this.recordList;
    }

    public void setInsertBatchSize(int size) {
        this.insertBatchSize = size;
    }

    public int getInsertBatchSize() {
        return this.insertBatchSize;
    }

    public void setBackupOnStart(boolean isBackup) {
        this.isBackupOnStart = isBackup;
    }

    public boolean isBackupOnStart() {
        return this.isBackupOnStart;
    }

    public void setRestoreOnStart(boolean isRestore) {
        this.isRestoreOnStart = isRestore;
    }

    public boolean isRestoreOnStart() {
        return this.isRestoreOnStart;
    }

    public void setDropTableOnStart(boolean isDrop) {
        this.isDropTableOnStart = isDrop;
    }

    public boolean isDropTableOnStart() {
        return this.isDropTableOnStart;
    }

    public void setCreateTableOnStart(boolean isCreate) {
        this.isCreateTableOnStart = isCreate;
    }

    public boolean isCreateTableOnStart() {
        return this.isCreateTableOnStart;
    }

    public void setDeleteOnStart(boolean isDelete) {
        this.isDeleteOnStart = isDelete;
    }

    public boolean isDeleteOnStart() {
        return this.isDeleteOnStart;
    }

    public void setInsertOnStart(boolean isInsert) {
        this.isInsertOnStart = isInsert;
    }

    public boolean isInsertOnStart() {
        return this.isInsertOnStart;
    }

    public void setDeleteOnStop(boolean isDelete) {
        this.isDeleteOnStop = isDelete;
    }

    public boolean isDeleteOnStop() {
        return this.isDeleteOnStop;
    }

    public void setInsertOnStop(boolean isInsert) {
        this.isInsertOnStop = isInsert;
    }

    public boolean isInsertOnStop() {
        return this.isInsertOnStop;
    }

    public void setDropTableOnStop(boolean isDrop) {
        this.isDropTableOnStop = isDrop;
    }

    public boolean isDropTableOnStop() {
        return this.isDropTableOnStop;
    }

    public void setRestoreOnStop(boolean isRestore) {
        this.isRestoreOnStop = isRestore;
    }

    public boolean isRestoreOnStop() {
        return this.isRestoreOnStop;
    }

    public void setBackupOnStop(boolean isBackup) {
        this.isBackupOnStop = isBackup;
    }

    public boolean isBackupOnStop() {
        return this.isBackupOnStop;
    }

    public void setIgnoreSQLExceptionErrorCodeOnSelect(int[] code) {
        this.ignoreSQLExceptionErrorCodeOnSelect = code;
    }

    public int[] getIgnoreSQLExceptionErrorCodeOnSelect() {
        return this.ignoreSQLExceptionErrorCodeOnSelect;
    }

    public void setIgnoreSQLExceptionErrorCodeOnDropTable(int[] code) {
        this.ignoreSQLExceptionErrorCodeOnDropTable = code;
    }

    public int[] getIgnoreSQLExceptionErrorCodeOnDropTable() {
        return this.ignoreSQLExceptionErrorCodeOnDropTable;
    }

    public void setIgnoreSQLExceptionErrorCodeOnDelete(int[] code) {
        this.ignoreSQLExceptionErrorCodeOnDelete = code;
    }

    public int[] getIgnoreSQLExceptionErrorCodeOnDelete() {
        return this.ignoreSQLExceptionErrorCodeOnDelete;
    }

    public void setIgnoreSQLExceptionErrorCodeOnCreateTable(int[] code) {
        this.ignoreSQLExceptionErrorCodeOnCreateTable = code;
    }

    public int[] getIgnoreSQLExceptionErrorCodeOnCreateTable() {
        return this.ignoreSQLExceptionErrorCodeOnCreateTable;
    }

    public void setIgnoreSQLExceptionErrorCodeOnInsert(int[] code) {
        this.ignoreSQLExceptionErrorCodeOnInsert = code;
    }

    public int[] getIgnoreSQLExceptionErrorCodeOnInsert() {
        return this.ignoreSQLExceptionErrorCodeOnInsert;
    }

    public void setTransacted(boolean isTransacted) {
        this.isTransacted = isTransacted;
    }

    public boolean isTransacted() {
        return this.isTransacted;
    }

    public void setSqlType(Class type, int sqlType) {
        this.sqlTypeMap.add(type, new Integer(sqlType), true);
    }

    public void setBackupFilePath(String path) {
        this.backupFilePath = path;
    }

    public String getBackupFilePath() {
        return this.backupFilePath;
    }

    public void createService() throws Exception {
        this.sqlTypeMap = new ClassMappingTree(new Integer(2000));
        this.sqlTypeMap.add(Boolean.class, new Integer(-7));
        this.sqlTypeMap.add(Byte.class, new Integer(2));
        this.sqlTypeMap.add(Short.class, new Integer(2));
        this.sqlTypeMap.add(Integer.class, new Integer(4));
        this.sqlTypeMap.add(Long.class, new Integer(-5));
        this.sqlTypeMap.add(BigDecimal.class, new Integer(3));
        this.sqlTypeMap.add(Float.class, new Integer(7));
        this.sqlTypeMap.add(Double.class, new Integer(8));
        this.sqlTypeMap.add(Character.class, new Integer(1));
        this.sqlTypeMap.add(String.class, new Integer(12));
        this.sqlTypeMap.add(Date.class, new Integer(91));
        this.sqlTypeMap.add(Time.class, new Integer(92));
        this.sqlTypeMap.add(Timestamp.class, new Integer(93));
    }

    public void startService() throws Exception {
        if (this.connectionFactoryServiceName != null) {
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        }
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("ConnectionFactory is null.");
        }
        if (this.recordListConverterServiceName != null) {
            this.recordListConverter = (StreamConverter)ServiceManagerFactory.getServiceObject(this.recordListConverterServiceName);
        }
        if ((this.insertQuery != null || this.selectQuery != null && this.backupFilePath != null) && this.recordListConverter == null) {
            throw new IllegalArgumentException("RecordListConverter is null.");
        }
        if (this.recordList != null) {
            this.backupRecordList = this.recordList.cloneSchema();
        } else if (this.recordListSchema != null) {
            this.backupRecordList = new RecordList();
            this.backupRecordList.setSchema(this.recordListSchema);
        }
        Connection con = this.connectionFactory.getConnection();
        if (this.isTransacted && con.getAutoCommit()) {
            con.setAutoCommit(false);
        }
        try {
            if (this.isBackupOnStart) {
                this.backupRecords(con);
            }
            if (this.isDropTableOnStart) {
                this.dropTable(con);
            }
            if (this.isDeleteOnStart) {
                this.deleteRecords(con);
            }
            if (this.isCreateTableOnStart) {
                this.createTable(con);
            }
            if (this.isInsertOnStart) {
                this.insertRecords(con);
            }
            if (this.isRestoreOnStart) {
                this.restoreRecords(con);
            }
            if (this.isTransacted) {
                con.commit();
            }
        }
        catch (SQLException e) {
            if (this.isTransacted) {
                con.rollback();
            }
            throw e;
        }
        finally {
            con.close();
        }
    }

    public void stopService() throws Exception {
        Connection con = this.connectionFactory.getConnection();
        if (this.isTransacted && con.getAutoCommit()) {
            con.setAutoCommit(false);
        }
        try {
            if (this.isBackupOnStop) {
                this.backupRecords(con);
            }
            if (this.isDeleteOnStop) {
                this.deleteRecords(con);
            }
            if (this.isInsertOnStop) {
                this.insertRecords(con);
            }
            if (this.isDropTableOnStop) {
                this.dropTable(con);
            }
            if (this.isRestoreOnStop) {
                this.restoreRecords(con);
            }
            if (this.isTransacted) {
                con.commit();
            }
        }
        catch (SQLException e) {
            if (this.isTransacted) {
                con.rollback();
            }
            throw e;
        }
        finally {
            con.close();
        }
    }

    public void setConnectionFactory(ConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setRecordListConverter(StreamConverter converter) {
        this.recordListConverter = converter;
    }

    public StreamConverter getRecordListConverter() {
        return this.recordListConverter;
    }

    public void executeAllQuery() throws ConnectionFactoryException, SQLException, ConvertException, IOException {
        Connection con = this.connectionFactory.getConnection();
        if (this.isTransacted && con.getAutoCommit()) {
            con.setAutoCommit(false);
        }
        try {
            this.dropTable(con);
            this.deleteRecords(con);
            this.createTable(con);
            this.insertRecords(con);
            if (this.isTransacted) {
                con.commit();
            }
        }
        catch (SQLException e) {
            if (this.isTransacted) {
                con.rollback();
            }
            throw e;
        }
        finally {
            con.close();
        }
    }

    protected boolean existsTable(Statement stmt) throws SQLException {
        boolean existsTable = true;
        if (this.existsTableQuery != null) {
            ResultSet rs = stmt.executeQuery(this.existsTableQuery);
            rs.next();
            existsTable = rs.getInt(1) != 0;
            rs.close();
        }
        return existsTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backupRecords() throws ConnectionFactoryException, SQLException, IOException, ConvertException {
        Connection con = this.connectionFactory.getConnection();
        try {
            this.backupRecords(con);
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void backupRecords(Connection con) throws IOException, ConvertException, SQLException {
        block14: {
            if (this.selectQuery == null || this.backupRecordList == null) {
                return;
            }
            RecordList recList = this.backupRecordList.cloneSchema();
            try {
                Statement stmt = con.createStatement();
                if (this.existsTable(stmt)) {
                    ResultSet rs = stmt.executeQuery(this.selectQuery);
                    RecordSchema schema = recList.getRecordSchema();
                    while (rs.next()) {
                        Record rec = recList.createRecord();
                        int imax = schema.getPropertySize();
                        for (int i = 0; i < imax; ++i) {
                            String name = schema.getPropertyName(i);
                            rec.setProperty(name, rs.getObject(name));
                        }
                        recList.addRecord(rec);
                    }
                }
                this.backupRecordList = recList;
                if (this.backupFilePath == null) break block14;
                try {
                    File dir;
                    File backupFile = new File(this.backupFilePath);
                    if (!backupFile.exists() && (dir = backupFile.getParentFile()) != null && !dir.exists()) {
                        dir.mkdirs();
                    }
                    InputStream is = this.recordListConverter.convertToStream(this.backupRecordList);
                    FileOutputStream fos = new FileOutputStream(this.backupFilePath);
                    try {
                        byte[] bytes = new byte[1024];
                        int length = 0;
                        while ((length = is.read(bytes)) != -1) {
                            fos.write(bytes, 0, length);
                        }
                    }
                    finally {
                        fos.close();
                    }
                }
                finally {
                    this.backupRecordList.clear();
                }
            }
            catch (SQLException e) {
                this.handleSQLException(e, this.ignoreSQLExceptionErrorCodeOnSelect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable() throws ConnectionFactoryException, SQLException {
        Connection con = this.connectionFactory.getConnection();
        try {
            this.dropTable(con);
        }
        finally {
            con.close();
        }
    }

    protected void dropTable(Connection con) throws SQLException {
        if (this.dropTableQuery == null) {
            return;
        }
        try {
            Statement stmt = con.createStatement();
            if (this.existsTable(stmt)) {
                int i;
                if (this.preDropTableQueries != null) {
                    for (i = 0; i < this.preDropTableQueries.length; ++i) {
                        stmt.executeUpdate(this.preDropTableQueries[i]);
                    }
                }
                stmt.executeUpdate(this.dropTableQuery);
                if (this.postDropTableQueries != null) {
                    for (i = 0; i < this.postDropTableQueries.length; ++i) {
                        stmt.executeUpdate(this.postDropTableQueries[i]);
                    }
                }
            }
            stmt.close();
        }
        catch (SQLException e) {
            this.handleSQLException(e, this.ignoreSQLExceptionErrorCodeOnDropTable);
        }
    }

    protected void handleSQLException(SQLException e, int[] ignoreErrorCodes) throws SQLException {
        if (ignoreErrorCodes != null) {
            int errorCode = e.getErrorCode();
            boolean isIgnore = false;
            for (int i = 0; i < ignoreErrorCodes.length; ++i) {
                if (ignoreErrorCodes[i] != errorCode) continue;
                isIgnore = true;
                break;
            }
            if (!isIgnore) {
                throw e;
            }
        } else {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecords() throws ConnectionFactoryException, SQLException {
        Connection con = this.connectionFactory.getConnection();
        try {
            this.deleteRecords(con);
        }
        finally {
            con.close();
        }
    }

    protected void deleteRecords(Connection con) throws SQLException {
        if (this.deleteQuery == null) {
            return;
        }
        try {
            Statement stmt = con.createStatement();
            if (this.existsTable(stmt)) {
                stmt.executeUpdate(this.deleteQuery);
            }
            stmt.close();
        }
        catch (SQLException e) {
            this.handleSQLException(e, this.ignoreSQLExceptionErrorCodeOnDelete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable() throws ConnectionFactoryException, SQLException {
        Connection con = this.connectionFactory.getConnection();
        try {
            this.createTable(con);
        }
        finally {
            con.close();
        }
    }

    protected void createTable(Connection con) throws SQLException {
        if (this.createTableQuery == null) {
            return;
        }
        try {
            Statement stmt = con.createStatement();
            if (!this.existsTable(stmt)) {
                int i;
                if (this.preCreateTableQueries != null) {
                    for (i = 0; i < this.preCreateTableQueries.length; ++i) {
                        stmt.executeUpdate(this.preCreateTableQueries[i]);
                    }
                }
                stmt.executeUpdate(this.createTableQuery);
                if (this.postCreateTableQueries != null) {
                    for (i = 0; i < this.postCreateTableQueries.length; ++i) {
                        stmt.executeUpdate(this.postCreateTableQueries[i]);
                    }
                }
            }
            stmt.close();
        }
        catch (SQLException e) {
            this.handleSQLException(e, this.ignoreSQLExceptionErrorCodeOnCreateTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRecords() throws ConnectionFactoryException, IOException, ConvertException, SQLException {
        Connection con = this.connectionFactory.getConnection();
        try {
            this.insertRecords(con);
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertRecords(Connection con) throws IOException, ConvertException, SQLException {
        if (this.insertQuery == null) {
            return;
        }
        try {
            Statement stmt = con.createStatement();
            if (this.existsTable(stmt)) {
                stmt.close();
                stmt = null;
                PreparedStatement pstmt = con.prepareStatement(this.insertQuery);
                InputStream is = null;
                if (this.insertRecords != null) {
                    is = new ByteArrayInputStream(this.insertRecords.getBytes());
                } else if (this.insertRecordsFilePath != null) {
                    if (new File(this.insertRecordsFilePath).exists()) {
                        is = new FileInputStream(this.insertRecordsFilePath);
                    } else {
                        NimbusClassLoader loader = NimbusClassLoader.getInstance();
                        is = loader.getResourceAsStream(this.insertRecordsFilePath);
                    }
                    if (is == null) {
                        throw new IOException("InsertRecordsFilePath not found. path=" + this.insertRecordsFilePath);
                    }
                } else {
                    return;
                }
                RecordList recList = null;
                if (this.recordList != null) {
                    recList = this.recordList.cloneSchema();
                } else if (this.recordListSchema != null) {
                    recList = new RecordList();
                    recList.setSchema(this.recordListSchema);
                }
                try {
                    recList = recList == null ? (RecordList)this.recordListConverter.convertToObject(is) : (RecordList)((BindingStreamConverter)this.recordListConverter).convertToObject(is, recList);
                }
                finally {
                    is.close();
                }
                this.insertRecords(pstmt, recList);
                pstmt.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            this.handleSQLException(e, this.ignoreSQLExceptionErrorCodeOnInsert);
        }
    }

    protected void insertRecords(PreparedStatement pstmt, RecordList recList) throws SQLException {
        if (recList == null || recList.size() == 0) {
            return;
        }
        int batchCount = 0;
        int imax = recList.size();
        for (int i = 0; i < imax; ++i) {
            Record rec = recList.getRecord(i);
            RecordSchema schema = recList.getRecordSchema();
            int jmax = rec.size();
            for (int j = 0; j < jmax; ++j) {
                try {
                    Object val = rec.getProperty(j);
                    if (val == null) {
                        Integer sqlTypeVal;
                        Class type;
                        int sqlType = 12;
                        if (schema != null && (type = schema.getPropertySchema(j).getType()) != null && (sqlTypeVal = (Integer)this.sqlTypeMap.getValue(type)) != null) {
                            sqlType = sqlTypeVal;
                        }
                        pstmt.setNull(j + 1, sqlType);
                        continue;
                    }
                    pstmt.setObject(j + 1, val);
                    continue;
                }
                catch (SQLException e) {
                    this.handleSQLException(e, this.ignoreSQLExceptionErrorCodeOnInsert);
                }
            }
            try {
                if (this.insertBatchSize > 0) {
                    if (batchCount >= this.insertBatchSize || i == imax - 1) {
                        pstmt.executeBatch();
                        pstmt.clearBatch();
                        continue;
                    }
                    pstmt.addBatch();
                    continue;
                }
                pstmt.executeUpdate();
                continue;
            }
            catch (SQLException e) {
                this.handleSQLException(e, this.ignoreSQLExceptionErrorCodeOnInsert);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreRecords() throws ConnectionFactoryException, SQLException, IOException, ConvertException {
        Connection con = this.connectionFactory.getConnection();
        try {
            this.restoreRecords(con);
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreRecords(Connection con) throws IOException, ConvertException, SQLException {
        if (this.selectQuery == null || this.backupRecordList == null || this.insertQuery == null) {
            return;
        }
        if (this.deleteQuery != null) {
            this.deleteRecords(con);
        } else if (this.dropTableQuery != null && this.createTableQuery != null) {
            this.dropTable(con);
            this.createTable(con);
        }
        RecordList recList = this.backupRecordList;
        if (this.backupFilePath != null && new File(this.backupFilePath).exists()) {
            FileInputStream fis = new FileInputStream(this.backupFilePath);
            try {
                recList = this.backupRecordList.cloneSchema();
                recList = (RecordList)((BindingStreamConverter)this.recordListConverter).convertToObject(fis, recList);
            }
            finally {
                fis.close();
            }
        }
        try {
            Statement stmt = con.createStatement();
            if (this.existsTable(stmt)) {
                stmt.close();
                stmt = null;
                PreparedStatement pstmt = con.prepareStatement(this.insertQuery);
                this.insertRecords(pstmt, recList);
                pstmt.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            this.handleSQLException(e, this.ignoreSQLExceptionErrorCodeOnInsert);
        }
    }
}

