/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.log;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.log.GroupCategoryServiceMBean;
import jp.ossc.nimbus.service.log.LogCategory;
import jp.ossc.nimbus.service.message.MessageRecordFactory;
import jp.ossc.nimbus.service.writer.MessageWriteException;

public class GroupCategoryService
extends jp.ossc.nimbus.service.writer.GroupCategoryService
implements GroupCategoryServiceMBean {
    private static final long serialVersionUID = -725998713313782313L;
    private static final String SCGRY = "SCGRY";
    private static final String SCGRY0 = "SCGRY0";
    private static final String SCGRY00 = "SCGRY00";
    private static final String SCGRY000 = "SCGRY000";
    private static final String SCGRY0000 = "SCGRY0000";
    private static final String SCGRY00001 = "SCGRY00001";
    private static final String SCGRY00002 = "SCGRY00002";
    private static final String SCGRY00003 = "SCGRY00003";
    private static final String SCGRY00004 = "SCGRY00004";
    private static final String PRIORITY_RANGE_DELIMITER = ":";
    protected String categoryName;
    private Map labelMap = new HashMap();

    public void startService() throws Exception {
        super.startService();
        if (this.categoryName == null) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new ServiceException(SCGRY00004, message.findMessage(SCGRY00004));
        }
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String name) {
        this.categoryName = name;
    }

    public boolean isValidPriorityRange(int priority) {
        if (this.categories != null) {
            boolean existsCategory = false;
            int max = this.categories.length;
            for (int i = 0; i < max; ++i) {
                if (this.categories[i] instanceof LogCategory) {
                    LogCategory logCategory = (LogCategory)this.categories[i];
                    if (!logCategory.isValidPriorityRange(priority)) continue;
                    return true;
                }
                existsCategory = true;
            }
            return existsCategory;
        }
        return false;
    }

    private Range parseRange(String range) throws IllegalArgumentException {
        MessageRecordFactory message = this.getMessageRecordFactory();
        StringTokenizer tokens = new StringTokenizer(range, PRIORITY_RANGE_DELIMITER);
        if (tokens.countTokens() != 2) {
            throw new IllegalArgumentException(message.findMessage(SCGRY00001));
        }
        String minStr = tokens.nextToken();
        String maxStr = tokens.nextToken();
        int min = 0;
        int max = 0;
        try {
            min = Integer.parseInt(minStr);
            max = Integer.parseInt(maxStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(message.findMessage(SCGRY00001));
        }
        if (min > max) {
            throw new IllegalArgumentException(message.findMessage(SCGRY00002));
        }
        return new Range(min, max);
    }

    public String getLabel(int priority) {
        Iterator ranges = this.labelMap.keySet().iterator();
        while (ranges.hasNext()) {
            Range range = (Range)ranges.next();
            if (!range.contains(priority)) continue;
            return (String)this.labelMap.get(range);
        }
        if (this.categories != null) {
            int max = this.categories.length;
            for (int i = 0; i < max; ++i) {
                LogCategory logCategory;
                String label;
                if (!(this.categories[i] instanceof LogCategory) || (label = (logCategory = (LogCategory)this.categories[i]).getLabel(priority)) == null) continue;
                return label;
            }
        }
        return null;
    }

    public void setLabels(Properties labels) throws IllegalArgumentException {
        Iterator<Object> ranges = labels.keySet().iterator();
        while (ranges.hasNext()) {
            String rangeStr = (String)ranges.next();
            Range range = this.parseRange(rangeStr);
            if (this.labelMap.containsKey(new Integer(range.min)) || this.labelMap.containsKey(new Integer(range.max))) {
                MessageRecordFactory message = this.getMessageRecordFactory();
                throw new IllegalArgumentException(message.findMessage(SCGRY00003));
            }
            this.labelMap.put(range, labels.get(rangeStr));
        }
    }

    public void write(int priority, Map elements) throws MessageWriteException {
        if (this.categories != null) {
            int max = this.categories.length;
            for (int i = 0; i < max; ++i) {
                if (!this.categories[i].isEnabled()) continue;
                if (this.categories[i] instanceof LogCategory) {
                    LogCategory logCategory = (LogCategory)this.categories[i];
                    if (!logCategory.isValidPriorityRange(priority)) continue;
                    logCategory.write(priority, elements);
                    continue;
                }
                this.categories[i].write(elements);
            }
        }
    }

    private class Range
    implements Comparable {
        private final int min;
        private final int max;

        public Range(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public boolean contains(int val) {
            return this.min <= val && val <= this.max;
        }

        public boolean contains(Range range) {
            return this.min <= range.min && range.max <= this.max;
        }

        public boolean overlaps(Range range) {
            return this.contains(range.min) || this.contains(range.max);
        }

        public int compareTo(Object o) {
            if (o == this) {
                return 0;
            }
            if (o instanceof Range) {
                Range comp = (Range)o;
                if (comp.min == this.min) {
                    if (comp.max == this.max) {
                        return 0;
                    }
                    if (comp.max > this.max) {
                        return -1;
                    }
                    return 1;
                }
                if (comp.min > this.min) {
                    return -1;
                }
                return 1;
            }
            return -1;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Range) {
                Range comp = (Range)o;
                return comp.min == this.min && comp.max == this.max;
            }
            return false;
        }

        public int hashCode() {
            return this.min + this.max;
        }
    }
}

