/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.proxy;

import java.net.URL;
import java.rmi.RemoteException;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.aop.DefaultInterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.invoker.MethodReflectionCallInvokerService;

public class RemoteServiceServerSessionBean
implements SessionBean {
    private static final long serialVersionUID = -1629897916230733253L;
    private static final String JAVA_ENV_KEY = "java:comp/env";
    public static final String REMOTE_SERVICE_NAME_ENV_KEY = "remote-service-name";
    public static final String INTERCEPTOR_CHAIN_LIST_SERVICE_NAME_ENV_KEY = "interceptor-chain-list-service-name";
    public static final String INVOKER_SERVICE_NAME_ENV_KEY = "invoker-service-name";
    public static final String SERVICE_PATH_ENV_KEY = "service-path";
    private SessionContext sessionContext;
    private ServiceName remoteServiceName;
    private ServiceName interceptorChainListServiceName;
    private ServiceName invokerServiceName;
    private String servicePath;
    private MethodReflectionCallInvokerService defaultInvoker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(InvocationContext context) throws Exception, RemoteException {
        ServiceName serviceName;
        DefaultInterceptorChain chain = new DefaultInterceptorChain(this.interceptorChainListServiceName, this.invokerServiceName);
        if (this.invokerServiceName == null && this.defaultInvoker != null) {
            chain.setInvoker(this.defaultInvoker);
        }
        if ((serviceName = this.remoteServiceName) == null && context.getTargetObject() != null && context.getTargetObject() instanceof ServiceName) {
            serviceName = (ServiceName)context.getTargetObject();
        }
        if (serviceName == null) {
            throw new ServiceNotFoundException(null);
        }
        context.setTargetObject(ServiceManagerFactory.getServiceObject(serviceName));
        try {
            chain.setCurrentInterceptorIndex(-1);
            Object object = chain.invokeNext(context);
            return object;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            Object var5_7 = null;
            return var5_7;
        }
        finally {
            chain.setCurrentInterceptorIndex(-1);
        }
    }

    public boolean isAlive(ServiceName name) throws RemoteException {
        ServiceName serviceName = this.remoteServiceName;
        if (name != null) {
            if (this.remoteServiceName != null && !this.remoteServiceName.equals(name)) {
                return false;
            }
            serviceName = name;
        }
        if (serviceName == null) {
            return true;
        }
        try {
            Service service = ServiceManagerFactory.getService(serviceName);
            return service != null && service.getState() == 3;
        }
        catch (ServiceNotFoundException e) {
            return false;
        }
    }

    public void setSessionContext(SessionContext context) throws EJBException, RemoteException {
        this.sessionContext = context;
    }

    public SessionContext getSessionContext() {
        if (this.sessionContext == null) {
            throw new IllegalStateException("session context is invalid");
        }
        return this.sessionContext;
    }

    public EJBContext getEJBContext() {
        return this.getSessionContext();
    }

    public EJBObject getEJBObject() {
        return this.getSessionContext().getEJBObject();
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    public void ejbRemove() throws EJBException, RemoteException {
        if (this.defaultInvoker != null) {
            this.defaultInvoker.stop();
            this.defaultInvoker.destroy();
            this.defaultInvoker = null;
        }
        if (this.servicePath != null) {
            URL serviceURL = this.getClass().getClassLoader().getResource(this.servicePath);
            ServiceManagerFactory.unloadManager(serviceURL);
        }
    }

    public void ejbCreate() throws EJBException, RemoteException {
        String invokerServiceNameStr;
        String interceptorChainListServiceNameStr;
        ServiceNameEditor editor = new ServiceNameEditor();
        String remoteServiceNameStr = RemoteServiceServerSessionBean.getEnvProperty(REMOTE_SERVICE_NAME_ENV_KEY);
        if (remoteServiceNameStr != null) {
            editor.setAsText(remoteServiceNameStr);
            this.remoteServiceName = (ServiceName)editor.getValue();
        }
        if ((interceptorChainListServiceNameStr = RemoteServiceServerSessionBean.getEnvProperty(INTERCEPTOR_CHAIN_LIST_SERVICE_NAME_ENV_KEY)) != null) {
            editor.setAsText(interceptorChainListServiceNameStr);
            this.interceptorChainListServiceName = (ServiceName)editor.getValue();
        }
        if ((invokerServiceNameStr = RemoteServiceServerSessionBean.getEnvProperty(INVOKER_SERVICE_NAME_ENV_KEY)) == null) {
            try {
                if (this.defaultInvoker == null) {
                    this.defaultInvoker = new MethodReflectionCallInvokerService();
                    this.defaultInvoker.create();
                }
                this.defaultInvoker.start();
            }
            catch (Exception e) {
                throw new EJBException(e);
            }
        } else {
            editor.setAsText(invokerServiceNameStr);
            this.invokerServiceName = (ServiceName)editor.getValue();
        }
        this.servicePath = RemoteServiceServerSessionBean.getEnvProperty(SERVICE_PATH_ENV_KEY);
        if (this.servicePath != null) {
            URL serviceURL = this.getClass().getClassLoader().getResource(this.servicePath);
            ServiceManagerFactory.loadManager(serviceURL);
        }
    }

    private static String getEnvProperty(String name) {
        String value = null;
        try {
            InitialContext context = new InitialContext();
            Context env = (Context)context.lookup(JAVA_ENV_KEY);
            value = (String)env.lookup(name);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return value;
    }
}

