/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.proxy.invoker;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.proxy.RemoteServiceCallException;
import jp.ossc.nimbus.service.proxy.invoker.JMXClientRMICallInvokerServiceMBean;

public class JMXClientRMICallInvokerService
extends ServiceBase
implements Invoker,
Serializable,
JMXClientRMICallInvokerServiceMBean {
    private static final long serialVersionUID = -4668783322226114794L;
    private static final String SETTER_PREFIX = "set";
    private static final int SETTER_PREFIX_LENGTH = 3;
    private static final String GETTER_PREFIX = "get";
    private static final int GETTER_PREFIX_LENGTH = 3;
    protected ServiceName jndiFinderServiceName;
    protected JndiFinder jndiFinder;
    protected String rmiAdaptorName = "jmx/invoker/RMIAdaptor";
    protected String serviceURL;
    protected Map jmxConnectorEnvironment;
    protected JMXConnector jmxConnector;
    protected String objectNameDomain;
    protected Properties objectNameProperties;
    protected String objectNameStr;
    protected ObjectName objectName;
    protected String mBeanQuery;
    protected String objectNameRegex;

    public void setJndiFinderServiceName(ServiceName name) {
        this.jndiFinderServiceName = name;
    }

    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderServiceName;
    }

    public void setRMIAdaptorName(String name) {
        this.rmiAdaptorName = name;
    }

    public String getRMIAdaptorName() {
        return this.rmiAdaptorName;
    }

    public void setServiceURL(String url) {
        this.serviceURL = url;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public void setJMXConnectorEnvironment(Map env) {
        this.jmxConnectorEnvironment = env;
    }

    public Map getJMXConnectorEnvironment() {
        return this.jmxConnectorEnvironment;
    }

    public void setObjectName(String name) {
        this.objectNameStr = name;
    }

    public String getObjectName() {
        return this.objectNameStr;
    }

    public void setObjectNameDomain(String domain) {
        this.objectNameDomain = domain;
    }

    public String getObjectNameDomain() {
        return this.objectNameDomain;
    }

    public void setObjectNameProperties(Properties prop) {
        this.objectNameProperties = prop;
    }

    public Properties getObjectNameProperties() {
        return this.objectNameProperties;
    }

    public void setMBeanQuery(String query) {
        this.mBeanQuery = query;
    }

    public String getMBeanQuery() {
        return this.mBeanQuery;
    }

    public void setObjectNameRegex(String regex) {
        this.objectNameRegex = regex;
    }

    public String getObjectNameRegex() {
        return this.objectNameRegex;
    }

    public void setJndiFinder(JndiFinder jndiFinder) {
        this.jndiFinder = jndiFinder;
    }

    public void startService() throws Exception {
        if (this.jndiFinderServiceName != null) {
            this.jndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.jndiFinderServiceName);
        }
        if (this.serviceURL == null && this.jndiFinder == null) {
            throw new IllegalArgumentException("JndiFinderServiceName or JndiFinder must be specified.");
        }
        if (this.serviceURL != null) {
            this.jmxConnector = JMXConnectorFactory.newJMXConnector(new JMXServiceURL(this.serviceURL), this.jmxConnectorEnvironment);
        }
        if (this.mBeanQuery != null) {
            if (this.objectNameRegex == null) {
                throw new IllegalArgumentException("objectNameRegex must be specified.");
            }
        } else if (this.objectNameStr == null) {
            if (this.objectNameDomain == null) {
                throw new IllegalArgumentException("objectNameDomain must be specified.");
            }
            if (this.objectNameProperties == null) {
                throw new IllegalArgumentException("objectNameProperties must be specified.");
            }
        }
    }

    public void stopService() throws Exception {
        if (this.jmxConnector != null) {
            this.jmxConnector.close();
            this.jmxConnector = null;
        }
    }

    protected ObjectName matchObjectName() throws MalformedObjectNameException, NamingException, IOException {
        ObjectName[] names = this.queryMBeans();
        if (names == null || names.length == 0) {
            return null;
        }
        for (int i = 0; i < names.length; ++i) {
            Pattern pattern = Pattern.compile(this.objectNameRegex);
            if (!pattern.matcher(names[i].toString()).matches()) continue;
            return names[i];
        }
        return null;
    }

    protected ObjectName[] queryMBeans() throws NamingException, MalformedObjectNameException, IOException {
        MBeanServerConnection connection = (MBeanServerConnection)this.jndiFinder.lookup(this.rmiAdaptorName);
        Set<ObjectName> mbeans = connection.queryNames(new ObjectName(this.mBeanQuery), null);
        if (mbeans == null || mbeans.size() == 0) {
            return null;
        }
        return mbeans.toArray(new ObjectName[mbeans.size()]);
    }

    protected ObjectName createObjectName() throws Exception {
        if (this.objectName == null) {
            this.objectName = this.mBeanQuery != null ? this.matchObjectName() : (this.objectNameStr != null ? new ObjectName(this.objectNameStr) : new ObjectName(this.objectNameDomain, this.objectNameProperties));
        }
        return this.objectName;
    }

    public Object invoke(InvocationContext context) throws Throwable {
        MethodInvocationContext methodContext = (MethodInvocationContext)context;
        try {
            MBeanServerConnection connection = null;
            if (this.jndiFinder != null) {
                connection = (MBeanServerConnection)this.jndiFinder.lookup(this.rmiAdaptorName);
            } else {
                this.jmxConnector.connect();
                connection = this.jmxConnector.getMBeanServerConnection();
            }
            Method method = methodContext.getTargetMethod();
            String methodName = method.getName();
            Object[] params = methodContext.getParameters();
            if (methodName.length() > 3 && methodName.startsWith(SETTER_PREFIX) && params != null && params.length == 1) {
                Attribute attr = new Attribute(methodName.substring(3), params[0]);
                connection.setAttribute(this.createObjectName(), attr);
                return null;
            }
            if (methodName.length() > 3 && methodName.startsWith(GETTER_PREFIX) && (params == null || params.length == 0)) {
                return connection.getAttribute(this.createObjectName(), methodName.substring(3));
            }
            String[] sigs = null;
            Class<?>[] paramTypes = methodContext.getTargetMethod().getParameterTypes();
            if (paramTypes != null) {
                sigs = new String[paramTypes.length];
                for (int i = 0; i < paramTypes.length; ++i) {
                    sigs[i] = paramTypes[i].getName();
                }
            }
            return connection.invoke(this.createObjectName(), methodName, params, sigs);
        }
        catch (NamingException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (RemoteException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (AttributeNotFoundException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (InvalidAttributeValueException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (MBeanException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (ReflectionException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (IOException e) {
            throw new RemoteServiceCallException(e);
        }
    }
}

