/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChainList;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.SelectableServletFilterInterceptorChainListServiceMBean;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;

public class SelectableServletFilterInterceptorChainListService
extends ServiceBase
implements SelectableServletFilterInterceptorChainListServiceMBean,
InterceptorChainList {
    private static final long serialVersionUID = -3624632759924394508L;
    private Properties enabledURLMapping;
    private Map enabledURLChainMapping;
    private Properties enabledURIMapping;
    private Map enabledURIChainMapping;
    private Properties enabledPathMapping;
    private Map enabledPathChainMapping;
    private Properties disabledURLMapping;
    private Map disabledURLChainMapping;
    private Properties disabledURIMapping;
    private Map disabledURIChainMapping;
    private Properties disabledPathMapping;
    private Map disabledPathChainMapping;
    private ServiceName defaultInterceptorChainListServiceName;
    private InterceptorChainList defaultInterceptorChainList;

    @Override
    public void setEnabledURLMapping(Properties mapping) {
        this.enabledURLMapping = mapping;
    }

    @Override
    public Properties getEnabledURLMapping() {
        return this.enabledURLMapping;
    }

    @Override
    public void setEnabledURIMapping(Properties mapping) {
        this.enabledURIMapping = mapping;
    }

    @Override
    public Properties getEnabledURIMapping() {
        return this.enabledPathMapping;
    }

    @Override
    public void setEnabledPathMapping(Properties mapping) {
        this.enabledPathMapping = mapping;
    }

    @Override
    public Properties getEnabledPathMapping() {
        return this.enabledPathMapping;
    }

    @Override
    public void setDisabledURLMapping(Properties mapping) {
        this.disabledURLMapping = mapping;
    }

    @Override
    public Properties getDisabledURLMapping() {
        return this.disabledURLMapping;
    }

    @Override
    public void setDisabledURIMapping(Properties mapping) {
        this.disabledURIMapping = mapping;
    }

    @Override
    public Properties getDisabledURIMapping() {
        return this.disabledPathMapping;
    }

    @Override
    public void setDisabledPathMapping(Properties mapping) {
        this.disabledPathMapping = mapping;
    }

    @Override
    public Properties getDisabledPathMapping() {
        return this.disabledPathMapping;
    }

    @Override
    public void setDefaultInterceptorChainListServiceName(ServiceName name) {
        this.defaultInterceptorChainListServiceName = name;
    }

    @Override
    public ServiceName getDefaultInterceptorChainListServiceName() {
        return this.defaultInterceptorChainListServiceName;
    }

    @Override
    public void createService() throws Exception {
        this.enabledURLChainMapping = new HashMap();
        this.enabledURIChainMapping = new HashMap();
        this.enabledPathChainMapping = new HashMap();
        this.disabledURLChainMapping = new HashMap();
        this.disabledURIChainMapping = new HashMap();
        this.disabledPathChainMapping = new HashMap();
    }

    @Override
    public void startService() throws Exception {
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setServiceManagerName(this.getServiceManagerName());
        if (this.enabledURLMapping != null && this.enabledURLMapping.size() != 0) {
            this.initMapping(editor, this.enabledURLMapping, this.enabledURLChainMapping);
        }
        if (this.enabledURIMapping != null && this.enabledURIMapping.size() != 0) {
            this.initMapping(editor, this.enabledURIMapping, this.enabledURIChainMapping);
        }
        if (this.enabledPathMapping != null && this.enabledPathMapping.size() != 0) {
            this.initMapping(editor, this.enabledPathMapping, this.enabledPathChainMapping);
        }
        if (this.disabledURLMapping != null && this.disabledURLMapping.size() != 0) {
            this.initMapping(editor, this.disabledURLMapping, this.disabledURLChainMapping);
        }
        if (this.disabledURIMapping != null && this.disabledURIMapping.size() != 0) {
            this.initMapping(editor, this.disabledURIMapping, this.disabledURIChainMapping);
        }
        if (this.disabledPathMapping != null && this.disabledPathMapping.size() != 0) {
            this.initMapping(editor, this.disabledPathMapping, this.disabledPathChainMapping);
        }
        if (this.defaultInterceptorChainListServiceName != null) {
            this.defaultInterceptorChainList = (InterceptorChainList)ServiceManagerFactory.getServiceObject(this.defaultInterceptorChainListServiceName);
        }
    }

    @Override
    public void stopService() throws Exception {
        this.enabledURLChainMapping.clear();
        this.enabledURIChainMapping.clear();
        this.enabledPathChainMapping.clear();
        this.disabledURLChainMapping.clear();
        this.disabledURIChainMapping.clear();
        this.disabledPathChainMapping.clear();
    }

    @Override
    public void destroyService() throws Exception {
        this.enabledURLChainMapping = null;
        this.enabledURIChainMapping = null;
        this.enabledPathChainMapping = null;
        this.disabledURLChainMapping = null;
        this.disabledURIChainMapping = null;
        this.disabledPathChainMapping = null;
    }

    private void initMapping(ServiceNameEditor editor, Properties mapping, Map chainMapping) {
        for (String string : mapping.keySet()) {
            Pattern pattern = Pattern.compile(string);
            String serviceNameStr = mapping.getProperty(string);
            editor.setAsText(serviceNameStr);
            ServiceName name = (ServiceName)editor.getValue();
            InterceptorChainList chain = (InterceptorChainList)ServiceManagerFactory.getServiceObject(name);
            chainMapping.put(pattern, chain);
        }
    }

    @Override
    public Interceptor getInterceptor(InvocationContext context, int index) {
        if (this.getState() != 3) {
            return null;
        }
        InterceptorChainList chainList = null;
        ServletFilterInvocationContext filtreContext = (ServletFilterInvocationContext)context;
        ServletRequest request = filtreContext.getServletRequest();
        if (request instanceof HttpServletRequest) {
            String reqPath;
            String reqURI;
            String reqURL;
            HttpServletRequest httpReq = (HttpServletRequest)request;
            if (this.enabledURLChainMapping.size() != 0) {
                reqURL = httpReq.getRequestURL().toString();
                chainList = this.selectInterceptorChainList(reqURL, this.enabledURLChainMapping, true);
            }
            if (chainList == null && this.enabledURIChainMapping.size() != 0) {
                reqURI = httpReq.getRequestURI().toString();
                chainList = this.selectInterceptorChainList(reqURI, this.enabledURIChainMapping, true);
            }
            if (chainList == null && this.enabledPathChainMapping.size() != 0) {
                reqPath = httpReq.getPathInfo();
                if (reqPath == null) {
                    reqPath = httpReq.getServletPath();
                }
                chainList = this.selectInterceptorChainList(reqPath, this.enabledPathChainMapping, true);
            }
            if (chainList == null && this.disabledURLChainMapping.size() != 0) {
                reqURL = httpReq.getRequestURL().toString();
                chainList = this.selectInterceptorChainList(reqURL, this.disabledURLChainMapping, false);
            }
            if (chainList == null && this.disabledURIChainMapping.size() != 0) {
                reqURI = httpReq.getRequestURI().toString();
                chainList = this.selectInterceptorChainList(reqURI, this.disabledURIChainMapping, false);
            }
            if (chainList == null && this.disabledPathChainMapping.size() != 0) {
                reqPath = httpReq.getPathInfo();
                if (reqPath == null) {
                    reqPath = httpReq.getServletPath();
                }
                chainList = this.selectInterceptorChainList(reqPath, this.disabledPathChainMapping, false);
            }
        }
        if (chainList == null) {
            chainList = this.defaultInterceptorChainList;
        }
        if (chainList == null) {
            return null;
        }
        return chainList.getInterceptor(context, index);
    }

    private InterceptorChainList selectInterceptorChainList(String target, Map patternMapping, boolean isMatch) {
        for (Pattern pattern : patternMapping.keySet()) {
            Matcher m = pattern.matcher(target);
            if (m.matches() != isMatch) continue;
            return (InterceptorChainList)patternMapping.get(pattern);
        }
        return null;
    }
}

