/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.beancontrol.resource;

import java.util.HashMap;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanControlUncheckedException;
import jp.ossc.nimbus.service.beancontrol.resource.ResourceManager;
import jp.ossc.nimbus.service.resource.ResourceFactory;
import jp.ossc.nimbus.service.resource.TransactionResource;

public class ResourceManagerImpl
extends ServiceBase
implements ResourceManager {
    private static final long serialVersionUID = 1692609765851402548L;
    private HashMap mResourceMap = new HashMap();

    @Override
    public void terminateResourceManager() {
        HashMap map = this.mResourceMap;
        boolean bControl = false;
        for (String key : map.keySet()) {
            ResourceRecord rec = (ResourceRecord)map.get(key);
            bControl = rec.isTransactionControl();
            if (bControl) {
                try {
                    rec.getTransanctionResource().rollback();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                rec.getTransanctionResource().close();
            }
            catch (Exception e) {}
        }
        map.clear();
        this.mResourceMap = null;
    }

    @Override
    public void addResource(String key, String resourceKey, ServiceName serviceName, boolean isTranControl, boolean isTranClose) {
        HashMap map = this.mResourceMap;
        ResourceRecord rec = new ResourceRecord();
        rec.setServiceName(serviceName);
        rec.setResourceKey(resourceKey);
        rec.setTransactionControl(isTranControl);
        rec.setTransactionClose(isTranClose);
        map.put(key, rec);
    }

    @Override
    public void commitResource(String key, boolean isClose) {
        boolean bControl = false;
        if (!bControl && !isClose) {
            return;
        }
        HashMap map = this.mResourceMap;
        ResourceRecord rec = (ResourceRecord)map.get(key);
        if (rec != null && rec.isGet()) {
            bControl = rec.isTransactionControl();
            if (bControl) {
                try {
                    rec.getTransanctionResource().commit();
                }
                catch (Exception e) {
                    throw new BeanControlUncheckedException("resource commit error", e);
                }
            }
            if (isClose) {
                try {
                    rec.getTransanctionResource().close();
                }
                catch (Exception e) {
                    throw new BeanControlUncheckedException("resource close error", e);
                }
                map.remove(key);
            }
        }
    }

    @Override
    public void rollBackResource(String key, boolean isClose) {
        boolean bControl = false;
        if (!bControl && !isClose) {
            return;
        }
        HashMap map = this.mResourceMap;
        ResourceRecord rec = (ResourceRecord)map.get(key);
        if (rec != null && rec.isGet()) {
            bControl = rec.isTransactionControl();
            if (bControl) {
                try {
                    rec.getTransanctionResource().rollback();
                }
                catch (Exception e) {
                    throw new BeanControlUncheckedException("resource rollback error", e);
                }
            }
            if (isClose) {
                try {
                    rec.getTransanctionResource().close();
                }
                catch (Exception e) {
                    throw new BeanControlUncheckedException("resource close error", e);
                }
                rec.setGet(false);
                map.remove(key);
            }
        }
    }

    @Override
    public void commitAllResources() {
        HashMap map = this.mResourceMap;
        boolean bControl = false;
        boolean bClose = false;
        for (String key : map.keySet()) {
            ResourceRecord rec = (ResourceRecord)map.get(key);
            bControl = rec.isTransactionControl();
            if (bControl && rec.isGet()) {
                try {
                    rec.getTransanctionResource().commit();
                }
                catch (Exception e) {
                    throw new BeanControlUncheckedException("resource commit error", e);
                }
            }
            if (!(bClose = rec.isTransactionClose()) || !rec.isGet()) continue;
            try {
                rec.getTransanctionResource().close();
            }
            catch (Exception e) {
                throw new BeanControlUncheckedException("resource close error", e);
            }
            rec.setGet(false);
        }
        map.clear();
    }

    @Override
    public void rollbbackAllResources() {
        HashMap map = this.mResourceMap;
        boolean bControl = false;
        boolean bClose = false;
        for (String key : map.keySet()) {
            ResourceRecord rec = (ResourceRecord)map.get(key);
            bControl = rec.isTransactionControl();
            if (bControl && rec.isGet()) {
                try {
                    rec.getTransanctionResource().rollback();
                }
                catch (Exception e) {
                    throw new BeanControlUncheckedException("resource rollback error", e);
                }
            }
            if (!(bClose = rec.isTransactionClose()) || !rec.isGet()) continue;
            try {
                rec.getTransanctionResource().close();
            }
            catch (Exception e) {
                throw new BeanControlUncheckedException("resource close error", e);
            }
            rec.setGet(false);
        }
        map.clear();
    }

    @Override
    public Object getResource(String key) {
        TransactionResource ret = null;
        HashMap map = this.mResourceMap;
        ResourceRecord rec = (ResourceRecord)map.get(key);
        if (rec != null) {
            ret = rec.getTransanctionResource();
            rec.setGet(true);
        }
        return ret;
    }

    private class ResourceRecord {
        private TransactionResource mTransanctionResource = null;
        private boolean mIsGet = false;
        private boolean mIsTransactionControl = false;
        private boolean mIsTransactionClose = true;
        private String mResourceKey = null;
        private ServiceName mServiceName = null;

        private ResourceRecord() {
        }

        public void setServiceName(ServiceName name) {
            this.mServiceName = name;
        }

        public void setResourceKey(String key) {
            this.mResourceKey = key;
        }

        public boolean isGet() {
            return this.mIsGet;
        }

        public TransactionResource getTransanctionResource() {
            if (this.isGet()) {
                return this.mTransanctionResource;
            }
            ResourceFactory rf = (ResourceFactory)ServiceManagerFactory.getServiceObject(this.mServiceName);
            TransactionResource rc = null;
            try {
                rc = rf.makeResource(this.mResourceKey);
            }
            catch (Exception e) {
                throw new BeanControlUncheckedException("makeResource exception", e);
            }
            this.setTransanctionResource(rc);
            return rc;
        }

        public void setGet(boolean b) {
            this.mIsGet = b;
        }

        public void setTransanctionResource(TransactionResource resource) {
            this.mTransanctionResource = resource;
        }

        public boolean isTransactionControl() {
            return this.mIsTransactionControl;
        }

        public boolean isTransactionClose() {
            return this.mIsTransactionClose;
        }

        public void setTransactionControl(boolean b) {
            this.mIsTransactionControl = b;
        }

        public void setTransactionClose(boolean b) {
            this.mIsTransactionClose = b;
        }
    }
}

