/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.http.proxy;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLSocket;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.http.proxy.Process;
import jp.ossc.nimbus.service.http.proxy.ProxyServerServiceMBean;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.queue.QueueHandlerContainerService;

public class ProxyServerService
extends ServiceBase
implements ProxyServerServiceMBean,
DaemonRunnable,
QueueHandler {
    private static final long serialVersionUID = 313673219796070087L;
    private static final String MSG_ID_00001 = "PSS__00001";
    private int port = 8080;
    private ServiceName serverSocketFactoryServiceName;
    private ServerSocketFactory serverSocketFactory;
    private ServerSocket serverSocket;
    private Daemon serverDaemon;
    private int soTimeout = -1;
    private ServiceName processServiceName;
    private Process process;
    private DefaultQueueService queue;
    private QueueHandlerContainerService queueHandlerContainer;
    private int maxProcessCount = 1;
    private String bindAddress;
    private int backlog;

    @Override
    public void setProcessServiceName(ServiceName name) {
        this.processServiceName = name;
    }

    @Override
    public ServiceName getProcessServiceName() {
        return this.processServiceName;
    }

    @Override
    public void setServerSocketFactoryServiceName(ServiceName name) {
        this.serverSocketFactoryServiceName = name;
    }

    @Override
    public ServiceName getServerSocketFactoryServiceName() {
        return this.serverSocketFactoryServiceName;
    }

    @Override
    public void setBindAddress(String address) {
        this.bindAddress = address;
    }

    @Override
    public String getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    @Override
    public int getBacklog() {
        return this.backlog;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setSoTimeout(int millis) {
        this.soTimeout = millis;
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Override
    public void setMaxProcessCount(int count) {
        this.maxProcessCount = count;
    }

    @Override
    public int getMaxProcessCount() {
        return this.maxProcessCount;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.serverSocketFactory = factory;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    @Override
    public void startService() throws Exception {
        if (this.processServiceName != null) {
            this.process = (Process)ServiceManagerFactory.getServiceObject(this.processServiceName);
        }
        if (this.process == null) {
            throw new IllegalArgumentException("Process must be specified.");
        }
        if (this.serverSocketFactoryServiceName != null) {
            this.serverSocketFactory = (ServerSocketFactory)ServiceManagerFactory.getServiceObject(this.serverSocketFactoryServiceName);
        }
        this.queue = new DefaultQueueService();
        this.queue.create();
        this.queue.start();
        this.queueHandlerContainer = new QueueHandlerContainerService();
        this.queueHandlerContainer.setQueueService(this.queue);
        this.queueHandlerContainer.setQueueHandler(this);
        this.queueHandlerContainer.setQueueHandlerSize(this.maxProcessCount);
        this.queueHandlerContainer.create();
        this.queueHandlerContainer.start();
        InetAddress bindAdr = null;
        if (this.bindAddress != null) {
            bindAdr = InetAddress.getByName(this.bindAddress);
        }
        if (this.serverSocketFactory != null) {
            this.serverSocket = bindAdr == null ? this.serverSocketFactory.createServerSocket(this.port, this.backlog) : this.serverSocketFactory.createServerSocket(this.port, this.backlog, bindAdr);
        } else {
            ServerSocket serverSocket = this.serverSocket = bindAdr == null ? new ServerSocket(this.port, this.backlog) : new ServerSocket(this.port, this.backlog, bindAdr);
        }
        if (this.soTimeout >= 0) {
            this.serverSocket.setSoTimeout(this.soTimeout);
        }
        this.serverDaemon = new Daemon(this);
        this.serverDaemon.setName("Nimbus TestProxyServerDaemon " + this.getServiceNameObject());
        this.serverDaemon.start();
    }

    @Override
    public void stopService() throws Exception {
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.serverDaemon != null) {
            this.serverDaemon.stop();
        }
        this.queueHandlerContainer.stop();
        this.queueHandlerContainer.destroy();
        this.queue.stop();
        this.queue.destroy();
    }

    @Override
    public boolean onStart() {
        return true;
    }

    @Override
    public boolean onStop() {
        return true;
    }

    @Override
    public boolean onSuspend() {
        return true;
    }

    @Override
    public boolean onResume() {
        return true;
    }

    @Override
    public Object provide(DaemonControl ctrl) throws Exception {
        Socket socket = null;
        try {
            socket = this.serverSocket.accept();
            if (socket instanceof SSLSocket) {
                ((SSLSocket)socket).startHandshake();
            }
        }
        catch (SocketTimeoutException e) {
            return null;
        }
        catch (SocketException e) {
            if (this.getState() != 4) {
                this.getLogger().write(MSG_ID_00001, e);
            }
            ctrl.setRunning(false);
        }
        return socket;
    }

    @Override
    public void consume(Object paramObj, DaemonControl ctrl) throws Exception {
        if (paramObj == null) {
            return;
        }
        Socket socket = (Socket)paramObj;
        this.queue.push(socket);
    }

    @Override
    public void garbage() {
        if (this.queue != null) {
            while (this.queue.size() > 0) {
                Socket socket = (Socket)this.queue.get(0L);
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void handleDequeuedObject(Object obj) throws Throwable {
        if (obj == null) {
            return;
        }
        Socket socket = (Socket)obj;
        this.process.doProcess(socket.getInputStream(), socket.getOutputStream());
    }

    @Override
    public boolean handleError(Object obj, Throwable th) throws Throwable {
        throw th;
    }

    @Override
    public void handleRetryOver(Object obj, Throwable th) throws Throwable {
        throw th;
    }
}

