/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.io.ExtentionFileFilter;
import jp.ossc.nimbus.io.RecurciveSearchFile;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.properties.PropertiesFactory;
import jp.ossc.nimbus.service.properties.ResourceBundlePropertiesFactoryServiceMBean;
import jp.ossc.nimbus.util.ArrayProperties;
import jp.ossc.nimbus.util.CsvArrayList;
import jp.ossc.nimbus.util.StringOperator;

public class ResourceBundlePropertiesFactoryService
extends ServiceBase
implements ResourceBundlePropertiesFactoryServiceMBean,
PropertiesFactory {
    private static final long serialVersionUID = 114536824319044310L;
    protected Hashtable mPropHash = new Hashtable(3072);
    protected String mEncode = "ISO-8859-1";
    protected CsvArrayList mRootDir = new CsvArrayList();
    protected Date mRefreshPlanTime = null;
    protected Date mRefreshedTime = null;
    private static final String C_SEPARATOR = "path.separator";
    private static final String C_UNDER_SCORE = "_";
    private static final String C_JAR_EXT = ".JAR";
    private static final String C_BK_SRASH = "\\";
    private static final String C_SRASH = "/";
    private static final String C_PROP_EXT = ".properties";
    private static final String C_DOT = ".";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRefreshedTime() {
        SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        Hashtable hashtable = this.mPropHash;
        synchronized (hashtable) {
            return ft.format(this.mRefreshedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRefreshPlanTime() {
        SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        Hashtable hashtable = this.mPropHash;
        synchronized (hashtable) {
            return ft.format(this.mRefreshPlanTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClassPath(String classPath) {
        Hashtable hashtable = this.mPropHash;
        synchronized (hashtable) {
            this.mRootDir.clear();
            String sept = System.getProperty(C_SEPARATOR);
            this.mRootDir.split(classPath, sept);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClassPath() {
        Hashtable hashtable = this.mPropHash;
        synchronized (hashtable) {
            return this.mRootDir.join(System.getProperty(C_SEPARATOR));
        }
    }

    @Override
    public void refreshNow() {
        this.startService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRefreshPlanTime(String time) {
        SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        Hashtable hashtable = this.mPropHash;
        synchronized (hashtable) {
            try {
                this.mRefreshPlanTime = ft.parse(time);
            }
            catch (ParseException e) {
                throw new ServiceException("PROPFACTORY001", "ParseException", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startService() {
        SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        Hashtable hashtable = this.mPropHash;
        synchronized (hashtable) {
            try {
                this.mRefreshPlanTime = ft.parse(ft.format(new Date()));
            }
            catch (ParseException e) {
                throw new ServiceException("PROPFACTORY011", "ParseException", e);
            }
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopService() {
        Hashtable hashtable = this.mPropHash;
        synchronized (hashtable) {
            this.mPropHash.clear();
        }
    }

    @Override
    public Properties loadProperties(String propName) {
        Locale lo = Locale.getDefault();
        return this.loadProperties(propName, lo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties loadProperties(String propName, Locale lo) {
        ArrayProperties retProp;
        block7: {
            retProp = null;
            Hashtable hashtable = this.mPropHash;
            synchronized (hashtable) {
                block8: {
                    if (this.mRefreshPlanTime.after(this.mRefreshedTime) && this.mRefreshPlanTime.before(new Date())) {
                        this.refresh();
                    }
                    StringBuffer propKey = new StringBuffer(propName);
                    propKey.append(C_UNDER_SCORE).append(lo.getLanguage()).append(C_UNDER_SCORE).append(lo.getCountry()).append(C_UNDER_SCORE).append(lo.getVariant());
                    retProp = (ArrayProperties)this.mPropHash.get(propKey.toString());
                    if (retProp != null) break block7;
                    propKey = new StringBuffer(propName);
                    propKey.append(C_UNDER_SCORE).append(lo.getLanguage()).append(C_UNDER_SCORE).append(lo.getCountry());
                    retProp = (ArrayProperties)this.mPropHash.get(propKey.toString());
                    if (retProp != null) break block7;
                    propKey = new StringBuffer(propName);
                    propKey.append(C_UNDER_SCORE).append(lo.getLanguage());
                    retProp = (ArrayProperties)this.mPropHash.get(propKey.toString());
                    if (retProp != null) break block7;
                    if (lo.equals(Locale.getDefault())) break block8;
                    lo = Locale.getDefault();
                    propKey = new StringBuffer(propName);
                    propKey.append(C_UNDER_SCORE).append(lo.getLanguage()).append(C_UNDER_SCORE).append(lo.getCountry()).append(C_UNDER_SCORE).append(lo.getVariant());
                    retProp = (ArrayProperties)this.mPropHash.get(propKey.toString());
                    if (retProp != null) break block7;
                    propKey = new StringBuffer(propName);
                    propKey.append(C_UNDER_SCORE).append(lo.getLanguage()).append(C_UNDER_SCORE).append(lo.getCountry());
                    retProp = (ArrayProperties)this.mPropHash.get(propKey.toString());
                    if (retProp != null) break block7;
                    propKey = new StringBuffer(propName);
                    propKey.append(C_UNDER_SCORE).append(lo.getLanguage());
                    retProp = (ArrayProperties)this.mPropHash.get(propKey.toString());
                    if (retProp != null) break block7;
                }
                retProp = (ArrayProperties)this.mPropHash.get(propName);
            }
        }
        return retProp;
    }

    protected void refresh() {
        SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        this.mPropHash.clear();
        ListIterator iterator = this.mRootDir.listIterator();
        while (iterator.hasNext()) {
            String item = (String)iterator.next();
            String upper = item.toUpperCase();
            if (upper.endsWith(C_JAR_EXT)) {
                this.setupJarPropList(item);
                continue;
            }
            this.setupDirPropList(item);
        }
        try {
            this.mRefreshedTime = ft.parse(ft.format(new Date()));
        }
        catch (ParseException e) {
            throw new ServiceException("PROPFACTORY021", "ParseException", e);
        }
    }

    protected void setupJarPropList(String item) {
        JarFile jar;
        String dirPath = StringOperator.replaceString(item, C_BK_SRASH, C_SRASH);
        try {
            jar = new JarFile(dirPath);
        }
        catch (IOException e) {
            throw new ServiceException("PROPFACTORY005", "IOException filename = " + dirPath, e);
        }
        Enumeration<JarEntry> iterator = jar.entries();
        while (iterator.hasMoreElements()) {
            ZipEntry entry = iterator.nextElement();
            String name = entry.getName();
            if (entry.isDirectory() || !name.endsWith(C_PROP_EXT)) continue;
            InputStream is = null;
            try {
                is = jar.getInputStream(entry);
            }
            catch (IOException e) {
                throw new ServiceException("PROPFACTORY006", "IOException filename = " + dirPath, e);
            }
            ArrayProperties prop = new ArrayProperties(this.mEncode);
            try {
                prop.load(is);
            }
            catch (IOException e) {
                throw new ServiceException("PROPFACTORY007", "IOException filename = " + dirPath, e);
            }
            name = StringOperator.replaceString(name, C_SRASH, C_DOT);
            name = name.substring(0, name.length() - C_PROP_EXT.length());
            this.mPropHash.put(name, prop);
            try {
                is.close();
            }
            catch (IOException e) {
                throw new ServiceException("PROPFACTORY008", "IOException filename = " + dirPath, e);
            }
        }
    }

    protected void setupDirPropList(String item) {
        String dirPath = StringOperator.replaceString(item, C_BK_SRASH, C_SRASH);
        if (!item.endsWith(C_SRASH)) {
            dirPath = dirPath + C_SRASH;
        }
        File dirPathFile = new File(dirPath);
        int pos = dirPathFile.getAbsolutePath().length();
        RecurciveSearchFile file = new RecurciveSearchFile(dirPath);
        ExtentionFileFilter filter = new ExtentionFileFilter(C_PROP_EXT, true);
        File[] list = file.listAllTreeFiles(filter);
        for (int cnt = 0; cnt < list.length; ++cnt) {
            FileInputStream stream;
            try {
                stream = new FileInputStream(list[cnt]);
            }
            catch (FileNotFoundException e) {
                throw new ServiceException("PROPFACTORY002", "FileNotFoundException name = " + list[cnt], e);
            }
            ArrayProperties prop = new ArrayProperties(this.mEncode);
            try {
                prop.load(stream);
            }
            catch (IOException e) {
                throw new ServiceException("PROPFACTORY003", "IOException filename = " + list[cnt], e);
            }
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new ServiceException("PROPFACTORY004", "IOException filename = " + list[cnt], e);
            }
            String path = list[cnt].getAbsolutePath();
            path = path.substring(pos + 1, path.length() - C_PROP_EXT.length());
            path = StringOperator.replaceString(path, C_BK_SRASH, C_DOT);
            path = StringOperator.replaceString(path, C_SRASH, C_DOT);
            this.mPropHash.put(path, prop);
        }
    }

    @Override
    public void setEncode(String encode) {
        this.mEncode = encode;
    }

    @Override
    public String getEncode() {
        return this.mEncode;
    }
}

