/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.resource.jms;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.jms.JMSSessionFactory;
import jp.ossc.nimbus.service.resource.ResourceFactory;
import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.resource.jms.JMSSessionFactoryServiceMBean;
import jp.ossc.nimbus.service.resource.jms.JMSSessionTransactionResource;

public class JMSSessionFactoryService
extends ServiceBase
implements ResourceFactory,
JMSSessionFactoryServiceMBean {
    private static final long serialVersionUID = 5783846296550167721L;
    private ServiceName sessionFactoryServiceName;
    private JMSSessionFactory sessionFactory;
    private boolean isSetAckMode;
    private int ackMode = 1;
    private boolean isSetTransactionMode;
    private boolean transactionMode;

    @Override
    public void setJMSSessionFactoryServiceName(ServiceName name) {
        this.sessionFactoryServiceName = name;
    }

    @Override
    public ServiceName getJMSSessionFactoryServiceName() {
        return this.sessionFactoryServiceName;
    }

    @Override
    public void setAcknowledgeMode(int mode) {
        this.isSetAckMode = true;
        this.ackMode = mode;
    }

    @Override
    public int getAcknowledgeMode() {
        return this.ackMode;
    }

    @Override
    public void setTransactionMode(boolean isTransacted) {
        this.isSetTransactionMode = true;
        this.transactionMode = isTransacted;
    }

    @Override
    public boolean getTransactionMode() {
        return this.transactionMode;
    }

    public void setJMSSessionFactory(JMSSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void createService() throws Exception {
        this.isSetAckMode = false;
        this.isSetTransactionMode = false;
    }

    @Override
    public void startService() throws Exception {
        if (this.sessionFactoryServiceName != null) {
            this.sessionFactory = (JMSSessionFactory)ServiceManagerFactory.getServiceObject(this.sessionFactoryServiceName);
        }
        if (this.sessionFactory == null) {
            throw new IllegalArgumentException("JMSSessionFactoryServiceName or JMSSessionFactory must be specified.");
        }
    }

    @Override
    public void stopService() throws Exception {
        this.sessionFactory = null;
    }

    @Override
    public TransactionResource makeResource(String key) throws Exception {
        if (this.sessionFactory == null) {
            return null;
        }
        return new JMSSessionTransactionResource(this.sessionFactory.getConnection(), !this.isSetAckMode && !this.isSetTransactionMode ? this.sessionFactory.getSession() : this.sessionFactory.getSession(this.transactionMode, this.ackMode));
    }
}

