
import java.io.IOException;
import java.io.FileOutputStream;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

import org.jfree.chart.JFreeChart;

import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.graph.JFreeChartFactory;
import jp.ossc.nimbus.service.graph.JFreeChartCreateException;
import jp.ossc.nimbus.service.graph.ChartConditionImpl;
import jp.ossc.nimbus.service.graph.XYPlotConditionImpl;
import jp.ossc.nimbus.service.graph.DatasetConditionImpl;

/**
 * TvPsNXB
 */
public class Main{
    
    public static final void main(String[] args){
        
        // T[rX`t@C[h
        if(ServiceManagerFactory.loadManager("service-definition.xml")){
            System.out.println("T[rX`̓ǂݍ݂ɐ܂B");
            
            // JFreeChartFactoryT[rX擾
            JFreeChartFactory chartFactory = (JFreeChartFactory)ServiceManagerFactory.getServiceObject("ChartFactory");
            
            // ImageWriter擾
            ImageWriter imageWriter = (ImageWriter)ServiceManagerFactory.getServiceObject("ImageWriter");
            
            FileOutputStream fos = null;
            try{
                
                // Plot̐𐶐
                XYPlotConditionImpl plotCondition = new XYPlotConditionImpl();
                // `悷Plot̖Oݒ肷
                plotCondition.setName("Sample1");
                
                // JFreeChart̐𐶐
                ChartConditionImpl condition = new ChartConditionImpl();
                // `悷`[g̃^Cgݒ肷
                condition.setTitle("TvP");
                // Plot̐o^
                condition.addPlotCondition(plotCondition);
                
                // JFreeChart𐶐
                JFreeChart chart = chartFactory.createChart(condition);
                // obt@C[WɃ`[g`悷
                BufferedImage buffImg = chart.createBufferedImage(1024, 512);
                
                // o͂摜t@C̃Xg[J
                fos = new FileOutputStream("graph.png");
                // 摜o͗p̃Xg[Ńbv
                ImageOutputStream ios = ImageIO.createImageOutputStream(fos);
                // ImageWriterɉ摜o͗pXg[ݒ肷
                imageWriter.setOutput(ios);
                // obt@C[W摜o͗pXg[ɏ
                imageWriter.write(buffImg);
                // tbV
                ios.flush();
                // ImageWriteȑݏI
                imageWriter.dispose();
            }catch(IOException e){
                e.printStackTrace();
                System.exit(-1);
            }catch(JFreeChartCreateException e){
                e.printStackTrace();
                System.exit(-1);
            }finally{
                if(fos != null){
                    try{
                        // 摜t@C̃Xg[
                        fos.close();
                    }catch(IOException e){}
                }
            }
        }else{
            System.out.println("T[rX`̓ǂݍ݂Ɏs܂B");
        }
        
        // T[rX`t@CA[h
        ServiceManagerFactory.unloadManager("service-definition.xml");
    }
    
}