
import java.io.IOException;
import java.io.FileOutputStream;

import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.http.HttpClientFactory;
import jp.ossc.nimbus.service.http.HttpClient;
import jp.ossc.nimbus.service.http.HttpRequest;
import jp.ossc.nimbus.service.http.HttpResponse;

/**
 * TvPsNXB
 */
public class Main{
    
    public static final void main(String[] args) throws IOException{
        
        // T[rX`t@C[h
        if(ServiceManagerFactory.loadManager("service-definition.xml")){
            System.out.println("T[rX`̓ǂݍ݂ɐ܂B");
            
            // T[rX擾
            final HttpClientFactory factory = (HttpClientFactory)ServiceManagerFactory.getServiceObject("HttpClientFactory");
            
            // NCAg𐶐
            final HttpClient client = factory.createHttpClient();
            
            // vWFNggbvy[Wւ̃NGXg𐶐
            final HttpRequest projectTopPageRequest
                 = factory.createRequest("ProjectTopPage");
            
            // NGXgHTTPMāAX|X擾
            final HttpResponse projectTopPageResponse
                 = client.executeRequest(projectTopPageRequest);
            
            // X|XHTTPXe[^XmF
            if(projectTopPageResponse.getStatusCode() == 200){
                System.out.println(
                    "Normal status from " + projectTopPageRequest.getURL()
                     + " : " + projectTopPageResponse.getStatusCode()
                );
                
                // X|XHTML擾āAt@Cɏo͂
                final String html = (String)projectTopPageResponse.getObject();
                printFile("ProjectTopPage.html", html);
            }else{
                System.out.println(
                    "Error status from " + projectTopPageRequest.getURL()
                     + " : " + projectTopPageResponse.getStatusCode()
                );
            }
            
            // vWFNgz[y[Wւ̃NGXg𐶐
            final HttpRequest projectHomePageRequest
                 = factory.createRequest("ProjectHomePage");
            
            // NGXgHTTPMāAX|X擾
            final HttpResponse projectHomePageResponse
                 = client.executeRequest(projectHomePageRequest);
            
            // X|XHTTPXe[^XmF
            if(projectHomePageResponse.getStatusCode() == 200){
                System.out.println(
                    "Normal status from " + projectHomePageRequest.getURL()
                     + " : " + projectHomePageResponse.getStatusCode()
                );
                
                // X|XHTML擾āAt@Cɏo͂
                final String html = (String)projectHomePageResponse.getObject();
                printFile("ProjectHomePage.html", html);
            }else{
                System.out.println(
                    "Error status from " + projectHomePageRequest.getURL()
                     + " : " + projectHomePageResponse.getStatusCode()
                );
            }
            
            // NCAgI
            client.close();
        }else{
            System.out.println("T[rX`̓ǂݍ݂Ɏs܂B");
        }
        
        // T[rX`t@CA[h
        ServiceManagerFactory.unloadManager("service-definition.xml");
    }
    
    private static void printFile(String name, String html) throws IOException{
        final FileOutputStream fos = new FileOutputStream(name);
        final byte[] bytes = html.getBytes();
        fos.write(bytes, 0, bytes.length);
        fos.close();
    }
    
}