
import java.util.*;

import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.ioc.FacadeValueAccess;
import jp.ossc.nimbus.ioc.FacadeValue;
import jp.ossc.nimbus.ioc.UnitOfWork;
import jp.ossc.nimbus.ioc.CommandBase;
import jp.ossc.nimbus.ioc.Command;
import jp.ossc.nimbus.service.ioccall.FacadeCaller;

/**
 * TvPsNXB
 */
public class Main{
    
    public static final void main(String[] args) throws Throwable{
        
        // T[rX`t@C[h
        if(ServiceManagerFactory.loadManager("service-definition.xml")){
            System.out.println("T[rX`̓ǂݍ݂ɐ܂B");
            
            // T[rX擾
            FacadeCaller caller = (FacadeCaller)ServiceManagerFactory
                    .getServiceObject("IOCFacadeCaller");
            try{
                // e[u쐬yуR[hǉ𓯈gUNV
                // s邽߂ɁAR}hi[UnitOfWork𐶐
                UnitOfWork createAndInsertUOW
                     = FacadeValueAccess.createUnitOfWork();
                
                // e[u쐬R}h𐶐
                Command createCommand
                     = FacadeValueAccess.createCommand("CreateTable", null);
                // e[u쐬R}hUnitOfWorkɒǉ
                createAndInsertUOW.addCommand(createCommand);
                
                // ͂̃R[h𐶐
                System.out.println("R[h쐬");
                System.out.println("O,N,");
                List input = new ArrayList();
                for(int i = 0; i < 11; i++){
                    Map record = new HashMap();
                    record.put("name", "user" + i);
                    record.put("age", new Integer(i + 10));
                    record.put("sex", i % 2 == 0 ? "0" : "1");
                    input.add(record);
                    System.out.println(record.get("name")
                        + "," + record.get("age")
                        + "," + record.get("sex"));
                }
                
                // R[hǉR}h𐶐
                Command insertCommand
                     = FacadeValueAccess.createCommand("Insert", input);
                // R[hǉR}hUnitOfWorkɒǉ
                createAndInsertUOW.addCommand(insertCommand);
                
                // e[u쐬yуR[hǉ𓯈gUNVŎs
                UnitOfWork resultUOW
                     = caller.syncUnitOfWorkCall(createAndInsertUOW);
                
                // sʂĂ邩mF
                if(resultUOW.getStatus() != CommandBase.C_STATUS_COMPLETE){
                    System.out.println("e[u쐬yуR[hǉgUNVs : " + resultUOW.getStatus());
                    
                    // OĂ邩mF
                    if(resultUOW.getExceptionCount() != 0){
                        throw resultUOW.getExceptions()[0];
                    }
                    return;
                }
                
                // R[hR}hs
                // S
                // AAt[ɂāA5܂łʂԂȂ
                
                // R[hR}h𐶐
                Command searchAllCommand
                     = FacadeValueAccess.createCommand("Search", null);
                
                // R[hR}hs
                Command resultCommand
                     = caller.syncCommandCall(searchAllCommand);
                
                // sʂĂ邩mF
                if(resultCommand.getStatus() != CommandBase.C_STATUS_COMPLETE){
                    System.out.println("R[hgUNVs : " + resultCommand.getStatus());
                    
                    // OĂ邩mF
                    if(resultCommand.getExceptionCount() != 0){
                        throw resultCommand.getExceptions()[0];
                    }
                    return;
                }
                
                // sʂ擾
                List output = (List)resultCommand.getOutputObject();
                System.out.println("SiőTj");
                System.out.println("O,N,");
                for(int i = 0, max = output.size(); i < max; i++){
                    Map record = (Map)output.get(i);
                    System.out.println(record.get("name")
                        + "," + record.get("age")
                        + "," + record.get("sex"));
                }
                
                // Q̃R[ht[ʃgUNVłPxɎs
                // PF
                //   ŁA[UƂēn
                //   ʊY
                // QF
                //   ŁA[UƂēn
                //   ʊYȂ
                
                // PR}h𐶐
                Command search1Command
                     = FacadeValueAccess.createCommand("Search", "user10");
                // PƗgUNVŎs邽߂
                // R}hi[UnitOfWork𐶐
                UnitOfWork search1UOW = FacadeValueAccess.createUnitOfWork();
                // PUnitOfWorkɒǉ
                search1UOW.addCommand(search1Command);
                
                // QR}h𐶐
                Command search2Command
                     = FacadeValueAccess.createCommand("Search", "user100");
                // QƗgUNVŎs邽߂
                // R}hi[UnitOfWork𐶐
                UnitOfWork search2UOW = FacadeValueAccess.createUnitOfWork();
                // QUnitOfWorkɒǉ
                search2UOW.addCommand(search2Command);
                
                // PUnitOfWorkƌQUnitOfWorkɎs邽߂
                // FacadeValue𐶐āAeUnitOfWorkǉ
                FacadeValue search1And2FV
                     = FacadeValueAccess.createCommandsValue();
                search1And2FV.addUnitOfWork(search1UOW);
                search1And2FV.addUnitOfWork(search2UOW);
                
                // PƌQꂼʃgUNVŎs
                FacadeValue resultFV = caller.syncFacadeCall(search1And2FV);
                
                // P̌ʂo
                UnitOfWork resutl1UOW = (UnitOfWork)resultFV.getCommand(0);
                Command resutl1Command = (Command)resutl1UOW.getCommand(0);
                
                // sʂĂ邩mF
                if(resutl1Command.getStatus() != CommandBase.C_STATUS_COMPLETE){
                    System.out.println("PgUNVs : " + resutl1Command.getStatus());
                }else{
                    System.out.println("P : user10");
                    // sʂ擾
                    Map record = (Map)resutl1Command.getOutputObject();
                    System.out.println(record.get("name")
                        + "," + record.get("age")
                        + "," + record.get("sex"));
                }
                
                // Q̌ʂo
                UnitOfWork resutl2UOW = (UnitOfWork)resultFV.getCommand(1);
                Command resutl2Command = (Command)resutl2UOW.getCommand(0);
                
                // sʂĂ邩mF
                if(resutl2Command.getStatus() != CommandBase.C_STATUS_COMPLETE){
                    System.out.println("QgUNVs : " + resutl2Command.getStatus());
                }else{
                    System.out.println("Q : user100");
                    // sʂ擾
                    Map record = (Map)resutl2Command.getOutputObject();
                    System.out.println(record);
                }
            }finally{
                // e[u폜R}h𐶐
                Command deleteCommand
                     = FacadeValueAccess.createCommand("DropTable", null);
                
                // e[u폜R}hs
                Command resultCommand = caller.syncCommandCall(deleteCommand);
            }
        }else{
            System.out.println("T[rX`̓ǂݍ݂Ɏs܂B");
        }
        
        // T[rX`t@CA[h
        ServiceManagerFactory.unloadManager("service-definition.xml");
    }
    
}