<%@page import="jp.ossc.nimbus.service.scheduler2.DefaultSchedule"%>
<%@page import="jp.ossc.nimbus.service.scheduler2.Schedule"%>
<%@page import="jp.ossc.nimbus.service.scheduler2.DefaultScheduleMaster"%>
<%@page import="jp.ossc.nimbus.service.scheduler2.ScheduleMaster"%>
<%@ page contentType="text/html; charset=Windows-31J" %>
<%@ page language="java" %>
<%@ page import="java.text.*" %>
<%@ page import="java.util.*" %>
<%@ page import="java.lang.String" %>
<%@ page import="jp.ossc.nimbus.service.scheduler2.sample.*" %>
<%
    String trn_id = request.getParameter("tid");
    String master_id = request.getParameter("mid");

    HashMap outMap = (HashMap)request.getAttribute("output");

    ScheduleMaster master = (DefaultScheduleMaster)outMap.get("master");
    ArrayList trans   = (ArrayList)outMap.get("trans");
    TreeSet depends1  = (TreeSet)outMap.get("depends1");
    TreeSet depends2  = (TreeSet)outMap.get("depends2");
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title>schedule_master</title>
<link rel="stylesheet" type="text/css" href="css/sample-main.css" />
<script language="javascript" type="text/javascript" src="js/jquery.js"></script>
</head>

<body>
<jsp:include page="menu.jsp" flush="true" />

<div id="title">
<a href="./scheduleMasterList.bf">XPW[}X^</a> / <%=master_id%>
</div>

<!-- }X^ -->
<div id="contents">
<div class="subtitle">SCHEDULE_MASTER</div>
<table class="list" align="center">
<tr>
    <th colspan=2>id</th>
    <th colspan=2>task_name</th>
    <th colspan=2>schedule_type</th>
</tr>
<tr>
    <td colspan=2><%=master.getId() %></td>
    <td colspan=2><%=master.getTaskName()%></td>
    <td colspan=2><%=master.getScheduleType()%></td>
</tr>
<tr>
    <th>input</th>
    <th>start_time</th>
    <th>end_time</th>
    <th>repeat_intarval</th>
    <th>retry_end_time</th>
    <th>max_delay_time</th>
</tr>
<tr>
    <td><%=master.getInput()%></td>
    <td><%=FormatUtil.format(FormatUtil.DATE_FORMAT_PATTERN_TIME6_COLON, master.getStartTime())%></td>
    <td><%=FormatUtil.format(FormatUtil.DATE_FORMAT_PATTERN_TIME6_COLON, master.getEndTime())%></td>
    <td><%=new Long(master.getRepeatInterval()).toString()%></td>
    <td><%=FormatUtil.format(FormatUtil.DATE_FORMAT_PATTERN_TIME6_COLON, master.getRetryEndTime())%></td>
    <td><%=new Long(master.getMaxDelayTime()).toString()%></td>
</tr>
</table>
<br/>
<br/>

<!-- ˑ(s) -->
<div class="subtitle">SCHEDULE_DEPENDS_MASTER (preceding)</div>
<table class="list" align="center">
<tr>
    <th>depends_id</th>
</tr>
<%
    Iterator it = depends1.iterator();
    while(it.hasNext()){
        String id = (String)it.next();
%>
<tr>
    <td>
    <% if (id != null ) {%>
        <a href="./scheduleMaster.bf?mid=<%=id%>"><%=id%></a>
    <% } %>
    </td>
</tr>
<%
    }
%>
</table>
<br/>
<br/>

<!-- ˑ(㑱) -->
<div class="subtitle">SCHEDULE_DEPENDS_MASTER (following)</div>
<table class="list" align="center">
<tr>
    <th>depends_id</th>
</tr>
<%
    Iterator it2 = depends2.iterator();
    while(it2.hasNext()){
        String id = (String)it2.next();
%>
<tr>
    <td>
    <% if (id != null ) {%>
        <a href="./scheduleMaster.bf?mid=<%=id%>"><%=id%></a>
    <% } %>
    </td>
</tr>
<%
    }
%>
</table>
<br/>
<br/>

<!-- g -->
<div class="subtitle">SCHEDULE_TRN</div>
<table class="list" align="center">
<tr>
    <th>id</th>
    <th>s_date</th>
    <th>state</th>
    <th>exec_s_time</th>
    <th>exec_e_time</th>
    <th>exec_time</th>
</tr>
<%
    StringBuffer g_data = new StringBuffer();	// Otpf[^

    long max_delay_time = master.getMaxDelayTime();
    long max_exec_time = 0;
    if (max_delay_time != Long.MIN_VALUE ) {
        max_delay_time = max_delay_time / 1000;  // ~bb
        max_exec_time = max_delay_time;
    } else {
        max_delay_time = 0;
    }

    for (int i=0; i<trans.size(); i++) {
        Schedule schedule = (DefaultSchedule)trans.get(i);

        Date exec_s_date = schedule.getExecuteStartTime();
        Date exec_e_date = schedule.getExecuteEndTime();

        // 
        long exec_time = Long.MIN_VALUE;
        if (exec_e_date != null && exec_s_date != null) {
            exec_time = exec_e_date.getTime() - exec_s_date.getTime();
            exec_time = exec_time / 1000; // ~bb
        }

        // Otp
        if (i>0) g_data.append(",");
        if (exec_time != Long.MIN_VALUE) {
            if (exec_time > max_exec_time) max_exec_time = exec_time;
            g_data.append("['").append(schedule.getId()).append("','").append(Long.toString(exec_time)).append("']");
        } else {
            g_data.append("['").append(schedule.getId()).append("','0']");
        }
%>
<tr>
    <td><a href="./scheduleTrn.bf?tid=<%=schedule.getId()%>"><%=schedule.getId()%></a></td>
    <td><%=FormatUtil.format(FormatUtil.DATE_FORMAT_PATTERN_DATE8_TIME6_SIGN, schedule.getTime())%></td>
    <td><%=FormatUtil.getStateKana(schedule.getState())%></td>
    <td><%=FormatUtil.format(FormatUtil.DATE_FORMAT_PATTERN_DATE8_TIME6_SIGN, exec_s_date)%></td>
    <td><%=FormatUtil.format(FormatUtil.DATE_FORMAT_PATTERN_DATE8_TIME6_SIGN, exec_e_date)%></td>
    <td><%=FormatUtil.execTime(exec_time)%></td>
</tr>
<%
    }
%>
</table>
</div>
<br/>


</body>
</html>