/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.io.Serializable;
import jp.ossc.nimbus.beans.ConcatenatedProperty;
import jp.ossc.nimbus.beans.IndexedProperty;
import jp.ossc.nimbus.beans.MappedProperty;
import jp.ossc.nimbus.beans.NestedProperty;
import jp.ossc.nimbus.beans.OrProperty;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.SimpleProperty;

public class PropertyFactory
implements Serializable {
    private static final long serialVersionUID = 393005154068498255L;

    public static Property createProperty(String prop) throws IllegalArgumentException {
        Property property = null;
        StringBuffer buf = new StringBuffer();
        boolean isEscape = false;
        boolean isIndexedStart = false;
        boolean isMappedStart = false;
        boolean isGroupStart = false;
        int max = prop.length();
        for (int i = 0; i < max; ++i) {
            char c = prop.charAt(i);
            switch (c) {
                case '\\': {
                    if (isEscape) {
                        buf.append(c);
                        isEscape = false;
                        break;
                    }
                    if (i == max - 1) {
                        buf.append(c);
                        break;
                    }
                    isEscape = true;
                    break;
                }
                case '.': {
                    if (isEscape || isMappedStart || isIndexedStart) {
                        buf.append(c);
                        isEscape = false;
                        break;
                    }
                    if (i == max - 1) {
                        throw new IllegalArgumentException("'.' must not be last. : " + prop);
                    }
                    if (property == null) {
                        if (buf.length() == 0) {
                            throw new IllegalArgumentException("Before '.', a literal is required. : " + prop);
                        }
                        property = new NestedProperty();
                        ((NestedProperty)property).setThisProperty(new SimpleProperty(buf.toString()));
                    } else if (buf.length() == 0) {
                        IndexedProperty tmpProperty = property;
                        property = new NestedProperty();
                        ((NestedProperty)property).setThisProperty(tmpProperty);
                    } else {
                        SimpleProperty next = new SimpleProperty(buf.toString());
                        if (property instanceof NestedProperty) {
                            ((NestedProperty)property).setNestedProperty(next);
                        } else if (property instanceof OrProperty) {
                            ((OrProperty)property).setSecondProperty(next);
                        } else if (property instanceof ConcatenatedProperty) {
                            ((ConcatenatedProperty)property).setConcatenatedProperty(next);
                        }
                        Property tmpProperty = property;
                        property = new NestedProperty();
                        ((NestedProperty)property).setThisProperty(tmpProperty);
                    }
                    buf.setLength(0);
                    break;
                }
                case '|': {
                    if (isEscape || isMappedStart || isIndexedStart) {
                        buf.append(c);
                        isEscape = false;
                        break;
                    }
                    if (i == max - 1) {
                        throw new IllegalArgumentException("'|' must not be last. : " + prop);
                    }
                    if (property == null) {
                        if (buf.length() == 0) {
                            throw new IllegalArgumentException("Before '|', a literal is required. : " + prop);
                        }
                        property = new OrProperty();
                        ((OrProperty)property).setFirstProperty(new SimpleProperty(buf.toString()));
                    } else if (buf.length() == 0) {
                        IndexedProperty tmpProperty = property;
                        property = new OrProperty();
                        ((OrProperty)property).setFirstProperty(tmpProperty);
                    } else {
                        SimpleProperty next = new SimpleProperty(buf.toString());
                        if (property instanceof NestedProperty) {
                            ((NestedProperty)property).setNestedProperty(next);
                        } else if (property instanceof OrProperty) {
                            ((OrProperty)property).setSecondProperty(next);
                        } else if (property instanceof ConcatenatedProperty) {
                            ((ConcatenatedProperty)property).setConcatenatedProperty(next);
                        }
                        Property tmpProperty = property;
                        property = new OrProperty();
                        ((OrProperty)property).setFirstProperty(tmpProperty);
                    }
                    buf.setLength(0);
                    break;
                }
                case '+': {
                    if (isEscape || isMappedStart || isIndexedStart) {
                        buf.append(c);
                        isEscape = false;
                        break;
                    }
                    if (i == max - 1) {
                        throw new IllegalArgumentException("'+' must not be last. : " + prop);
                    }
                    if (property == null) {
                        if (buf.length() == 0) {
                            throw new IllegalArgumentException("Before '+', a literal is required. : " + prop);
                        }
                        property = new ConcatenatedProperty();
                        ((ConcatenatedProperty)property).setThisProperty(new SimpleProperty(buf.toString()));
                    } else if (buf.length() == 0) {
                        IndexedProperty tmpProperty = property;
                        property = new ConcatenatedProperty();
                        ((ConcatenatedProperty)property).setThisProperty(tmpProperty);
                    } else {
                        SimpleProperty next = new SimpleProperty(buf.toString());
                        if (property instanceof NestedProperty) {
                            ((NestedProperty)property).setNestedProperty(next);
                        } else if (property instanceof OrProperty) {
                            ((OrProperty)property).setSecondProperty(next);
                        } else if (property instanceof ConcatenatedProperty) {
                            ((ConcatenatedProperty)property).setConcatenatedProperty(next);
                        }
                        Property tmpProperty = property;
                        property = new ConcatenatedProperty();
                        ((ConcatenatedProperty)property).setThisProperty(tmpProperty);
                    }
                    buf.setLength(0);
                    break;
                }
                case '[': {
                    buf.append(c);
                    if (isEscape || isMappedStart || isIndexedStart) {
                        isEscape = false;
                        break;
                    }
                    if (i == max - 1) {
                        throw new IllegalArgumentException("'[' must not be last. : " + prop);
                    }
                    if (property != null) {
                        boolean isNext = false;
                        isNext = property instanceof NestedProperty ? ((NestedProperty)property).getNestedProperty() != null : (property instanceof OrProperty ? ((OrProperty)property).getSecondProperty() != null : (property instanceof ConcatenatedProperty ? ((ConcatenatedProperty)property).getConcatenatedProperty() != null : true));
                        if (isNext) {
                            Property tmpProperty = property;
                            property = new NestedProperty();
                            ((NestedProperty)property).setThisProperty(tmpProperty);
                        }
                    }
                    isIndexedStart = true;
                    break;
                }
                case ']': {
                    buf.append(c);
                    if (isEscape || isMappedStart) {
                        isEscape = false;
                        break;
                    }
                    if (!isIndexedStart) {
                        throw new IllegalArgumentException("Before ']', '[' is required. : " + prop);
                    }
                    if (buf.length() == 0) {
                        throw new IllegalArgumentException("Before ']', a literal is required. : " + prop);
                    }
                    if (property == null) {
                        property = new IndexedProperty();
                        property.parse(buf.toString());
                    } else {
                        IndexedProperty next = new IndexedProperty();
                        next.parse(buf.toString());
                        if (property instanceof NestedProperty) {
                            ((NestedProperty)property).setNestedProperty(next);
                        } else if (property instanceof OrProperty) {
                            ((OrProperty)property).setSecondProperty(next);
                        } else if (property instanceof ConcatenatedProperty) {
                            ((ConcatenatedProperty)property).setConcatenatedProperty(next);
                        }
                    }
                    buf.setLength(0);
                    isIndexedStart = false;
                    break;
                }
                case '(': {
                    buf.append(c);
                    if (isEscape || isMappedStart || isIndexedStart) {
                        isEscape = false;
                        break;
                    }
                    if (i == max - 1) {
                        throw new IllegalArgumentException("'(' must not be last. : " + prop);
                    }
                    if (property != null) {
                        boolean isNext = false;
                        isNext = property instanceof NestedProperty ? ((NestedProperty)property).getNestedProperty() != null : (property instanceof OrProperty ? ((OrProperty)property).getSecondProperty() != null : (property instanceof ConcatenatedProperty ? ((ConcatenatedProperty)property).getConcatenatedProperty() != null : true));
                        if (isNext) {
                            Property tmpProperty = property;
                            property = new NestedProperty();
                            ((NestedProperty)property).setThisProperty(tmpProperty);
                        }
                    }
                    isMappedStart = true;
                    break;
                }
                case ')': {
                    buf.append(c);
                    if (isEscape || isIndexedStart) {
                        isEscape = false;
                        break;
                    }
                    if (!isMappedStart) {
                        throw new IllegalArgumentException("Before ')', '(' is required. : " + prop);
                    }
                    if (buf.length() == 0) {
                        throw new IllegalArgumentException("Before ')', a literal is required. : " + prop);
                    }
                    if (property == null) {
                        property = new MappedProperty();
                        property.parse(buf.toString());
                    } else {
                        MappedProperty next = new MappedProperty();
                        next.parse(buf.toString());
                        if (property instanceof NestedProperty) {
                            ((NestedProperty)property).setNestedProperty(next);
                        } else if (property instanceof OrProperty) {
                            ((OrProperty)property).setSecondProperty(next);
                        } else if (property instanceof ConcatenatedProperty) {
                            ((ConcatenatedProperty)property).setConcatenatedProperty(next);
                        }
                    }
                    buf.setLength(0);
                    isMappedStart = false;
                    break;
                }
                case '{': {
                    if (isEscape || isMappedStart || isIndexedStart) {
                        buf.append(c);
                        isEscape = false;
                        break;
                    }
                    if (i == max - 1) {
                        throw new IllegalArgumentException("'{' must not be last. : " + prop);
                    }
                    boolean isEscape2 = false;
                    boolean isIndexedStart2 = false;
                    boolean isMappedStart2 = false;
                    int groupStartCount = 0;
                    boolean isBreak = false;
                    StringBuffer groupBuf = new StringBuffer();
                    while (++i < max) {
                        char c2 = prop.charAt(i);
                        switch (c2) {
                            case '\\': {
                                groupBuf.append(c2);
                                if (isEscape2) {
                                    isEscape2 = false;
                                    break;
                                }
                                isEscape2 = true;
                                break;
                            }
                            case '(': {
                                groupBuf.append(c2);
                                if (isEscape2 || isMappedStart2 || isIndexedStart2) {
                                    isEscape2 = false;
                                    break;
                                }
                                isMappedStart2 = true;
                                break;
                            }
                            case ')': {
                                groupBuf.append(c2);
                                if (isEscape2 || isIndexedStart2) {
                                    isEscape2 = false;
                                    break;
                                }
                                isMappedStart2 = false;
                                break;
                            }
                            case '[': {
                                groupBuf.append(c2);
                                if (isEscape2 || isMappedStart2 || isIndexedStart2) {
                                    isEscape2 = false;
                                    break;
                                }
                                isIndexedStart2 = true;
                                break;
                            }
                            case ']': {
                                groupBuf.append(c2);
                                if (isEscape2 || isMappedStart2) {
                                    isEscape2 = false;
                                    break;
                                }
                                isIndexedStart2 = false;
                                break;
                            }
                            case '{': {
                                groupBuf.append(c2);
                                if (isEscape2 || isMappedStart2 || isIndexedStart2) {
                                    isEscape2 = false;
                                    break;
                                }
                                ++groupStartCount;
                                break;
                            }
                            case '}': {
                                if (isEscape2 || isMappedStart2 || isIndexedStart2) {
                                    isEscape2 = false;
                                    break;
                                }
                                if (groupStartCount == 0) {
                                    isBreak = true;
                                    break;
                                }
                                groupBuf.append(c2);
                                --groupStartCount;
                                break;
                            }
                            default: {
                                groupBuf.append(c2);
                            }
                        }
                        if (!isBreak) continue;
                        break;
                    }
                    if (!isBreak) {
                        throw new IllegalArgumentException("'{' must be terminated with '}'. : " + prop);
                    }
                    Property next = PropertyFactory.createProperty(groupBuf.toString());
                    if (property == null) {
                        property = next;
                        break;
                    }
                    if (property instanceof NestedProperty) {
                        ((NestedProperty)property).setNestedProperty(next);
                        break;
                    }
                    if (property instanceof OrProperty) {
                        ((OrProperty)property).setSecondProperty(next);
                        break;
                    }
                    if (!(property instanceof ConcatenatedProperty)) break;
                    ((ConcatenatedProperty)property).setConcatenatedProperty(next);
                    break;
                }
                default: {
                    if (isEscape) {
                        buf.append('\\');
                        isEscape = false;
                    }
                    buf.append(c);
                    if (i != max - 1) break;
                    SimpleProperty next = new SimpleProperty(buf.toString());
                    if (property == null) {
                        property = next;
                        break;
                    }
                    if (property instanceof NestedProperty) {
                        ((NestedProperty)property).setNestedProperty(next);
                        break;
                    }
                    if (property instanceof OrProperty) {
                        ((OrProperty)property).setSecondProperty(next);
                        break;
                    }
                    if (!(property instanceof ConcatenatedProperty)) break;
                    ((ConcatenatedProperty)property).setConcatenatedProperty(next);
                }
            }
            if (i != max - 1) continue;
            if (isIndexedStart) {
                throw new IllegalArgumentException("'[' must be terminated with ']'. : " + prop);
            }
            if (!isMappedStart) continue;
            throw new IllegalArgumentException("'(' must be terminated with ')'. : " + prop);
        }
        return property;
    }
}

