/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.PropertyEditorSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import jp.ossc.nimbus.beans.ServiceNameRefEditor;
import jp.ossc.nimbus.beans.Utility;
import jp.ossc.nimbus.core.ServiceNameRef;

public class ServiceNameRefArrayEditor
extends PropertyEditorSupport
implements Serializable {
    private static final long serialVersionUID = -775657044870026063L;
    private String managerName;

    public void setServiceManagerName(String name) {
        this.managerName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsText(String text) {
        if (text == null) {
            this.setValue(null);
            return;
        }
        String tmpText = Utility.replaceSystemProperty(Utility.xmlComentOut(text));
        int length = tmpText.length();
        StringReader sr = new StringReader(tmpText);
        BufferedReader br = new BufferedReader(sr, length);
        ArrayList<Object> list = new ArrayList<Object>();
        ServiceNameRefEditor editor = new ServiceNameRefEditor();
        editor.setServiceManagerName(this.managerName);
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                String refName = Utility.trim(line);
                if (refName.length() == 0) continue;
                editor.setAsText(refName);
                list.add(editor.getValue());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            sr.close();
        }
        this.setValue(list.toArray(new ServiceNameRef[list.size()]));
    }

    @Override
    public String getAsText() {
        ServiceNameRef[] names = (ServiceNameRef[])this.getValue();
        if (names == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        int max = names.length;
        for (int i = 0; i < max; ++i) {
            writer.print(names[i].toString());
            if (i == max - 1) continue;
            writer.println();
        }
        return sw.toString();
    }
}

