/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans.dataset;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.ossc.nimbus.beans.dataset.Header;
import jp.ossc.nimbus.beans.dataset.PropertyGetException;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.beans.dataset.PropertyValidateException;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.beans.dataset.RecordSchema;

public class DataSet
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 452460154073106633L;
    protected String name;
    protected Map headerMap;
    protected Map recordListMap;
    protected transient Map nestedRecordListMap;
    protected transient Map nestedRecordListClassMap;
    protected transient Map nestedRecordMap;
    protected transient Map nestedRecordClassMap;
    protected boolean isSynchronized = true;

    public DataSet() {
        this(true);
    }

    public DataSet(boolean isSynch) {
        this.isSynchronized = isSynch;
    }

    public DataSet(String name) {
        this(name, true);
    }

    public DataSet(String name, boolean isSynch) {
        this.name = name;
        this.isSynchronized = isSynch;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHeaderSchema(String schema) throws PropertySchemaDefineException {
        this.setHeaderSchema(null, schema);
    }

    protected Header createHeader(String name, String schema) throws PropertySchemaDefineException {
        return new Header(name, schema);
    }

    protected Header createHeader(String name, RecordSchema schema) throws PropertySchemaDefineException {
        return new Header(name, schema);
    }

    public void setHeaderSchema(String name, String schema) throws PropertySchemaDefineException {
        if (this.headerMap == null) {
            this.headerMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
        }
        this.headerMap.put(name, this.createHeader(name, schema));
    }

    public void setHeaderSchema(RecordSchema schema) {
        this.setHeaderSchema(null, schema);
    }

    public void setHeaderSchema(String name, RecordSchema schema) {
        if (this.headerMap == null) {
            this.headerMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
        }
        this.headerMap.put(name, this.createHeader(name, schema));
    }

    public void setHeaderClass(String name, Class clazz) throws PropertySchemaDefineException {
        Header header = null;
        try {
            Constructor c = clazz.getConstructor(String.class);
            header = (Header)c.newInstance(name);
        }
        catch (NoSuchMethodException e) {
            try {
                header = (Header)clazz.newInstance();
            }
            catch (InstantiationException e2) {
                throw new PropertySchemaDefineException(null, e2);
            }
            catch (IllegalAccessException e2) {
                throw new PropertySchemaDefineException(null, e2);
            }
        }
        catch (InstantiationException e) {
            throw new PropertySchemaDefineException(null, e);
        }
        catch (IllegalAccessException e) {
            throw new PropertySchemaDefineException(null, e);
        }
        catch (InvocationTargetException e) {
            throw new PropertySchemaDefineException(null, e.getTargetException());
        }
        catch (ClassCastException e) {
            throw new PropertySchemaDefineException(null, e);
        }
        if (this.headerMap == null) {
            this.headerMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
        }
        this.headerMap.put(name, header);
    }

    public void setHeaderClass(Class clazz) {
        this.setHeaderClass(null, clazz);
    }

    public void setRecordListSchema(String schema) throws PropertySchemaDefineException {
        this.setRecordListSchema(null, schema);
    }

    protected RecordList createRecordList(String name, String schema) throws PropertySchemaDefineException {
        return new RecordList(name, schema, this.isSynchronized);
    }

    protected RecordList createRecordList(String name, RecordSchema schema) throws PropertySchemaDefineException {
        return new RecordList(name, schema, this.isSynchronized);
    }

    public void setRecordListSchema(String name, String schema) throws PropertySchemaDefineException {
        if (this.recordListMap == null) {
            this.recordListMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
        }
        this.recordListMap.put(name, this.createRecordList(name, schema));
    }

    public void setRecordListSchema(RecordSchema schema) {
        this.setRecordListSchema(null, schema);
    }

    public void setRecordListSchema(String name, RecordSchema schema) {
        if (this.recordListMap == null) {
            this.recordListMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
        }
        this.recordListMap.put(name, this.createRecordList(name, schema));
    }

    public void setNestedRecordListSchema(String name, String schema) throws PropertySchemaDefineException {
        if (this.nestedRecordListMap == null) {
            this.nestedRecordListMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
        }
        RecordSchema recSchema = RecordSchema.getInstance(schema);
        this.nestedRecordListMap.put(name, recSchema.getSchema());
    }

    public void setNestedRecordListClass(String name, Class clazz) throws PropertySchemaDefineException {
        RecordList list = null;
        try {
            Constructor c = clazz.getConstructor(String.class);
            list = (RecordList)c.newInstance(name);
        }
        catch (NoSuchMethodException e) {
            try {
                list = (RecordList)clazz.newInstance();
            }
            catch (InstantiationException e2) {
                throw new PropertySchemaDefineException(null, e2);
            }
            catch (IllegalAccessException e2) {
                throw new PropertySchemaDefineException(null, e2);
            }
        }
        catch (InstantiationException e) {
            throw new PropertySchemaDefineException(null, e);
        }
        catch (IllegalAccessException e) {
            throw new PropertySchemaDefineException(null, e);
        }
        catch (InvocationTargetException e) {
            throw new PropertySchemaDefineException(null, e.getTargetException());
        }
        catch (ClassCastException e) {
            throw new PropertySchemaDefineException(null, e);
        }
        if (this.nestedRecordListMap == null) {
            this.nestedRecordListMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
        }
        this.nestedRecordListMap.put(name, list.getSchema());
        if (this.nestedRecordListClassMap == null) {
            this.nestedRecordListClassMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
        }
        this.nestedRecordListClassMap.put(name, clazz);
    }

    public void setRecordListClass(String name, Class clazz) throws PropertySchemaDefineException {
        RecordList list = null;
        try {
            Constructor c = clazz.getConstructor(String.class);
            list = (RecordList)c.newInstance(name);
        }
        catch (NoSuchMethodException e) {
            try {
                list = (RecordList)clazz.newInstance();
            }
            catch (InstantiationException e2) {
                throw new PropertySchemaDefineException(null, e2);
            }
            catch (IllegalAccessException e2) {
                throw new PropertySchemaDefineException(null, e2);
            }
        }
        catch (InstantiationException e) {
            throw new PropertySchemaDefineException(null, e);
        }
        catch (IllegalAccessException e) {
            throw new PropertySchemaDefineException(null, e);
        }
        catch (InvocationTargetException e) {
            throw new PropertySchemaDefineException(null, e.getTargetException());
        }
        catch (ClassCastException e) {
            throw new PropertySchemaDefineException(null, e);
        }
        if (this.recordListMap == null) {
            this.recordListMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
        }
        this.recordListMap.put(name, list);
    }

    public void setRecordListClass(Class clazz) {
        this.setRecordListClass(null, clazz);
    }

    public void setNestedRecordListSchema(String name, RecordSchema schema) {
        if (this.nestedRecordListMap == null) {
            this.nestedRecordListMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
        }
        this.nestedRecordListMap.put(name, schema.getSchema());
    }

    public RecordSchema getNestedRecordListSchema(String name) throws PropertySchemaDefineException {
        if (this.nestedRecordListMap == null) {
            return null;
        }
        String schema = (String)this.nestedRecordListMap.get(name);
        return schema == null ? null : RecordSchema.getInstance(schema);
    }

    public String[] getNestedRecordListSchemaNames() {
        return this.nestedRecordListMap == null ? new String[]{} : this.nestedRecordListMap.keySet().toArray(new String[this.nestedRecordListMap.size()]);
    }

    public int getNestedRecordListSchemaSize() {
        return this.nestedRecordListMap == null ? 0 : this.nestedRecordListMap.size();
    }

    public Map getNestedRecordListSchemaMap() {
        if (this.nestedRecordListMap == null) {
            this.nestedRecordListMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
        }
        return this.nestedRecordListMap;
    }

    public void setNestedRecordSchema(String name, String schema) throws PropertySchemaDefineException {
        if (this.nestedRecordMap == null) {
            this.nestedRecordMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
        }
        RecordSchema recSchema = RecordSchema.getInstance(schema);
        this.nestedRecordMap.put(name, recSchema.getSchema());
    }

    public void setNestedRecordSchema(String name, RecordSchema schema) {
        if (this.nestedRecordMap == null) {
            this.nestedRecordMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
        }
        this.nestedRecordMap.put(name, schema.getSchema());
    }

    public void setNestedRecordClass(String name, Class clazz) throws PropertySchemaDefineException {
        Record record = null;
        try {
            record = (Record)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new PropertySchemaDefineException(null, e);
        }
        catch (IllegalAccessException e) {
            throw new PropertySchemaDefineException(null, e);
        }
        catch (ClassCastException e) {
            throw new PropertySchemaDefineException(null, e);
        }
        if (this.nestedRecordMap == null) {
            this.nestedRecordMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
        }
        this.nestedRecordMap.put(name, record.getSchema());
        if (this.nestedRecordClassMap == null) {
            this.nestedRecordClassMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
        }
        this.nestedRecordClassMap.put(name, clazz);
    }

    public RecordSchema getNestedRecordSchema(String name) throws PropertySchemaDefineException {
        if (this.nestedRecordMap == null) {
            return null;
        }
        String schema = (String)this.nestedRecordMap.get(name);
        return schema == null ? null : RecordSchema.getInstance(schema);
    }

    public String[] getNestedRecordSchemaNames() {
        return this.nestedRecordMap == null ? new String[]{} : this.nestedRecordMap.keySet().toArray(new String[this.nestedRecordMap.size()]);
    }

    public int getNestedRecordSchemaSize() {
        return this.nestedRecordMap == null ? 0 : this.nestedRecordMap.size();
    }

    public Map getNestedRecordSchemaMap() {
        if (this.nestedRecordMap == null) {
            this.nestedRecordMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
        }
        return this.nestedRecordMap;
    }

    public void setSchema(String headerSchema, String recordListSchema) throws PropertySchemaDefineException {
        this.setSchema(null, headerSchema, recordListSchema);
    }

    public void setSchema(String name, RecordSchema headerSchema, RecordSchema recordListSchema) {
        if (headerSchema != null) {
            this.setHeaderSchema(name, headerSchema);
        }
        if (recordListSchema != null) {
            this.setRecordListSchema(name, recordListSchema);
        }
    }

    public void setSchema(RecordSchema headerSchema, RecordSchema recordListSchema) {
        this.setSchema(null, headerSchema, recordListSchema);
    }

    public void setSchema(String name, String headerSchema, String recordListSchema) throws PropertySchemaDefineException {
        if (headerSchema != null) {
            this.setHeaderSchema(name, headerSchema);
        }
        if (recordListSchema != null) {
            this.setRecordListSchema(name, recordListSchema);
        }
    }

    public Header getHeader() {
        return this.getHeader(null);
    }

    public Header getHeader(String name) {
        return this.headerMap == null ? null : (Header)this.headerMap.get(name);
    }

    public String[] getHeaderNames() {
        return this.headerMap == null ? new String[]{} : this.headerMap.keySet().toArray(new String[this.headerMap.size()]);
    }

    public int getHeaderSize() {
        return this.headerMap == null ? 0 : this.headerMap.size();
    }

    public Map getHeaderMap() {
        if (this.headerMap == null) {
            this.headerMap = Collections.synchronizedMap(new LinkedHashMap());
        }
        return this.headerMap;
    }

    public void addHeader(Header header) {
        if (this.headerMap == null) {
            this.headerMap = Collections.synchronizedMap(new LinkedHashMap());
        }
        this.headerMap.put(header.getName(), header);
    }

    public RecordList getRecordList() {
        return this.getRecordList(null);
    }

    public RecordList getRecordList(String name) {
        return this.recordListMap == null ? null : (RecordList)this.recordListMap.get(name);
    }

    public String[] getRecordListNames() {
        return this.recordListMap == null ? new String[]{} : this.recordListMap.keySet().toArray(new String[this.recordListMap.size()]);
    }

    public int getRecordListSize() {
        return this.recordListMap == null ? 0 : this.recordListMap.size();
    }

    public Map getRecordListMap() {
        if (this.recordListMap == null) {
            this.recordListMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
        }
        return this.recordListMap;
    }

    public void addRecordList(RecordList recList) {
        if (this.recordListMap == null) {
            this.recordListMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
        }
        this.recordListMap.put(recList.getName(), recList);
    }

    public RecordList createNestedRecordList(String name) {
        Class clazz;
        if (this.nestedRecordListMap == null || !this.nestedRecordListMap.containsKey(name)) {
            return null;
        }
        if (this.nestedRecordListClassMap != null && (clazz = (Class)this.nestedRecordListClassMap.get(name)) != null) {
            try {
                Constructor c = clazz.getConstructor(String.class);
                return (RecordList)c.newInstance(name);
            }
            catch (NoSuchMethodException e) {
                try {
                    return (RecordList)clazz.newInstance();
                }
                catch (Exception e2) {
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.createRecordList(name, RecordSchema.getInstance((String)this.nestedRecordListMap.get(name)));
    }

    public Record createNestedRecord(String name) {
        Class clazz;
        if (this.nestedRecordMap == null || !this.nestedRecordMap.containsKey(name)) {
            return null;
        }
        if (this.nestedRecordClassMap != null && (clazz = (Class)this.nestedRecordClassMap.get(name)) != null) {
            try {
                return (Record)clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Record(RecordSchema.getInstance((String)this.nestedRecordMap.get(name)));
    }

    public void clear() {
        int i;
        if (this.headerMap != null && this.headerMap.size() != 0) {
            String[] headerNames = this.headerMap.keySet().toArray(new String[this.headerMap.size()]);
            for (i = 0; i < headerNames.length; ++i) {
                Header header = this.getHeader(headerNames[i]);
                if (header == null) continue;
                header.clear();
            }
        }
        if (this.recordListMap != null && this.recordListMap.size() != 0) {
            String[] recListNames = this.recordListMap.keySet().toArray(new String[this.recordListMap.size()]);
            for (i = 0; i < recListNames.length; ++i) {
                RecordList recList = this.getRecordList(recListNames[i]);
                if (recList == null) continue;
                recList.clear();
            }
        }
    }

    public boolean validateHeader() throws PropertyGetException, PropertyValidateException {
        Header header = this.getHeader();
        if (header == null) {
            return false;
        }
        return header.validate();
    }

    public boolean validateHeader(String name) throws PropertyGetException, PropertyValidateException {
        Header header = this.getHeader(name);
        if (header == null) {
            return false;
        }
        return header.validate();
    }

    public boolean validateHeaders() throws PropertyGetException, PropertyValidateException {
        if (this.headerMap == null || this.headerMap.size() == 0) {
            return true;
        }
        for (Header header : this.headerMap.values()) {
            if (header.validate()) continue;
            return false;
        }
        return true;
    }

    public boolean validateRecordList() throws PropertyGetException, PropertyValidateException {
        RecordList recordList = this.getRecordList();
        if (recordList == null) {
            return false;
        }
        return recordList.validate();
    }

    public boolean validateRecordList(String name) throws PropertyGetException, PropertyValidateException {
        RecordList recordList = this.getRecordList(name);
        if (recordList == null) {
            return false;
        }
        return recordList.validate();
    }

    public boolean validateRecordLists() throws PropertyGetException, PropertyValidateException {
        if (this.recordListMap == null || this.recordListMap.size() == 0) {
            return true;
        }
        for (RecordList recordList : this.recordListMap.values()) {
            if (recordList.validate()) continue;
            return false;
        }
        return true;
    }

    public boolean validate() throws PropertyGetException, PropertyValidateException {
        if (!this.validateHeaders()) {
            return false;
        }
        return this.validateRecordLists();
    }

    public Object clone() {
        return this.cloneDataSet();
    }

    public DataSet cloneSchema() {
        return this.cloneDataSet(false);
    }

    public DataSet cloneDataSet() {
        return this.cloneDataSet(true);
    }

    protected DataSet cloneDataSet(boolean hasData) {
        int i;
        DataSet dataSet = null;
        try {
            dataSet = (DataSet)super.clone();
            dataSet.headerMap = null;
            dataSet.recordListMap = null;
            dataSet.nestedRecordListMap = null;
            dataSet.nestedRecordListClassMap = null;
            dataSet.nestedRecordMap = null;
            dataSet.nestedRecordClassMap = null;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        if (this.headerMap != null && this.headerMap.size() != 0) {
            String[] headerNames = this.headerMap.keySet().toArray(new String[this.headerMap.size()]);
            dataSet.headerMap = Collections.synchronizedMap(new LinkedHashMap());
            for (i = 0; i < headerNames.length; ++i) {
                Header header = this.getHeader(headerNames[i]);
                if (header == null) continue;
                dataSet.headerMap.put(headerNames[i], hasData ? header.cloneRecord() : header.cloneSchema());
            }
        }
        if (this.recordListMap != null && this.recordListMap.size() != 0) {
            String[] recListNames = this.recordListMap.keySet().toArray(new String[this.recordListMap.size()]);
            dataSet.recordListMap = Collections.synchronizedMap(new LinkedHashMap());
            for (i = 0; i < recListNames.length; ++i) {
                RecordList recList = this.getRecordList(recListNames[i]);
                if (recList == null) continue;
                dataSet.recordListMap.put(recListNames[i], hasData ? recList.cloneRecordList() : recList.cloneSchema());
            }
        }
        if (this.nestedRecordListMap != null && this.nestedRecordListMap.size() != 0) {
            dataSet.nestedRecordListMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
            dataSet.nestedRecordListMap.putAll(this.nestedRecordListMap);
        }
        if (this.nestedRecordListClassMap != null && this.nestedRecordListClassMap.size() != 0) {
            dataSet.nestedRecordListClassMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
            dataSet.nestedRecordListClassMap.putAll(this.nestedRecordListClassMap);
        }
        if (this.nestedRecordMap != null && this.nestedRecordMap.size() != 0) {
            dataSet.nestedRecordMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
            dataSet.nestedRecordMap.putAll(this.nestedRecordMap);
        }
        if (this.nestedRecordClassMap != null && this.nestedRecordClassMap.size() != 0) {
            dataSet.nestedRecordClassMap = this.isSynchronized ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
            dataSet.nestedRecordClassMap.putAll(this.nestedRecordClassMap);
        }
        return dataSet;
    }

    public String toString() {
        return super.toString() + "{name=" + this.name + '}';
    }
}

