/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans.dataset;

import java.beans.PropertyEditor;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jp.ossc.nimbus.beans.NimbusPropertyEditorManager;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.beans.dataset.PropertyGetException;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySchemaCheckException;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.beans.dataset.PropertySetException;
import jp.ossc.nimbus.beans.dataset.PropertyValidateException;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.io.CSVReader;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.Converter;
import jp.ossc.nimbus.util.converter.CustomConverter;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class DefaultPropertySchema
implements PropertySchema,
Serializable {
    private static final long serialVersionUID = -7076284202113630114L;
    protected static final String CLASS_PROPERTY_PREFIX = "{";
    protected static final String CLASS_PROPERTY_SUFFIX = "}";
    protected static final Map objectManager = Collections.synchronizedMap(new HashMap());
    protected String schema;
    protected String name;
    protected Class type;
    protected transient Converter formatConverter;
    protected ServiceName formatConverterName;
    protected transient Converter parseConverter;
    protected ServiceName parseConverterName;
    protected transient Constrain constrainExpression;
    protected boolean isPrimaryKey;

    public DefaultPropertySchema() {
    }

    public DefaultPropertySchema(String schema) throws PropertySchemaDefineException {
        this.setSchema(schema);
    }

    @Override
    public void setSchema(String schema) throws PropertySchemaDefineException {
        if (schema == null || schema.length() == 0) {
            throw new PropertySchemaDefineException(schema, "The schema is insufficient.");
        }
        this.parseSchemata(schema, DefaultPropertySchema.parseCSV(schema));
        this.schema = schema;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    protected static List parseCSV(String text) {
        return CSVReader.toList(text, null, ',', '\\', '\"', "", null, true, true, true, false);
    }

    protected void parseSchemata(String schema, List schemata) throws PropertySchemaDefineException {
        if (schemata.size() == 0) {
            throw new PropertySchemaDefineException("Name must be specified.");
        }
        int max = schemata.size();
        for (int i = 0; i < max; ++i) {
            this.parseSchema(schema, i, (String)schemata.get(i));
        }
    }

    protected void parseSchema(String schema, int index, String val) throws PropertySchemaDefineException {
        switch (index) {
            case 0: {
                this.parseName(schema, val);
                break;
            }
            case 1: {
                this.parseType(schema, val);
                break;
            }
            case 2: {
                this.parseParseConverter(schema, val);
                break;
            }
            case 3: {
                this.parseFormatConverter(schema, val);
                break;
            }
            case 4: {
                this.parseConstrain(schema, val);
                break;
            }
            case 5: {
                this.parsePrimaryKey(schema, val);
            }
        }
    }

    protected void parseName(String schema, String val) throws PropertySchemaDefineException {
        this.name = val;
    }

    protected void parseType(String schema, String val) throws PropertySchemaDefineException {
        if (val != null && val.length() != 0) {
            try {
                this.type = Utility.convertStringToClass(val, false);
            }
            catch (ClassNotFoundException e) {
                throw new PropertySchemaDefineException(schema, "The type is illegal.", e);
            }
        }
    }

    protected void parseParseConverter(String schema, String val) throws PropertySchemaDefineException {
        Object conv = this.parseConverter(schema, val);
        if (conv != null) {
            if (conv instanceof ServiceName) {
                this.parseConverterName = (ServiceName)conv;
            } else {
                this.parseConverter = (Converter)conv;
            }
        }
    }

    protected void parseFormatConverter(String schema, String val) throws PropertySchemaDefineException {
        Object conv = this.parseConverter(schema, val);
        if (conv != null) {
            if (conv instanceof ServiceName) {
                this.formatConverterName = (ServiceName)conv;
            } else {
                this.formatConverter = (Converter)conv;
            }
        }
    }

    protected Object parseObject(String schema, String val) throws ClassNotFoundException, PropertySchemaDefineException {
        Object object = objectManager.get(val);
        if (object != null) {
            return object;
        }
        String className = val;
        List properties = null;
        int propStartIndex = className.indexOf(CLASS_PROPERTY_PREFIX);
        if (propStartIndex != -1 && className.endsWith(CLASS_PROPERTY_SUFFIX)) {
            properties = CSVReader.toList(className.substring(propStartIndex + 1, className.length() - 1), null, ';', '\\', '\"', null, null, true, false, true, false);
            className = className.substring(0, propStartIndex);
        }
        Class clazz = Utility.convertStringToClass(className, true);
        try {
            object = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new PropertySchemaDefineException(schema, "Illegal object format : " + val, e);
        }
        catch (IllegalAccessException e) {
            throw new PropertySchemaDefineException(schema, "Illegal object format : " + val, e);
        }
        if (properties != null && properties.size() != 0) {
            int imax = properties.size();
            for (int i = 0; i < imax; ++i) {
                String property = (String)properties.get(i);
                if (property == null || property.length() < 2) {
                    throw new PropertySchemaDefineException(schema, "Illegal object format : " + val);
                }
                int index = property.indexOf(61);
                if (index == -1 || index == 0) {
                    throw new PropertySchemaDefineException(schema, "Illegal object format : " + val);
                }
                String propName = property.substring(0, index);
                Class<String> propType = null;
                int index2 = propName.indexOf(58);
                if (index2 != -1 && index2 != 0 && index2 != propName.length() - 1) {
                    String propTypeStr = propName.substring(index2 + 1);
                    try {
                        propType = Utility.convertStringToClass(propTypeStr, false);
                        propName = propName.substring(0, index2);
                    }
                    catch (ClassNotFoundException e) {
                        throw new PropertySchemaDefineException(schema, "The type of property is illegal. property=" + propName + ",type=" + propTypeStr, e);
                    }
                }
                String propValStr = property.substring(index + 1);
                Property prop = null;
                try {
                    prop = PropertyFactory.createProperty(propName);
                }
                catch (IllegalArgumentException e) {
                    throw new PropertySchemaDefineException(schema, "Illegal object format : " + val, e);
                }
                try {
                    if (propType == null) {
                        propType = prop.getPropertyType(object);
                    }
                    if (propType == null) {
                        propType = String.class;
                    }
                    PropertyEditor editor = NimbusPropertyEditorManager.findEditor(propType);
                    Object propVal = propValStr;
                    if (editor == null) {
                        index2 = propValStr.lastIndexOf(".");
                        if (index2 > 0 && index2 != propValStr.length() - 1) {
                            className = propValStr.substring(0, index2);
                            String fieldName = propValStr.substring(index2 + 1);
                            try {
                                Class clazz2 = Utility.convertStringToClass(className, false);
                                Field field = clazz2.getField(fieldName);
                                if (propType.isAssignableFrom(field.getType())) {
                                    propVal = field.get(null);
                                }
                            }
                            catch (ClassNotFoundException e) {
                            }
                            catch (NoSuchFieldException e) {
                            }
                            catch (SecurityException e) {
                            }
                            catch (IllegalArgumentException e) {
                            }
                            catch (IllegalAccessException e) {}
                        }
                    } else if (editor != null) {
                        try {
                            editor.setAsText(propValStr);
                        }
                        catch (RuntimeException e) {
                            try {
                                editor.setAsText(clazz.getName() + '.' + propValStr);
                            }
                            catch (RuntimeException e2) {
                                throw e;
                            }
                        }
                        propVal = editor.getValue();
                    }
                    prop.setProperty(object, propVal);
                    continue;
                }
                catch (NoSuchPropertyException e) {
                    throw new PropertySchemaDefineException(schema, "Illegal object format : " + val, e);
                }
                catch (InvocationTargetException e) {
                    throw new PropertySchemaDefineException(schema, "Illegal object format : " + val, e);
                }
                catch (RuntimeException e) {
                    throw new PropertySchemaDefineException(schema, "Illegal object format : " + val, e);
                }
            }
        }
        objectManager.put(val, object);
        return object;
    }

    protected Object parseConverter(String schema, String val) throws PropertySchemaDefineException {
        if (val != null && val.length() != 0) {
            if (val.indexOf(43) == -1) {
                try {
                    Object obj = this.parseObject(schema, val);
                    if (!(obj instanceof Converter)) {
                        throw new PropertySchemaDefineException(schema, "Converter dose not implement Converter.");
                    }
                    return obj;
                }
                catch (ClassNotFoundException e) {
                    ServiceNameEditor serviceNameEditor = new ServiceNameEditor();
                    try {
                        serviceNameEditor.setAsText(val);
                    }
                    catch (IllegalArgumentException e2) {
                        throw new PropertySchemaDefineException(schema, "Converter is illegal.", e2);
                    }
                    return (ServiceName)serviceNameEditor.getValue();
                }
            }
            List converterStrList = CSVReader.toList(val, null, '+', '\\', '\"', "", null, true, true, true, false);
            Converter[] converters = new Converter[converterStrList.size()];
            for (int i = 0; i < converterStrList.size(); ++i) {
                try {
                    Object obj = this.parseObject(schema, (String)converterStrList.get(i));
                    if (!(obj instanceof Converter)) {
                        throw new PropertySchemaDefineException(schema, "Converter dose not implement Converter.");
                    }
                    converters[i] = (Converter)obj;
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new PropertySchemaDefineException(schema, "Converter is illegal.", e);
                }
            }
            return new CustomConverter(converters);
        }
        return null;
    }

    protected void parseConstrain(String schema, String val) throws PropertySchemaDefineException {
        if (val != null && val.length() != 0) {
            try {
                this.constrainExpression = new Constrain(val);
            }
            catch (Exception e) {
                throw new PropertySchemaDefineException(this.toString(), "Illegal constrain : " + val, e);
            }
        }
    }

    protected void parsePrimaryKey(String schema, String val) throws PropertySchemaDefineException {
        this.isPrimaryKey = val != null && "1".equals(val);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public Converter getParseConverter() {
        if (this.parseConverter != null) {
            return this.parseConverter;
        }
        if (this.parseConverterName != null) {
            return (Converter)ServiceManagerFactory.getServiceObject(this.parseConverterName);
        }
        return null;
    }

    public Converter getFormatConverter() {
        if (this.formatConverter != null) {
            return this.formatConverter;
        }
        if (this.formatConverterName != null) {
            return (Converter)ServiceManagerFactory.getServiceObject(this.formatConverterName);
        }
        return null;
    }

    public String getConstrain() {
        return this.constrainExpression == null ? null : this.constrainExpression.constrain;
    }

    @Override
    public Object set(Object val) throws PropertySetException {
        return this.checkSchema(val);
    }

    @Override
    public Object get(Object val) throws PropertyGetException {
        return val;
    }

    @Override
    public Object format(Object val) throws PropertyGetException {
        Object result = val;
        Converter converter = null;
        try {
            converter = this.getFormatConverter();
        }
        catch (ServiceNotFoundException e) {
            throw new PropertyGetException((PropertySchema)this, (Throwable)e);
        }
        if (converter == null) {
            PropertyEditor editor;
            if (result == null) {
                return result;
            }
            Class type = this.getType();
            if (type != null && (editor = NimbusPropertyEditorManager.findEditor(type)) != null) {
                try {
                    editor.setValue(result);
                    result = editor.getAsText();
                }
                catch (RuntimeException e) {
                    throw new PropertySetException((PropertySchema)this, (Throwable)e);
                }
            }
        } else {
            try {
                result = converter.convert(result);
            }
            catch (ConvertException e) {
                throw new PropertyGetException((PropertySchema)this, (Throwable)e);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object parse(Object val) throws PropertySetException {
        Object result = val;
        Converter converter = null;
        try {
            converter = this.getParseConverter();
        }
        catch (ServiceNotFoundException e) {
            throw new PropertySetException((PropertySchema)this, (Throwable)e);
        }
        if (converter == null) {
            if (result == null) {
                return result;
            }
            Class type = this.getType();
            if (type == null) {
                return result;
            }
            Class<?> inType = result.getClass();
            if (type.isAssignableFrom(inType)) {
                return result;
            }
            if (result instanceof String) {
                return this.parseByPropertyEditor((String)result, type);
            }
            if (!type.isArray()) throw new PropertySetException((PropertySchema)this, "Counld not parse.");
            if (!inType.equals(String[].class)) throw new PropertySetException((PropertySchema)this, "Counld not parse.");
            String[] array = (String[])result;
            Class<?> componentType = type.getComponentType();
            result = Array.newInstance(componentType, array.length);
            int i = 0;
            while (i < array.length) {
                Array.set(result, i, this.parseByPropertyEditor(array[i], componentType));
                ++i;
            }
            return result;
        }
        try {
            return converter.convert(result);
        }
        catch (ConvertException e) {
            throw new PropertySetException((PropertySchema)this, (Throwable)e);
        }
    }

    private Object parseByPropertyEditor(String str, Class editType) throws PropertySetException {
        PropertyEditor editor;
        if (str.length() == 0 && (Number.class.isAssignableFrom(editType) || Boolean.class.equals((Object)editType))) {
            return null;
        }
        if (editType.isPrimitive() && str.length() == 0) {
            if (editType.equals(Boolean.TYPE)) {
                return Boolean.FALSE;
            }
            if (editType.equals(Byte.TYPE)) {
                return new Byte(0);
            }
            if (editType.equals(Short.TYPE)) {
                return new Short(0);
            }
            if (editType.equals(Integer.TYPE)) {
                return new Integer(0);
            }
            if (editType.equals(Long.TYPE)) {
                return new Long(0L);
            }
            if (editType.equals(Float.TYPE)) {
                return new Float(0.0f);
            }
            if (editType.equals(Double.TYPE)) {
                return new Double(0.0);
            }
        }
        if ((editor = NimbusPropertyEditorManager.findEditor(editType)) != null) {
            try {
                editor.setAsText(str);
                return editor.getValue();
            }
            catch (RuntimeException e) {
                throw new PropertySetException((PropertySchema)this, (Throwable)e);
            }
        }
        return str;
    }

    protected Object checkSchema(Object val) throws PropertySchemaCheckException {
        val = this.checkType(val);
        return val;
    }

    protected Object checkType(Object val) throws PropertySchemaCheckException {
        if (this.type == null || val == null) {
            return val;
        }
        Class<?> clazz = val.getClass();
        if (!this.isAssignableFrom(this.type, clazz)) {
            try {
                val = this.parse(val);
                clazz = val.getClass();
            }
            catch (PropertySetException e) {
                throw new PropertySchemaCheckException((PropertySchema)this, "The type is unmatch. type=" + clazz.getName());
            }
        }
        if (Number.class.isAssignableFrom(clazz) && (!this.type.isPrimitive() && !this.type.equals(clazz) || this.type.isPrimitive() && !this.type.equals(this.getPrimitiveClass(clazz)))) {
            val = this.castPrimitiveWrapper(this.type, (Number)val);
        }
        return val;
    }

    private Class getPrimitiveClass(Class type) {
        if (type.equals(Byte.class)) {
            return Byte.TYPE;
        }
        if (type.equals(Short.class)) {
            return Short.TYPE;
        }
        if (type.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (type.equals(Long.class)) {
            return Long.TYPE;
        }
        if (type.equals(Float.class)) {
            return Float.TYPE;
        }
        if (type.equals(Double.class)) {
            return Double.TYPE;
        }
        return null;
    }

    private boolean isAssignableFrom(Class thisClass, Class thatClass) {
        if (this.isNumber(thisClass) && this.isNumber(thatClass)) {
            if (Byte.TYPE.equals(thisClass) || Byte.class.equals((Object)thisClass)) {
                return Byte.TYPE.equals(thatClass) || Byte.class.equals((Object)thatClass);
            }
            if (Short.TYPE.equals(thisClass) || Short.class.equals((Object)thisClass)) {
                return Short.TYPE.equals(thatClass) || Short.class.equals((Object)thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals((Object)thatClass);
            }
            if (Integer.TYPE.equals(thisClass) || Integer.class.equals((Object)thisClass)) {
                return Integer.TYPE.equals(thatClass) || Integer.class.equals((Object)thatClass) || Short.TYPE.equals(thatClass) || Short.class.equals((Object)thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals((Object)thatClass);
            }
            if (Long.TYPE.equals(thisClass) || Long.class.equals((Object)thisClass)) {
                return Long.TYPE.equals(thatClass) || Long.class.equals((Object)thatClass) || Integer.TYPE.equals(thatClass) || Integer.class.equals((Object)thatClass) || Short.TYPE.equals(thatClass) || Short.class.equals((Object)thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals((Object)thatClass);
            }
            if (BigInteger.class.equals((Object)thisClass)) {
                return BigInteger.class.equals((Object)thatClass) || Long.TYPE.equals(thatClass) || Long.class.equals((Object)thatClass) || Integer.TYPE.equals(thatClass) || Integer.class.equals((Object)thatClass) || Short.TYPE.equals(thatClass) || Short.class.equals((Object)thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals((Object)thatClass);
            }
            if (Float.TYPE.equals(thisClass) || Float.class.equals((Object)thisClass)) {
                return Float.TYPE.equals(thatClass) || Float.class.equals((Object)thatClass) || Long.TYPE.equals(thatClass) || Long.class.equals((Object)thatClass) || Integer.TYPE.equals(thatClass) || Integer.class.equals((Object)thatClass) || Short.TYPE.equals(thatClass) || Short.class.equals((Object)thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals((Object)thatClass);
            }
            if (Double.TYPE.equals(thisClass) || Double.class.equals((Object)thisClass)) {
                return Double.TYPE.equals(thatClass) || Double.class.equals((Object)thatClass) || Float.TYPE.equals(thatClass) || Float.class.equals((Object)thatClass) || Long.TYPE.equals(thatClass) || Long.class.equals((Object)thatClass) || Integer.TYPE.equals(thatClass) || Integer.class.equals((Object)thatClass) || Short.TYPE.equals(thatClass) || Short.class.equals((Object)thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals((Object)thatClass);
            }
            if (BigDecimal.class.equals((Object)thisClass)) {
                return BigDecimal.class.equals((Object)thatClass) || Double.TYPE.equals(thatClass) || Double.class.equals((Object)thatClass) || Float.TYPE.equals(thatClass) || Float.class.equals((Object)thatClass) || BigInteger.class.equals((Object)thatClass) || Long.TYPE.equals(thatClass) || Long.class.equals((Object)thatClass) || Integer.TYPE.equals(thatClass) || Integer.class.equals((Object)thatClass) || Short.TYPE.equals(thatClass) || Short.class.equals((Object)thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals((Object)thatClass);
            }
            return true;
        }
        if (thisClass.equals(Boolean.class) && thatClass.equals(Boolean.TYPE) || thisClass.equals(Boolean.TYPE) && thatClass.equals(Boolean.class)) {
            return true;
        }
        if (thisClass.equals(Character.class) && thatClass.equals(Character.TYPE) || thisClass.equals(Character.TYPE) && thatClass.equals(Character.class)) {
            return true;
        }
        return thisClass.isAssignableFrom(thatClass);
    }

    private boolean isNumber(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isPrimitive()) {
            return Byte.TYPE.equals(clazz) || Short.TYPE.equals(clazz) || Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz) || Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz);
        }
        return Number.class.isAssignableFrom(clazz);
    }

    private Number castPrimitiveWrapper(Class clazz, Number val) {
        if (Byte.class.equals((Object)clazz) || Byte.TYPE.equals(clazz)) {
            return new Byte(val.byteValue());
        }
        if (Short.class.equals((Object)clazz) || Short.TYPE.equals(clazz)) {
            return new Short(val.shortValue());
        }
        if (Integer.class.equals((Object)clazz) || Integer.TYPE.equals(clazz)) {
            return new Integer(val.intValue());
        }
        if (Long.class.equals((Object)clazz) || Long.TYPE.equals(clazz)) {
            return new Long(val.longValue());
        }
        if (BigInteger.class.equals((Object)clazz)) {
            return BigInteger.valueOf(val.longValue());
        }
        if (Float.class.equals((Object)clazz) || Float.TYPE.equals(clazz)) {
            return new Float(val.floatValue());
        }
        if (Double.class.equals((Object)clazz) || Double.TYPE.equals(clazz)) {
            return new Double(val.doubleValue());
        }
        if (BigDecimal.class.equals((Object)clazz)) {
            if (val instanceof BigInteger) {
                return new BigDecimal((BigInteger)val);
            }
            return new BigDecimal(val.doubleValue());
        }
        return val;
    }

    @Override
    public boolean validate(Object val) throws PropertyValidateException {
        if (this.constrainExpression == null) {
            return true;
        }
        try {
            return this.constrainExpression.evaluate(val);
        }
        catch (Exception e) {
            throw new PropertyValidateException(this, "The constrain is illegal.constrain=" + this.constrainExpression.constrain + ", value=" + val, e);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append('{');
        buf.append("name=").append(this.name);
        buf.append(",type=").append(this.type == null ? null : this.type.getName());
        if (this.parseConverter == null && this.parseConverterName == null) {
            buf.append(",parseConverter=null");
        } else if (this.parseConverter != null) {
            buf.append(",parseConverter=").append(this.parseConverter);
        } else {
            buf.append(",parseConverter=").append(this.parseConverterName);
        }
        if (this.formatConverter == null && this.formatConverterName == null) {
            buf.append(",formatConverter=null");
        } else if (this.formatConverter != null) {
            buf.append(",formatConverter=").append(this.formatConverter);
        } else {
            buf.append(",formatConverter=").append(this.formatConverterName);
        }
        buf.append(",constrain=").append(this.constrainExpression == null ? null : this.constrainExpression.constrain);
        if (this.isPrimaryKey) {
            buf.append(",isPrimaryKey=").append(this.isPrimaryKey);
        }
        buf.append('}');
        return buf.toString();
    }

    protected static class Constrain {
        protected static final String CONSTRAIN_TARGET_KEY = "value";
        protected static final String CONSTRAIN_DELIMITER = "@";
        public final String constrain;
        protected final List keyList = new ArrayList();
        protected final List properties = new ArrayList();
        protected Expression expression;

        public Constrain(String constrain) throws Exception {
            this.constrain = constrain;
            StringTokenizer token = new StringTokenizer(constrain, CONSTRAIN_DELIMITER, true);
            boolean keyFlg = false;
            String beforeToken = null;
            StringBuffer buf = new StringBuffer();
            while (token.hasMoreTokens()) {
                String str = token.nextToken();
                if (!keyFlg) {
                    if (CONSTRAIN_DELIMITER.equals(str)) {
                        keyFlg = true;
                    } else {
                        buf.append(str);
                    }
                } else if (CONSTRAIN_DELIMITER.equals(str)) {
                    keyFlg = false;
                    if (beforeToken != null) {
                        String tmpKey = "_constrainKey" + this.keyList.size();
                        this.keyList.add(tmpKey);
                        buf.append(tmpKey);
                        if (!beforeToken.startsWith(CONSTRAIN_TARGET_KEY)) {
                            throw new IllegalArgumentException(constrain);
                        }
                        if (CONSTRAIN_TARGET_KEY.equals(beforeToken)) {
                            this.properties.add(null);
                        } else {
                            beforeToken = beforeToken.charAt(CONSTRAIN_TARGET_KEY.length()) == '.' ? beforeToken.substring(CONSTRAIN_TARGET_KEY.length() + 1) : beforeToken.substring(CONSTRAIN_TARGET_KEY.length());
                            Property prop = PropertyFactory.createProperty(beforeToken);
                            prop.setIgnoreNullProperty(true);
                            this.properties.add(prop);
                        }
                    } else {
                        buf.append(str);
                    }
                }
                beforeToken = str;
            }
            this.expression = ExpressionFactory.createExpression((String)buf.toString());
            this.evaluate("", true);
        }

        public boolean evaluate(Object object) throws Exception {
            return this.evaluate(object, false);
        }

        protected boolean evaluate(Object object, boolean isTest) throws Exception {
            JexlContext jexlContext = JexlHelper.createContext();
            jexlContext.getVars().put(CONSTRAIN_TARGET_KEY, object);
            int size = this.keyList.size();
            for (int i = 0; i < size; ++i) {
                String keyString = (String)this.keyList.get(i);
                Property property = (Property)this.properties.get(i);
                Object val = null;
                if (property == null) {
                    val = object;
                } else {
                    try {
                        val = property.getProperty(object);
                    }
                    catch (NoSuchPropertyException e) {
                    }
                    catch (InvocationTargetException e) {
                        // empty catch block
                    }
                }
                jexlContext.getVars().put(keyString, val);
            }
            Object exp = this.expression.evaluate(jexlContext);
            if (exp instanceof Boolean) {
                return (Boolean)exp;
            }
            if (exp == null && isTest) {
                return true;
            }
            throw new IllegalArgumentException(this.expression.getExpression());
        }
    }
}

