/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans.dataset;

import java.io.Serializable;
import java.util.List;
import jp.ossc.nimbus.beans.dataset.DefaultPropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertyGetException;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySchemaCheckException;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.beans.dataset.PropertySetException;
import jp.ossc.nimbus.beans.dataset.PropertyValidateException;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.core.Utility;

public class RecordPropertySchema
implements PropertySchema,
Serializable {
    private static final long serialVersionUID = -6689975898690899203L;
    protected String schema;
    protected String name;
    protected String recordName;
    protected Class type = Record.class;

    public RecordPropertySchema() {
    }

    public RecordPropertySchema(String schema) throws PropertySchemaDefineException {
        this.setSchema(schema);
    }

    @Override
    public void setSchema(String schema) throws PropertySchemaDefineException {
        List schemata = DefaultPropertySchema.parseCSV(schema);
        if (schemata.size() < 2) {
            throw new PropertySchemaDefineException("Name and Schema must be specified.");
        }
        this.schema = schema;
        this.name = (String)schemata.get(0);
        this.recordName = (String)schemata.get(1);
        if (schemata.size() > 2) {
            this.parseType(schema, (String)schemata.get(2));
        }
    }

    protected void parseType(String schema, String val) throws PropertySchemaDefineException {
        if (val != null && val.length() != 0) {
            try {
                this.type = Utility.convertStringToClass(val, false);
            }
            catch (ClassNotFoundException e) {
                throw new PropertySchemaDefineException(schema, "The type is illegal.", e);
            }
        }
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public boolean isPrimaryKey() {
        return false;
    }

    @Override
    public Object set(Object val) throws PropertySetException {
        if (val == null) {
            return null;
        }
        if (!(val instanceof Record)) {
            throw new PropertySchemaCheckException((PropertySchema)this, "The type is unmatch. type=" + val.getClass().getName());
        }
        return val;
    }

    @Override
    public Object get(Object val) throws PropertyGetException {
        return val;
    }

    @Override
    public Object format(Object val) throws PropertyGetException {
        return val;
    }

    @Override
    public Object parse(Object val) throws PropertySetException {
        return val;
    }

    @Override
    public boolean validate(Object val) throws PropertyValidateException {
        if (val != null && val instanceof Record) {
            return ((Record)val).validate();
        }
        return true;
    }

    public String getRecordName() {
        return this.recordName;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append('{');
        buf.append("name=").append(this.name);
        buf.append(",recordName=").append(this.recordName);
        buf.append(",type=").append(this.type);
        buf.append('}');
        return buf.toString();
    }
}

