/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jp.ossc.nimbus.core.ArgumentMetaData;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.InvokeMetaData;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.ObjectMetaData;
import jp.ossc.nimbus.core.StaticFieldRefMetaData;
import jp.ossc.nimbus.core.StaticInvokeMetaData;
import org.w3c.dom.Element;

public class ConstructorMetaData
extends MetaData
implements Serializable {
    private static final long serialVersionUID = 1385893693509473372L;
    public static final String CONSTRUCTOR_TAG_NAME = "constructor";
    protected InvokeMetaData invoke;
    protected StaticInvokeMetaData staticInvoke;
    protected StaticFieldRefMetaData staticFieldRef;
    protected final List arguments = new ArrayList();

    public ConstructorMetaData(ObjectMetaData parent) {
        super(parent);
    }

    public InvokeMetaData getInvoke() {
        return this.invoke;
    }

    public void setInvoke(InvokeMetaData data) {
        this.invoke = data;
    }

    public StaticInvokeMetaData getStaticInvoke() {
        return this.staticInvoke;
    }

    public void setStaticInvoke(StaticInvokeMetaData data) {
        this.staticInvoke = data;
    }

    public StaticFieldRefMetaData getStaticFieldRef() {
        return this.staticFieldRef;
    }

    public void setStaticFieldRef(StaticFieldRefMetaData data) {
        this.staticFieldRef = data;
    }

    public Collection getArguments() {
        return this.arguments;
    }

    public void addArgument(ArgumentMetaData arg) {
        this.arguments.add(arg);
    }

    public void removeArgument(ArgumentMetaData arg) {
        this.arguments.remove(arg);
    }

    public void clearArguments() {
        this.arguments.clear();
    }

    @Override
    public void importXML(Element element) throws DeploymentException {
        super.importXML(element);
        if (!element.getTagName().equals(CONSTRUCTOR_TAG_NAME)) {
            throw new DeploymentException("Tag must be constructor : " + element.getTagName());
        }
        Element invokeElement = ConstructorMetaData.getOptionalChild(element, "invoke");
        if (invokeElement != null) {
            InvokeMetaData invokeData = new InvokeMetaData(this);
            invokeData.importXML(invokeElement);
            if (invokeData.getTarget() == null) {
                throw new DeploymentException("Target is null." + invokeData);
            }
            this.invoke = invokeData;
            return;
        }
        Element staticInvokeElement = ConstructorMetaData.getOptionalChild(element, "static-invoke");
        if (staticInvokeElement != null) {
            StaticInvokeMetaData staticInvokeData = new StaticInvokeMetaData(this);
            staticInvokeData.importXML(staticInvokeElement);
            this.staticInvoke = staticInvokeData;
            return;
        }
        Element staticFieldRefElement = ConstructorMetaData.getOptionalChild(element, "static-field-ref");
        if (staticFieldRefElement != null) {
            StaticFieldRefMetaData staticFieldRefData = new StaticFieldRefMetaData(this);
            staticFieldRefData.importXML(staticFieldRefElement);
            this.staticFieldRef = staticFieldRefData;
            return;
        }
        Iterator argElements = ConstructorMetaData.getChildrenByTagName(element, "argument");
        while (argElements.hasNext()) {
            ArgumentMetaData argData = new ArgumentMetaData(this, (ObjectMetaData)this.getParent());
            argData.importXML((Element)argElements.next());
            this.addArgument(argData);
        }
    }

    @Override
    public StringBuffer toXML(StringBuffer buf) {
        this.appendComment(buf);
        buf.append('<').append(CONSTRUCTOR_TAG_NAME).append('>');
        if (this.arguments.size() != 0) {
            buf.append(LINE_SEPARATOR);
            int imax = this.arguments.size();
            for (int i = 0; i < imax; ++i) {
                buf.append(this.addIndent(((MetaData)this.arguments.get(i)).toXML(new StringBuffer())));
                buf.append(LINE_SEPARATOR);
            }
        } else {
            MetaData data = this.invoke;
            if (data == null) {
                data = this.staticInvoke;
            }
            if (data == null) {
                data = this.staticFieldRef;
            }
            if (data != null) {
                buf.append(LINE_SEPARATOR);
                buf.append(this.addIndent(data.toXML(new StringBuffer())));
                buf.append(LINE_SEPARATOR);
            }
        }
        buf.append("</").append(CONSTRUCTOR_TAG_NAME).append('>');
        return buf;
    }
}

