/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jp.ossc.nimbus.core.FactoryServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceBase;

public abstract class FactoryServiceBase
extends ServiceBase
implements FactoryServiceBaseMBean {
    private static final long serialVersionUID = -7723361215992951033L;
    protected volatile boolean isManaged;
    protected volatile boolean isThreadLocal;
    protected Set managedInstances = Collections.synchronizedSet(new HashSet());
    protected ThreadLocal threadLocal = new ThreadLocal();
    protected boolean isCreateTemplateOnStart = true;

    @Override
    public void setManagement(boolean isManaged) {
        this.isManaged = isManaged;
    }

    @Override
    public boolean isManagement() {
        return this.isManaged;
    }

    @Override
    public void setThreadLocal(boolean isThreadLocal) {
        this.isThreadLocal = isThreadLocal;
    }

    @Override
    public boolean isThreadLocal() {
        return this.isThreadLocal;
    }

    @Override
    public void release(Object service) {
        if (this.managedInstances.size() != 0) {
            this.managedInstances.remove(service);
        }
        this.threadLocal.set(null);
    }

    @Override
    public void release() {
        Object[] instances = this.managedInstances.toArray();
        for (int i = 0; i < instances.length; ++i) {
            this.release(instances[i]);
        }
        this.threadLocal = new ThreadLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object newInstance() {
        Object obj = null;
        if (this.isManaged) {
            Set set = this.managedInstances;
            synchronized (set) {
                if (this.isThreadLocal) {
                    obj = this.threadLocal.get();
                }
                if (obj == null) {
                    try {
                        obj = this.createInstance();
                    }
                    catch (Exception e) {
                        return null;
                    }
                    if (this.isThreadLocal) {
                        this.threadLocal.set(obj);
                    }
                }
                this.managedInstances.add(obj);
            }
        }
        if (this.isThreadLocal) {
            obj = this.threadLocal.get();
        }
        if (obj == null) {
            try {
                obj = this.createInstance();
            }
            catch (Exception e) {
                return null;
            }
            if (this.isThreadLocal) {
                this.threadLocal.set(obj);
            }
        }
        return obj;
    }

    @Override
    public void setCreateTemplateOnStart(boolean isCreate) {
        this.isCreateTemplateOnStart = isCreate;
    }

    @Override
    public boolean isCreateTemplateOnStart() {
        return this.isCreateTemplateOnStart;
    }

    protected Set getManagedInstanceSet() {
        return this.managedInstances;
    }

    protected abstract Object createInstance() throws Exception;

    protected Object createTemplate() throws Exception {
        return this.createInstance();
    }

    @Override
    protected void postStartService() throws Exception {
        super.postStartService();
        if (this.isCreateTemplateOnStart) {
            Object obj = this.createTemplate();
            this.release(obj);
        }
    }

    @Override
    protected void postDestroyService() throws Exception {
        super.postDestroyService();
        this.managedInstances.clear();
    }
}

