/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import org.w3c.dom.Element;

public class PropertyEditorMetaData
extends MetaData
implements Serializable {
    private static final long serialVersionUID = -3886753647250989241L;
    public static final String PROPERTY_EDITOR_TAG_NAME = "property-editor";
    protected static final String TYPE_ATTRIBUTE_NAME = "type";
    protected String type;
    protected String editor;

    public PropertyEditorMetaData(MetaData parent) {
        super(parent);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getEditor() {
        return this.editor;
    }

    public void setEditor(String editor) {
        this.editor = editor;
    }

    @Override
    public void importXML(Element element) throws DeploymentException {
        super.importXML(element);
        if (!element.getTagName().equals(PROPERTY_EDITOR_TAG_NAME)) {
            throw new DeploymentException("Tag must be property-editor : " + element.getTagName());
        }
        this.type = PropertyEditorMetaData.getUniqueAttribute(element, TYPE_ATTRIBUTE_NAME);
        this.editor = PropertyEditorMetaData.getElementContent(element);
        if (this.editor == null) {
            throw new DeploymentException("Contents of property-editor element is null.");
        }
    }

    @Override
    public StringBuffer toXML(StringBuffer buf) {
        this.appendComment(buf);
        buf.append('<').append(PROPERTY_EDITOR_TAG_NAME).append(" type=").append(this.type).append(">");
        if (this.editor != null) {
            buf.append(this.editor);
        }
        buf.append("</").append(PROPERTY_EDITOR_TAG_NAME).append('>');
        return buf;
    }
}

