/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.Properties;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.ExceptionWrapInterceptorServiceMBean;
import jp.ossc.nimbus.service.message.MessageRecordFactory;
import jp.ossc.nimbus.util.ClassMappingTree;

public class ExceptionWrapInterceptorService
extends ServiceBase
implements Interceptor,
ExceptionWrapInterceptorServiceMBean {
    private static final long serialVersionUID = 8729196964110200620L;
    private static final Class[] MSG_PARAM_TYPE = new Class[]{String.class};
    private static final Class[] CAUSE_PARAM_TYPE = new Class[]{Throwable.class};
    private static final Class[] MSG_CAUSE_PARAM_TYPE = new Class[]{String.class, Throwable.class};
    private Properties wrapExceptionMapping;
    private ClassMappingTree wrapExceptionMappingTree;
    private String message;
    private ServiceName messageRecordFactoryServiceName;
    private MessageRecordFactory messageRecordFactory;
    private String messageKey;
    private String[] messageArgs;
    private Locale messageLocale;

    @Override
    public void setWrapExceptionMapping(Properties mapping) {
        this.wrapExceptionMapping = mapping;
    }

    @Override
    public Properties getWrapExceptionMapping() {
        return this.wrapExceptionMapping;
    }

    @Override
    public void setMessage(String msg) {
        this.message = msg;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessageRecordFactoryServiceName(ServiceName name) {
        this.messageRecordFactoryServiceName = name;
    }

    @Override
    public ServiceName getMessageRecordFactoryServiceName() {
        return this.messageRecordFactoryServiceName;
    }

    @Override
    public void setMessageKey(String key) {
        this.messageKey = key;
    }

    @Override
    public String getMessageKey() {
        return this.messageKey;
    }

    @Override
    public void setMessageArgs(String[] args) {
        this.messageArgs = args;
    }

    @Override
    public String[] getMessageArgs() {
        return this.messageArgs;
    }

    @Override
    public void setMessageLocale(Locale locale) {
        this.messageLocale = locale;
    }

    @Override
    public Locale getMessageLocale() {
        return this.messageLocale;
    }

    public void setMessageRecordFactoryService(MessageRecordFactory messageRecordFactory) {
        this.messageRecordFactory = messageRecordFactory;
    }

    @Override
    public void startService() throws Exception {
        if (this.wrapExceptionMapping != null) {
            if (this.wrapExceptionMappingTree == null) {
                this.wrapExceptionMappingTree = new ClassMappingTree();
            }
            NimbusClassLoader loader = NimbusClassLoader.getInstance();
            for (String string : this.wrapExceptionMapping.keySet()) {
                String val = this.wrapExceptionMapping.getProperty(string);
                this.wrapExceptionMappingTree.add(Class.forName(string, true, loader), Class.forName(val, true, loader));
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.wrapExceptionMappingTree != null) {
            this.wrapExceptionMappingTree.clear();
        }
    }

    private Throwable createThrowable(Throwable th) {
        if (this.wrapExceptionMappingTree == null) {
            return th;
        }
        Class wrapExceptionClass = (Class)this.wrapExceptionMappingTree.getValue(th.getClass());
        if (wrapExceptionClass == null) {
            return th;
        }
        String msg = this.createMessage();
        if (msg == null) {
            Constructor c = null;
            try {
                c = wrapExceptionClass.getConstructor(CAUSE_PARAM_TYPE);
                return (Throwable)c.newInstance(th);
            }
            catch (NoSuchMethodException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            try {
                c = wrapExceptionClass.getConstructor(MSG_PARAM_TYPE);
                return (Throwable)c.newInstance(th.getMessage());
            }
            catch (NoSuchMethodException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {}
        } else {
            Constructor c = null;
            try {
                c = wrapExceptionClass.getConstructor(MSG_CAUSE_PARAM_TYPE);
                return (Throwable)c.newInstance(msg, th);
            }
            catch (NoSuchMethodException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            try {
                c = wrapExceptionClass.getConstructor(MSG_PARAM_TYPE);
                return (Throwable)c.newInstance(msg);
            }
            catch (NoSuchMethodException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        try {
            return (Throwable)wrapExceptionClass.newInstance();
        }
        catch (IllegalAccessException e) {
        }
        catch (InstantiationException e) {
            // empty catch block
        }
        return th;
    }

    private String createMessage() {
        if (this.message == null && this.messageKey != null) {
            MessageRecordFactory factory;
            if (this.messageRecordFactoryServiceName != null) {
                this.messageRecordFactory = (MessageRecordFactory)ServiceManagerFactory.getServiceObject(this.messageRecordFactoryServiceName);
            }
            if ((factory = this.messageRecordFactory) == null) {
                factory = this.getMessageRecordFactory();
            }
            if (factory != null) {
                if (this.messageArgs == null || this.messageArgs.length == 0) {
                    if (this.messageLocale == null) {
                        return factory.findMessage(this.messageKey);
                    }
                    return factory.findMessage(this.messageLocale, this.messageKey);
                }
                if (this.messageLocale == null) {
                    return factory.findEmbedMessage(this.messageKey, this.messageArgs);
                }
                return factory.findEmbedMessage(this.messageLocale, this.messageKey, this.messageArgs);
            }
        }
        return this.message;
    }

    @Override
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            try {
                return chain.invokeNext(context);
            }
            catch (Throwable th) {
                throw this.createThrowable(th);
            }
        }
        return chain.invokeNext(context);
    }
}

