/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.io.Serializable;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.AccessJournalInterceptorServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editor.JournalHttpServletResponseWrapper;
import jp.ossc.nimbus.service.journal.editor.JournalServletResponseWrapper;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.sequence.Sequence;

public class AccessJournalInterceptorService
extends ServletFilterInterceptorService
implements AccessJournalInterceptorServiceMBean {
    private static final long serialVersionUID = 2545303821021717162L;
    protected ServiceName journalServiceName;
    protected Journal journal;
    protected ServiceName accessEditorFinderServiceName;
    protected EditorFinder accessEditorFinder;
    protected ServiceName requestEditorFinderServiceName;
    protected EditorFinder requestEditorFinder;
    protected ServiceName responseEditorFinderServiceName;
    protected EditorFinder responseEditorFinder;
    protected ServiceName sequenceServiceName;
    protected Sequence sequence;
    protected ServiceName contextServiceName;
    protected Context context;
    protected boolean isResponseWrap;
    protected boolean isResponseBufferedOutput;
    protected boolean isBushingRequestBlock;
    protected String requestIdKey = "REQUEST_ID";
    protected String accessJournalKey = "Access";
    protected String requestJournalKey = "Request";
    protected String responseJournalKey = "Response";
    protected String servletRequestJournalKey = "ServletRequest";
    protected String servletResponseJournalKey = "ServletResponse";
    protected String httpSessionJournalKey = "HttpSession";
    protected boolean isOutputRequestSession = false;
    protected boolean isOutputResponseSession = false;

    @Override
    public void setAccessJournalKey(String key) {
        this.accessJournalKey = key;
    }

    @Override
    public String getAccessJournalKey() {
        return this.accessJournalKey;
    }

    @Override
    public void setRequestJournalKey(String key) {
        this.requestJournalKey = key;
    }

    @Override
    public String getRequestJournalKey() {
        return this.requestJournalKey;
    }

    @Override
    public void setResponseJournalKey(String key) {
        this.responseJournalKey = key;
    }

    @Override
    public String getResponseJournalKey() {
        return this.responseJournalKey;
    }

    @Override
    public void setServletRequestJournalKey(String key) {
        this.servletRequestJournalKey = key;
    }

    @Override
    public String getServletRequestJournalKey() {
        return this.servletRequestJournalKey;
    }

    @Override
    public void setServletResponseJournalKey(String key) {
        this.servletResponseJournalKey = key;
    }

    @Override
    public String getServletResponseJournalKey() {
        return this.servletResponseJournalKey;
    }

    @Override
    public void setHttpSessionJournalKey(String key) {
        this.httpSessionJournalKey = key;
    }

    @Override
    public String getHttpSessionJournalKey() {
        return this.httpSessionJournalKey;
    }

    @Override
    public void setJournalServiceName(ServiceName name) {
        this.journalServiceName = name;
    }

    @Override
    public ServiceName getJournalServiceName() {
        return this.journalServiceName;
    }

    @Override
    public void setAccessEditorFinderServiceName(ServiceName name) {
        this.accessEditorFinderServiceName = name;
    }

    @Override
    public ServiceName getAccessEditorFinderServiceName() {
        return this.accessEditorFinderServiceName;
    }

    @Override
    public void setRequestEditorFinderServiceName(ServiceName name) {
        this.requestEditorFinderServiceName = name;
    }

    @Override
    public ServiceName getRequestEditorFinderServiceName() {
        return this.requestEditorFinderServiceName;
    }

    @Override
    public void setResponseEditorFinderServiceName(ServiceName name) {
        this.responseEditorFinderServiceName = name;
    }

    @Override
    public ServiceName getResponseEditorFinderServiceName() {
        return this.responseEditorFinderServiceName;
    }

    @Override
    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    @Override
    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    @Override
    public void setContextServiceName(ServiceName name) {
        this.contextServiceName = name;
    }

    @Override
    public ServiceName getContextServiceName() {
        return this.contextServiceName;
    }

    @Override
    public void setResponseWrap(boolean isWrap) {
        this.isResponseWrap = isWrap;
    }

    @Override
    public boolean isResponseWrap() {
        return this.isResponseWrap;
    }

    @Override
    public void setResponseBufferedOutput(boolean isBuffered) {
        this.isResponseBufferedOutput = isBuffered;
    }

    @Override
    public boolean isResponseBufferedOutput() {
        return this.isResponseBufferedOutput;
    }

    @Override
    public void setBushingRequestBlock(boolean isBlock) {
        this.isBushingRequestBlock = isBlock;
    }

    @Override
    public boolean isBushingRequestBlock() {
        return this.isBushingRequestBlock;
    }

    @Override
    public void setRequestIDKey(String key) {
        this.requestIdKey = key;
    }

    @Override
    public String getRequestIDKey() {
        return this.requestIdKey;
    }

    @Override
    public void setOutputRequestSession(boolean isOutput) {
        this.isOutputRequestSession = isOutput;
    }

    @Override
    public boolean isOutputRequestSession() {
        return this.isOutputRequestSession;
    }

    @Override
    public void setOutputResponseSession(boolean isOutput) {
        this.isOutputResponseSession = isOutput;
    }

    @Override
    public boolean isOutputResponseSession() {
        return this.isOutputResponseSession;
    }

    @Override
    public void startService() throws Exception {
        if (this.journalServiceName == null) {
            throw new IllegalArgumentException("journalServiceName must be specified.");
        }
        this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
        if (this.accessEditorFinderServiceName != null) {
            this.accessEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.accessEditorFinderServiceName);
        }
        if (this.requestEditorFinderServiceName != null) {
            this.requestEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.requestEditorFinderServiceName);
        }
        if (this.responseEditorFinderServiceName != null) {
            this.responseEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.responseEditorFinderServiceName);
        }
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
        }
        if (this.contextServiceName != null) {
            this.context = (Context)ServiceManagerFactory.getServiceObject(this.contextServiceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() != 3) {
            return chain.invokeNext(context);
        }
        ServletRequest request = context.getServletRequest();
        ServletResponse response = context.getServletResponse();
        if (this.isBushingRequestBlock) {
            String recorded = (String)request.getAttribute(ACCESS_JOURNAL_RECORDED);
            if (recorded != null) {
                return chain.invokeNext(context);
            }
            request.setAttribute(ACCESS_JOURNAL_RECORDED, (Object)"recorded");
        }
        try {
            Object object;
            Serializable responsew;
            this.journal.startJournal(this.accessJournalKey, this.accessEditorFinder);
            if (this.sequence != null) {
                this.journal.setRequestId(this.sequence.increment());
            } else if (context != null) {
                this.journal.setRequestId((String)this.context.get(this.requestIdKey));
            }
            Object res = null;
            if (this.isResponseWrap) {
                if (response instanceof HttpServletResponse) {
                    HttpServletResponse httpResponse = (HttpServletResponse)response;
                    responsew = new JournalHttpServletResponseWrapper(httpResponse);
                    ((JournalHttpServletResponseWrapper)responsew).setBufferedOutput(this.isResponseBufferedOutput);
                    res = responsew;
                } else {
                    JournalServletResponseWrapper responsew2 = new JournalServletResponseWrapper(response);
                    responsew2.setBufferedOutput(this.isResponseBufferedOutput);
                    res = responsew2;
                }
                context.setServletResponse((ServletResponse)res);
            } else {
                res = response;
            }
            try {
                this.journal.addStartStep(this.requestJournalKey, this.requestEditorFinder);
                this.journal.addInfo(this.servletRequestJournalKey, request);
                if (this.isOutputRequestSession && request instanceof HttpServletRequest) {
                    this.journal.addInfo(this.httpSessionJournalKey, ((HttpServletRequest)request).getSession(false));
                }
                object = chain.invokeNext(context);
                this.journal.addEndStep();
            }
            catch (Throwable throwable) {
                this.journal.addEndStep();
                try {
                    this.journal.addStartStep(this.responseJournalKey, this.responseEditorFinder);
                    this.journal.addInfo(this.servletResponseJournalKey, res);
                    if (this.isOutputResponseSession && request instanceof HttpServletRequest) {
                        this.journal.addInfo(this.httpSessionJournalKey, ((HttpServletRequest)request).getSession(false));
                    }
                    if (this.isResponseWrap && this.isResponseBufferedOutput) {
                        if (res instanceof JournalHttpServletResponseWrapper) {
                            JournalHttpServletResponseWrapper responsew3 = (JournalHttpServletResponseWrapper)res;
                            responsew3.flush();
                        } else {
                            JournalServletResponseWrapper responsew4 = (JournalServletResponseWrapper)res;
                            responsew4.flush();
                        }
                    }
                }
                finally {
                    this.journal.addEndStep();
                }
                throw throwable;
            }
            try {
                this.journal.addStartStep(this.responseJournalKey, this.responseEditorFinder);
                this.journal.addInfo(this.servletResponseJournalKey, res);
                if (this.isOutputResponseSession && request instanceof HttpServletRequest) {
                    this.journal.addInfo(this.httpSessionJournalKey, ((HttpServletRequest)request).getSession(false));
                }
                if (this.isResponseWrap && this.isResponseBufferedOutput) {
                    if (res instanceof JournalHttpServletResponseWrapper) {
                        responsew = (JournalHttpServletResponseWrapper)res;
                        ((JournalHttpServletResponseWrapper)responsew).flush();
                    } else {
                        responsew = (JournalServletResponseWrapper)res;
                        ((JournalServletResponseWrapper)responsew).flush();
                    }
                }
            }
            finally {
                this.journal.addEndStep();
            }
            return object;
        }
        finally {
            this.journal.endJournal();
        }
    }
}

