/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.HttpServletResponseSetInterceptorServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletResponseSetInterceptorService;
import jp.ossc.nimbus.service.context.Context;

public class HttpServletResponseSetInterceptorService
extends ServletResponseSetInterceptorService
implements HttpServletResponseSetInterceptorServiceMBean {
    private static final long serialVersionUID = 9064558932042485512L;
    protected Map setHeaderMap;
    protected Map addHeaderMap;
    protected List cookies;
    protected ServiceName contextServiceName;
    protected Context context;
    protected Properties setHeaderContextKeys;
    protected Properties addHeaderContextKeys;

    @Override
    public void setSetHeaders(Map headers) {
        this.setHeaderMap.putAll(headers);
    }

    @Override
    public Map getSetHeaders() {
        return this.setHeaderMap;
    }

    @Override
    public void setSetHeader(String name, String value) {
        this.setHeaderMap.put(name, value);
    }

    @Override
    public String getSetHeader(String name) {
        return (String)this.setHeaderMap.get(name);
    }

    @Override
    public void removeSetHeader(String name) {
        this.setHeaderMap.remove(name);
    }

    @Override
    public void clearSetHeaders() {
        this.setHeaderMap.clear();
    }

    @Override
    public void setSetHeaderContextKeys(Properties keys) {
        this.setHeaderContextKeys = keys;
    }

    @Override
    public Properties getSetHeaderContextKeys() {
        return this.setHeaderContextKeys;
    }

    @Override
    public void setAddHeader(String name, String value) {
        List<String> values = null;
        if (this.addHeaderMap.containsKey(name)) {
            values = (List)this.addHeaderMap.get(name);
        } else {
            values = new ArrayList();
            this.addHeaderMap.put(name, values);
        }
        values.add(value);
    }

    @Override
    public String[] getAddHeaders(String name) {
        if (this.addHeaderMap.containsKey(name)) {
            List values = (List)this.addHeaderMap.get(name);
            return values.toArray(new String[values.size()]);
        }
        return null;
    }

    @Override
    public void removeAddHeader(String name) {
        if (this.addHeaderMap.containsKey(name)) {
            List values = (List)this.addHeaderMap.get(name);
            values.remove(name);
            if (values.size() == 0) {
                this.addHeaderMap.remove(values);
            }
        }
    }

    @Override
    public void clearAddHeaders() {
        this.addHeaderMap.clear();
    }

    @Override
    public void setAddHeaderContextKeys(Properties keys) {
        this.addHeaderContextKeys = keys;
    }

    @Override
    public Properties getAddHeaderContextKeys() {
        return this.addHeaderContextKeys;
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    @Override
    public void removeCookie(String name) {
        Iterator itr = this.cookies.iterator();
        while (itr.hasNext()) {
            Cookie cookie = (Cookie)itr.next();
            if (!name.equals(cookie.getName())) continue;
            itr.remove();
        }
    }

    @Override
    public void clearCookies() {
        this.cookies.clear();
    }

    @Override
    public void setContextServiceName(ServiceName name) {
        this.contextServiceName = name;
    }

    @Override
    public ServiceName getContextServiceName() {
        return this.contextServiceName;
    }

    @Override
    public void createService() throws Exception {
        super.createService();
        this.setHeaderMap = new HashMap();
        this.addHeaderMap = new HashMap();
        this.cookies = new ArrayList();
    }

    @Override
    public void startService() throws Exception {
        super.startService();
        if (this.contextServiceName != null) {
            this.context = (Context)ServiceManagerFactory.getServiceObject(this.contextServiceName);
        }
    }

    @Override
    public void destroyService() throws Exception {
        super.destroyService();
        this.setHeaderMap = null;
        this.addHeaderMap = null;
        this.cookies = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        ServletResponse response;
        Object object;
        try {
            object = super.invokeFilter(context, chain);
        }
        catch (Throwable throwable) {
            ServletResponse response2;
            if (this.getState() == 3 && (response2 = context.getServletResponse()) instanceof HttpServletResponse) {
                int imax;
                HttpServletResponse httpRes = (HttpServletResponse)response2;
                for (String key : this.addHeaderMap.keySet()) {
                    List values = (List)this.addHeaderMap.get(key);
                    imax = values.size();
                    for (int i = 0; i < imax; ++i) {
                        httpRes.addHeader(key, (String)values.get(i));
                    }
                }
                for (String key : this.setHeaderMap.keySet()) {
                    String value = (String)this.setHeaderMap.get(key);
                    httpRes.setHeader(key, value);
                }
                if (this.context != null) {
                    String name;
                    if (this.addHeaderContextKeys != null) {
                        for (String key : this.addHeaderContextKeys.keySet()) {
                            name = this.addHeaderContextKeys.getProperty(key);
                            Object value = this.context.get(key);
                            if (value == null) continue;
                            if (value instanceof Date) {
                                httpRes.addDateHeader(name, ((Date)value).getTime());
                                continue;
                            }
                            httpRes.addHeader(name, value.toString());
                        }
                    }
                    if (this.setHeaderContextKeys != null) {
                        for (String key : this.setHeaderContextKeys.keySet()) {
                            name = this.setHeaderContextKeys.getProperty(key);
                            Object value = this.context.get(key);
                            if (value == null) continue;
                            if (value instanceof Date) {
                                httpRes.setDateHeader(name, ((Date)value).getTime());
                                continue;
                            }
                            httpRes.setHeader(name, value.toString());
                        }
                    }
                }
                if (this.cookies.size() != 0) {
                    HttpServletRequest request = (HttpServletRequest)context.getServletRequest();
                    Cookie[] reqCookies = request.getCookies();
                    imax = this.cookies.size();
                    for (int i = 0; i < imax; ++i) {
                        Cookie cookie = (Cookie)this.cookies.get(i);
                        boolean isMatch = false;
                        if (reqCookies != null) {
                            int jmax = reqCookies.length;
                            for (int j = 0; j < jmax; ++j) {
                                if (!reqCookies[j].getName().equals(cookie.getName()) || !reqCookies[j].getValue().equals(cookie.getValue())) continue;
                                isMatch = true;
                                break;
                            }
                        }
                        if (isMatch) continue;
                        Cookie clone = (Cookie)cookie.clone();
                        if (clone.getPath() == null) {
                            clone.setPath(request.getContextPath());
                        }
                        httpRes.addCookie(clone);
                    }
                }
            }
            throw throwable;
        }
        if (this.getState() == 3 && (response = context.getServletResponse()) instanceof HttpServletResponse) {
            int imax;
            HttpServletResponse httpRes = (HttpServletResponse)response;
            for (String string : this.addHeaderMap.keySet()) {
                List values = (List)this.addHeaderMap.get(string);
                imax = values.size();
                for (int i = 0; i < imax; ++i) {
                    httpRes.addHeader(string, (String)values.get(i));
                }
            }
            for (String string : this.setHeaderMap.keySet()) {
                String value = (String)this.setHeaderMap.get(string);
                httpRes.setHeader(string, value);
            }
            if (this.context != null) {
                String name;
                if (this.addHeaderContextKeys != null) {
                    for (String string : this.addHeaderContextKeys.keySet()) {
                        name = this.addHeaderContextKeys.getProperty(string);
                        Object value = this.context.get(string);
                        if (value == null) continue;
                        if (value instanceof Date) {
                            httpRes.addDateHeader(name, ((Date)value).getTime());
                            continue;
                        }
                        httpRes.addHeader(name, value.toString());
                    }
                }
                if (this.setHeaderContextKeys != null) {
                    for (String string : this.setHeaderContextKeys.keySet()) {
                        name = this.setHeaderContextKeys.getProperty(string);
                        Object value = this.context.get(string);
                        if (value == null) continue;
                        if (value instanceof Date) {
                            httpRes.setDateHeader(name, ((Date)value).getTime());
                            continue;
                        }
                        httpRes.setHeader(name, value.toString());
                    }
                }
            }
            if (this.cookies.size() != 0) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)context.getServletRequest();
                Cookie[] reqCookies = httpServletRequest.getCookies();
                imax = this.cookies.size();
                for (int i = 0; i < imax; ++i) {
                    Cookie cookie = (Cookie)this.cookies.get(i);
                    boolean isMatch = false;
                    if (reqCookies != null) {
                        int jmax = reqCookies.length;
                        for (int j = 0; j < jmax; ++j) {
                            if (!reqCookies[j].getName().equals(cookie.getName()) || !reqCookies[j].getValue().equals(cookie.getValue())) continue;
                            isMatch = true;
                            break;
                        }
                    }
                    if (isMatch) continue;
                    Cookie clone = (Cookie)cookie.clone();
                    if (clone.getPath() == null) {
                        clone.setPath(httpServletRequest.getContextPath());
                    }
                    httpRes.addCookie(clone);
                }
            }
        }
        return object;
    }
}

