/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ExceptionHandler;
import jp.ossc.nimbus.service.aop.interceptor.servlet.SimpleExceptionHandlerServiceMBean;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.log.Logger;

public class SimpleExceptionHandlerService
extends ServiceBase
implements SimpleExceptionHandlerServiceMBean,
ExceptionHandler {
    private static final long serialVersionUID = 6936095762222810644L;
    protected ServiceName journalServiceName;
    protected Journal journal;
    protected String logMessageCode;
    protected boolean isOutputStackTraceLog;
    protected String exceptionJournalKey = "Exception";
    protected ServiceName exceptionEditorFinderServiceName;
    protected EditorFinder exceptionEditorFinder;

    @Override
    public void setJournalServiceName(ServiceName name) {
        this.journalServiceName = name;
    }

    @Override
    public ServiceName getJournalServiceName() {
        return this.journalServiceName;
    }

    @Override
    public void setLogMessageCode(String code) {
        this.logMessageCode = code;
    }

    @Override
    public String getLogMessageCode() {
        return this.logMessageCode;
    }

    @Override
    public void setOutputStackTraceLog(boolean isOutput) {
        this.isOutputStackTraceLog = isOutput;
    }

    @Override
    public boolean isOutputStackTraceLog() {
        return this.isOutputStackTraceLog;
    }

    @Override
    public void setExceptionJournalKey(String key) {
        this.exceptionJournalKey = key;
    }

    @Override
    public String getExceptionJournalKey() {
        return this.exceptionJournalKey;
    }

    @Override
    public void setExceptionEditorFinderServiceName(ServiceName name) {
        this.exceptionEditorFinderServiceName = name;
    }

    @Override
    public ServiceName getExceptionEditorFinderServiceName() {
        return this.exceptionEditorFinderServiceName;
    }

    @Override
    public void startService() throws Exception {
        if (this.journalServiceName != null) {
            this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
        }
        if (this.exceptionEditorFinderServiceName != null) {
            this.exceptionEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.exceptionEditorFinderServiceName);
        }
    }

    @Override
    public void handleException(Throwable th, ServletRequest request, ServletResponse response) throws Throwable {
        if (this.logMessageCode != null) {
            Logger log = super.getLogger();
            if (this.isOutputStackTraceLog) {
                log.write(this.logMessageCode, th);
            } else {
                log.write(this.logMessageCode);
            }
        }
        if (this.journal != null) {
            this.journal.addInfo(this.exceptionJournalKey, (Object)th, this.exceptionEditorFinder);
        }
    }
}

