/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import java.util.Set;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.AbstractCacheFactoryService;
import jp.ossc.nimbus.service.cache.AbstractCacheService;
import jp.ossc.nimbus.service.cache.FileCacheFactoryServiceMBean;
import jp.ossc.nimbus.service.cache.FileCacheService;

public class FileCacheFactoryService
extends AbstractCacheFactoryService
implements FileCacheFactoryServiceMBean,
Serializable {
    private static final long serialVersionUID = -4354172514890478044L;

    @Override
    protected AbstractCacheService createAbstractCacheService() throws Exception {
        return new FileCacheService();
    }

    @Override
    protected Service createServiceInstance() throws Exception {
        FileCacheService cache = (FileCacheService)super.createServiceInstance();
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        cache.setOutputDirectory(templateCache.getOutputDirectory());
        cache.setOutputPrefix(templateCache.getOutputPrefix());
        cache.setOutputSuffix(templateCache.getOutputSuffix());
        cache.setLoadOnStart(templateCache.isLoadOnStart());
        cache.setDeleteOnExitWithJVM(templateCache.isDeleteOnExitWithJVM());
        cache.setExternalizerServiceName(templateCache.getExternalizerServiceName());
        return cache;
    }

    @Override
    public void setOutputDirectory(String path) throws IllegalArgumentException {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return;
        }
        templateCache.setOutputDirectory(path);
        Set instanceSet = this.getManagedInstanceSet();
        for (FileCacheService cache : instanceSet) {
            cache.setOutputDirectory(path);
        }
    }

    @Override
    public String getOutputDirectory() {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return null;
        }
        return templateCache.getOutputDirectory();
    }

    @Override
    public void setOutputPrefix(String prefix) {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return;
        }
        templateCache.setOutputPrefix(prefix);
        Set instanceSet = this.getManagedInstanceSet();
        for (FileCacheService cache : instanceSet) {
            cache.setOutputPrefix(prefix);
        }
    }

    @Override
    public String getOutputPrefix() {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return null;
        }
        return templateCache.getOutputPrefix();
    }

    @Override
    public void setOutputSuffix(String suffix) {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return;
        }
        templateCache.setOutputSuffix(suffix);
        Set instanceSet = this.getManagedInstanceSet();
        for (FileCacheService cache : instanceSet) {
            cache.setOutputSuffix(suffix);
        }
    }

    @Override
    public String getOutputSuffix() {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return null;
        }
        return templateCache.getOutputSuffix();
    }

    @Override
    public void setLoadOnStart(boolean isLoad) {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return;
        }
        templateCache.setLoadOnStart(isLoad);
        Set instanceSet = this.getManagedInstanceSet();
        for (FileCacheService cache : instanceSet) {
            cache.setLoadOnStart(isLoad);
        }
    }

    @Override
    public boolean isLoadOnStart() {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return false;
        }
        return templateCache.isLoadOnStart();
    }

    @Override
    public void setDeleteOnExitWithJVM(boolean isDeleteOnExit) {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return;
        }
        templateCache.setDeleteOnExitWithJVM(isDeleteOnExit);
        Set instanceSet = this.getManagedInstanceSet();
        for (FileCacheService cache : instanceSet) {
            cache.setDeleteOnExitWithJVM(isDeleteOnExit);
        }
    }

    @Override
    public boolean isDeleteOnExitWithJVM() {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return false;
        }
        return templateCache.isDeleteOnExitWithJVM();
    }

    @Override
    public void setExternalizerServiceName(ServiceName name) {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return;
        }
        templateCache.setExternalizerServiceName(name);
        Set instanceSet = this.getManagedInstanceSet();
        for (FileCacheService cache : instanceSet) {
            cache.setExternalizerServiceName(name);
        }
    }

    @Override
    public ServiceName getExternalizerServiceName() {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return null;
        }
        return templateCache.getExternalizerServiceName();
    }
}

