/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.MemorySizeOverflowValidatorServiceMBean;
import jp.ossc.nimbus.service.cache.OverflowValidator;

public class MemorySizeOverflowValidatorService
extends ServiceBase
implements OverflowValidator,
CacheRemoveListener,
Serializable,
MemorySizeOverflowValidatorServiceMBean {
    private static final long serialVersionUID = -8937874822673039671L;
    private static final char KILO_UNIT = 'K';
    private static final char MEGA_UNIT = 'M';
    private static final char GIGA_UNIT = 'G';
    private static final long KILO_BYTE = 1024L;
    private static final long MEGA_BYTE = 0x100000L;
    private static final long GIGA_BYTE = 0x40000000L;
    private String maxHeapMemorySizeStr = "64M";
    private long maxHeapMemorySize = 0x4000000L;
    private String highHeapMemorySizeStr = "32M";
    private long highHeapMemorySize = 0x2000000L;
    private Set references;

    public MemorySizeOverflowValidatorService() {
        Runtime runtime = Runtime.getRuntime();
        try {
            this.maxHeapMemorySize = runtime.maxMemory();
            this.maxHeapMemorySizeStr = Long.toString(this.maxHeapMemorySize);
            this.highHeapMemorySize = this.maxHeapMemorySize / 2L;
            this.highHeapMemorySizeStr = Long.toString(this.highHeapMemorySize);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    @Override
    public void createService() throws Exception {
        this.references = Collections.synchronizedSet(new HashSet());
    }

    @Override
    public void startService() throws Exception {
        if (this.maxHeapMemorySize <= this.highHeapMemorySize) {
            throw new IllegalArgumentException("maxHeapMemorySize must be larger than highHeapMemorySize.");
        }
    }

    @Override
    public void destroyService() throws Exception {
        this.reset();
        this.references = null;
    }

    @Override
    public void setMaxHeapMemorySize(String size) throws IllegalArgumentException {
        this.maxHeapMemorySize = this.convertMemorySize(size);
        this.maxHeapMemorySizeStr = size;
    }

    @Override
    public String getMaxHeapMemorySize() {
        return this.maxHeapMemorySizeStr;
    }

    @Override
    public void setHighHeapMemorySize(String size) throws IllegalArgumentException {
        this.highHeapMemorySize = this.convertMemorySize(size);
        this.highHeapMemorySizeStr = size;
    }

    @Override
    public String getHighHeapMemorySize() {
        return this.highHeapMemorySizeStr;
    }

    @Override
    public int size() {
        return this.references == null ? 0 : this.references.size();
    }

    private long convertMemorySize(String size) throws IllegalArgumentException {
        long value = 0L;
        boolean isValid = true;
        if (size == null) {
            isValid = false;
        } else {
            int length = size.length();
            if (length == 0) {
                isValid = false;
            } else {
                char unit = Character.toUpperCase(size.charAt(length - 1));
                String tmpSize = null;
                long unitValue = 0L;
                switch (unit) {
                    case 'K': {
                        tmpSize = size.substring(0, length - 1);
                        unitValue = 1024L;
                        break;
                    }
                    case 'M': {
                        tmpSize = size.substring(0, length - 1);
                        unitValue = 0x100000L;
                        break;
                    }
                    case 'G': {
                        tmpSize = size.substring(0, length - 1);
                        unitValue = 0x40000000L;
                        break;
                    }
                    default: {
                        tmpSize = size;
                        unitValue = 1L;
                    }
                }
                try {
                    value = (long)(Double.parseDouble(tmpSize) * (double)unitValue);
                }
                catch (NumberFormatException e) {
                    isValid = false;
                }
            }
        }
        if (value < 0L) {
            isValid = false;
        }
        if (!isValid) {
            throw new IllegalArgumentException("Invalid size : " + size);
        }
        return value;
    }

    protected long getHighHeapMemorySizeValue() {
        return this.highHeapMemorySize;
    }

    protected long getMaxHeapMemorySizeValue() {
        return this.maxHeapMemorySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(CachedReference ref) {
        if (this.references == null || ref == null) {
            return;
        }
        Set set = this.references;
        synchronized (set) {
            if (!this.references.contains(ref)) {
                this.references.add(ref);
                ref.addCacheRemoveListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(CachedReference ref) {
        if (this.references == null || ref == null) {
            return;
        }
        Set set = this.references;
        synchronized (set) {
            if (this.references.contains(ref)) {
                this.references.remove(ref);
                ref.removeCacheRemoveListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int validate() {
        if (this.references == null || this.references.size() == 0) {
            return 0;
        }
        Set set = this.references;
        synchronized (set) {
            if (this.getState() != 3) {
                return 0;
            }
            float rate = this.calculateOverflowRate();
            int overflowSize = (int)((float)this.references.size() * rate);
            int n = overflowSize > 0 ? overflowSize : 0;
            return n;
        }
    }

    @Override
    public void reset() {
        if (this.references != null) {
            this.references.clear();
        }
    }

    @Override
    public float calculateOverflowRate() {
        long highHeap;
        long currentFree;
        Runtime runtime = Runtime.getRuntime();
        long currentHeap = runtime.totalMemory();
        long currentUse = currentHeap - (currentFree = runtime.freeMemory());
        if (currentUse < (highHeap = this.getHighHeapMemorySizeValue())) {
            return 0.0f;
        }
        long maxHeap = this.getMaxHeapMemorySizeValue();
        float rate = (float)(currentUse - highHeap) / (float)(maxHeap - highHeap);
        rate = Math.min(rate, 1.0f);
        return rate;
    }

    @Override
    public void removed(CachedReference ref) {
        this.remove(ref);
    }
}

