/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cui;

import jp.ossc.nimbus.service.cui.InputChecker;
import jp.ossc.nimbus.util.CsvArrayList;

public class TextInputChecker
implements InputChecker {
    private CsvArrayList mValidValues = new CsvArrayList();
    private int mValidValueMax;
    private int mValidValueMin;
    private boolean mMaxMinDefMode = false;
    private String mFromToStr = "-";

    @Override
    public String check(String input) {
        if (this.mMaxMinDefMode) {
            int tmp;
            try {
                tmp = Integer.parseInt(input);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (this.mValidValueMin <= tmp && tmp <= this.mValidValueMax) {
                return input;
            }
            return null;
        }
        if (this.mValidValues.contains(input)) {
            return input;
        }
        return null;
    }

    public void setValidInput(String inputdef) throws NumberFormatException {
        this.mMaxMinDefMode = this.isMaxMinTypeDefinition(inputdef);
        if (!this.mMaxMinDefMode) {
            this.mValidValues.split(inputdef);
        }
    }

    protected boolean isMaxMinTypeDefinition(String def) throws NumberFormatException {
        int separatePos = -1;
        separatePos = def.indexOf(this.mFromToStr);
        if (separatePos < 0) {
            return false;
        }
        String minStr = def.substring(0, separatePos);
        String maxStr = def.substring(separatePos + this.mFromToStr.length());
        this.mValidValueMin = Integer.parseInt(minStr);
        this.mValidValueMax = Integer.parseInt(maxStr);
        return true;
    }

    public void setFromToString(String fromto) {
        this.mFromToStr = fromto;
    }
}

