/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import jp.ossc.nimbus.service.graph.AbstractTickUnitAdjusterService;
import jp.ossc.nimbus.service.graph.NumberAxisTickUnitAdjusterServiceMBean;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;

public class NumberAxisTickUnitAdjusterService
extends AbstractTickUnitAdjusterService
implements NumberAxisTickUnitAdjusterServiceMBean {
    private static final long serialVersionUID = 4617823208865903862L;
    private NumberFormat format;

    @Override
    protected void adjust(ValueAxis axis) {
        if (!(axis instanceof NumberAxis)) {
            throw new IllegalArgumentException("axis is not NumberAxis.");
        }
        double length = axis.getRange().getLength();
        double unitCount = length / (double)this.displayGraduationCount;
        unitCount = unitCount <= 0.0 ? 1.0 : this.adjustUnitCountByCommonDivisor(axis, unitCount);
        NumberFormat newFormat = null;
        newFormat = this.format != null ? this.format : new DecimalFormat();
        ((NumberAxis)axis).setTickUnit(new NumberTickUnit(unitCount, newFormat));
        if (this.autoRangeMinimumSizeEnabled) {
            axis.setAutoRangeMinimumSize(unitCount * 2.0);
        }
    }

    @Override
    public void setFormat(NumberFormat format) {
        this.format = format;
    }

    @Override
    public NumberFormat getFormat() {
        return this.format;
    }
}

