/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import jp.ossc.nimbus.service.jms.ReconnectableConnection;
import jp.ossc.nimbus.service.jms.ReconnectableSession;
import jp.ossc.nimbus.service.jms.ReconnectableTopicPublisher;
import jp.ossc.nimbus.service.jms.ReconnectableTopicSubscriber;

public class ReconnectableTopicSession
extends ReconnectableSession
implements TopicSession,
XATopicSession {
    public ReconnectableTopicSession(ReconnectableConnection con) throws JMSException {
        super(con);
    }

    public ReconnectableTopicSession(ReconnectableConnection con, boolean transacted, int acknowledgeMode) throws JMSException {
        super(con, transacted, acknowledgeMode);
    }

    @Override
    protected Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.transacted = transacted;
        return ((TopicConnection)this.connection.getConnection()).createTopicSession(transacted, acknowledgeMode);
    }

    @Override
    protected Session createXASession() throws JMSException {
        return ((XATopicConnection)this.connection.getConnection()).createXATopicSession();
    }

    public TopicSession getTopicSession() throws JMSException {
        return ((XATopicSession)this.session).getTopicSession();
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        ReconnectableTopicSubscriber subscriber = new ReconnectableTopicSubscriber((ReconnectableSession)this, topic);
        this.addMessageConsumer(subscriber);
        return subscriber;
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        ReconnectableTopicSubscriber subscriber = new ReconnectableTopicSubscriber((ReconnectableSession)this, topic, messageSelector, noLocal);
        this.addMessageConsumer(subscriber);
        return subscriber;
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        ReconnectableTopicPublisher publisher = new ReconnectableTopicPublisher(this, (Destination)topic);
        this.addMessageProducer(publisher);
        return publisher;
    }
}

