/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.message;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.message.MessageRecord;
import jp.ossc.nimbus.service.message.MessageRecordFactory;
import jp.ossc.nimbus.service.message.MessageRecordOperator;
import jp.ossc.nimbus.service.message.MessageRecordParseException;
import jp.ossc.nimbus.util.CsvArrayList;
import jp.ossc.nimbus.util.StringOperator;

public class MessageRecordImpl
implements MessageRecord,
MessageRecordOperator,
Serializable {
    private static final long serialVersionUID = -1519744660770872465L;
    protected String mMessageCode;
    protected HashMap mMessageHash = new HashMap();
    protected boolean mIsInitialized = false;
    protected long mLastOccur = -1L;
    protected boolean mIsSecret = false;
    protected String secretString;
    protected long mUsedCount;
    protected Hashtable mLocaleHash = new Hashtable();
    private transient MessageRecordFactory mFac;
    private ServiceName mFacName;
    private static final String C_DFAUTL_LOCALE = "default";
    private static final String C_UNDER_SCORE = "_";
    private static final String C_DELIMETER = ",";
    private static final String EMBED_STRING = "@";
    private static final String SECRET_EMBED_STRING = "#";
    private static final String SINGLE_EMBED_STRING = "@0";
    private static final String SINGLE_SECRET_EMBED_STRING = "#0";
    private static final String SECRET_EMBED_SEARCH_STRING = "#[0-9]+";
    private static final String DATE_FORMAT = "yyyy-MM-dd hh-mm-ss";

    @Override
    public String makeMessage(Locale lo) {
        this.increment();
        return this.getMessageTemplate(lo);
    }

    @Override
    public String makeMessage() {
        return this.makeMessage(Locale.getDefault());
    }

    @Override
    public String makeMessage(Locale lo, Object embed) {
        this.increment();
        String tmp = this.getMessageTemplate(lo);
        String retStr = StringOperator.replaceString(tmp, SINGLE_EMBED_STRING, embed);
        if (this.mIsSecret) {
            if (this.secretString != null) {
                retStr = StringOperator.replaceString(retStr, SINGLE_SECRET_EMBED_STRING, this.secretString);
            }
        } else {
            retStr = StringOperator.replaceString(retStr, SINGLE_SECRET_EMBED_STRING, embed);
        }
        return retStr;
    }

    @Override
    public String makeMessage(Locale lo, byte embed) {
        return this.makeMessage(lo, Byte.toString(embed));
    }

    @Override
    public String makeMessage(Locale lo, short embed) {
        return this.makeMessage(lo, Short.toString(embed));
    }

    @Override
    public String makeMessage(Locale lo, char embed) {
        return this.makeMessage(lo, new Character(embed));
    }

    @Override
    public String makeMessage(Locale lo, int embed) {
        return this.makeMessage(lo, Integer.toString(embed));
    }

    @Override
    public String makeMessage(Locale lo, long embed) {
        return this.makeMessage(lo, Long.toString(embed));
    }

    @Override
    public String makeMessage(Locale lo, float embed) {
        return this.makeMessage(lo, Float.toString(embed));
    }

    @Override
    public String makeMessage(Locale lo, double embed) {
        return this.makeMessage(lo, Double.toString(embed));
    }

    @Override
    public String makeMessage(Locale lo, boolean embed) {
        return this.makeMessage(lo, Boolean.toString(embed));
    }

    @Override
    public String makeMessage(Object embed) {
        return this.makeMessage(Locale.getDefault(), embed);
    }

    @Override
    public String makeMessage(byte embed) {
        return this.makeMessage(Byte.toString(embed));
    }

    @Override
    public String makeMessage(short embed) {
        return this.makeMessage(Short.toString(embed));
    }

    @Override
    public String makeMessage(char embed) {
        return this.makeMessage(new Character(embed));
    }

    @Override
    public String makeMessage(int embed) {
        return this.makeMessage(Integer.toString(embed));
    }

    @Override
    public String makeMessage(long embed) {
        return this.makeMessage(Long.toString(embed));
    }

    @Override
    public String makeMessage(float embed) {
        return this.makeMessage(Float.toString(embed));
    }

    @Override
    public String makeMessage(double embed) {
        return this.makeMessage(Double.toString(embed));
    }

    @Override
    public String makeMessage(boolean embed) {
        return this.makeMessage(Boolean.toString(embed));
    }

    @Override
    public String makeMessage(Locale lo, Object[] embeds) {
        this.increment();
        String tmp = this.getMessageTemplate(lo);
        String retStr = StringOperator.replaceString(tmp, EMBED_STRING, embeds);
        if (this.mIsSecret) {
            if (this.secretString != null) {
                retStr = retStr.replaceAll(SECRET_EMBED_SEARCH_STRING, this.secretString);
            }
        } else {
            retStr = StringOperator.replaceString(retStr, SECRET_EMBED_STRING, embeds);
        }
        return retStr;
    }

    @Override
    public String makeMessage(Locale lo, byte[] embeds) {
        if (embeds == null) {
            return this.makeMessage(lo, (Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Byte.toString(embeds[i]);
        }
        return this.makeMessage(lo, strs);
    }

    @Override
    public String makeMessage(Locale lo, short[] embeds) {
        if (embeds == null) {
            return this.makeMessage(lo, (Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Short.toString(embeds[i]);
        }
        return this.makeMessage(lo, strs);
    }

    @Override
    public String makeMessage(Locale lo, char[] embeds) {
        if (embeds == null) {
            return this.makeMessage(lo, (Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = new Character(embeds[i]);
        }
        return this.makeMessage(lo, strs);
    }

    @Override
    public String makeMessage(Locale lo, int[] embeds) {
        if (embeds == null) {
            return this.makeMessage(lo, (Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Integer.toString(embeds[i]);
        }
        return this.makeMessage(lo, strs);
    }

    @Override
    public String makeMessage(Locale lo, long[] embeds) {
        if (embeds == null) {
            return this.makeMessage(lo, (Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Long.toString(embeds[i]);
        }
        return this.makeMessage(lo, strs);
    }

    @Override
    public String makeMessage(Locale lo, float[] embeds) {
        if (embeds == null) {
            return this.makeMessage(lo, (Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Float.toString(embeds[i]);
        }
        return this.makeMessage(lo, strs);
    }

    @Override
    public String makeMessage(Locale lo, double[] embeds) {
        if (embeds == null) {
            return this.makeMessage(lo, (Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Double.toString(embeds[i]);
        }
        return this.makeMessage(lo, strs);
    }

    @Override
    public String makeMessage(Locale lo, boolean[] embeds) {
        if (embeds == null) {
            return this.makeMessage(lo, (Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Boolean.toString(embeds[i]);
        }
        return this.makeMessage(lo, strs);
    }

    @Override
    public String makeMessage(Object[] embeds) {
        return this.makeMessage(Locale.getDefault(), embeds);
    }

    @Override
    public String makeMessage(byte[] embeds) {
        if (embeds == null) {
            return this.makeMessage((Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Byte.toString(embeds[i]);
        }
        return this.makeMessage(strs);
    }

    @Override
    public String makeMessage(short[] embeds) {
        if (embeds == null) {
            return this.makeMessage((Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Short.toString(embeds[i]);
        }
        return this.makeMessage(strs);
    }

    @Override
    public String makeMessage(char[] embeds) {
        if (embeds == null) {
            return this.makeMessage((Object[])null);
        }
        Object[] strs = new Character[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = new Character(embeds[i]);
        }
        return this.makeMessage(strs);
    }

    @Override
    public String makeMessage(int[] embeds) {
        if (embeds == null) {
            return this.makeMessage((Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Integer.toString(embeds[i]);
        }
        return this.makeMessage(strs);
    }

    @Override
    public String makeMessage(long[] embeds) {
        if (embeds == null) {
            return this.makeMessage((Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Long.toString(embeds[i]);
        }
        return this.makeMessage(strs);
    }

    @Override
    public String makeMessage(float[] embeds) {
        if (embeds == null) {
            return this.makeMessage((Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Float.toString(embeds[i]);
        }
        return this.makeMessage(strs);
    }

    @Override
    public String makeMessage(double[] embeds) {
        if (embeds == null) {
            return this.makeMessage((Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Double.toString(embeds[i]);
        }
        return this.makeMessage(strs);
    }

    @Override
    public String makeMessage(boolean[] embeds) {
        if (embeds == null) {
            return this.makeMessage((Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Boolean.toString(embeds[i]);
        }
        return this.makeMessage(strs);
    }

    @Override
    public String getMessageTemplate(Locale lo) {
        return this.getMessage(lo == null ? Locale.getDefault() : lo);
    }

    @Override
    public String getMessageTemplate() {
        return this.getMessageTemplate(Locale.getDefault());
    }

    @Override
    public void rec2Obj(String defString) throws MessageRecordParseException {
        if (!this.mIsInitialized) {
            CsvArrayList parser = new CsvArrayList();
            parser.split(defString, C_DELIMETER);
            if (parser.size() < 2) {
                throw new MessageRecordParseException("Message define error message is " + defString);
            }
            this.mMessageCode = parser.getStr(0);
            this.mMessageHash.put(C_DFAUTL_LOCALE, parser.getStr(1));
        }
    }

    @Override
    public String getMessageCode() {
        return this.mMessageCode;
    }

    public void setMessageCode(String code) {
        this.mMessageCode = code;
    }

    @Override
    public synchronized long getUsedCount() {
        return this.mUsedCount;
    }

    @Override
    public synchronized void clearUsedCount() {
        this.mUsedCount = 0L;
    }

    protected synchronized void increment() {
        ++this.mUsedCount;
        this.mLastOccur = System.currentTimeMillis();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.mMessageCode).append(';');
        ret.append(this.mMessageHash.get(C_DFAUTL_LOCALE)).append(';');
        ret.append(this.mUsedCount).append(';');
        if (this.mLastOccur == -1L) {
            ret.append("NONE");
        } else {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
            ret.append(formatter.format(new Date(this.mLastOccur)));
        }
        return ret.toString();
    }

    @Override
    public Date getLastUsedDate() {
        return new Date(this.mLastOccur);
    }

    @Override
    public void setSecret(boolean flg) {
        this.mIsSecret = flg;
    }

    @Override
    public void setSecretString(String secret) {
        this.secretString = secret;
    }

    @Override
    public void addMessage(String message, String locale) {
        this.mMessageHash.put(locale, message);
    }

    public void addMessage(String message) {
        this.mMessageHash.put(C_DFAUTL_LOCALE, message);
    }

    protected String getMessage(Locale lo) {
        MessageRecordFactory fac = null;
        if (this.mFac == null && this.mFacName != null) {
            try {
                fac = (MessageRecordFactory)ServiceManagerFactory.getServiceObject(this.mFacName);
            }
            catch (ServiceNotFoundException e) {
                return null;
            }
        } else {
            fac = this.mFac;
        }
        if (fac == null) {
            return null;
        }
        fac.findLocale(lo);
        String key = (String)this.mLocaleHash.get(lo);
        if (key == null) {
            StringBuffer propKey = new StringBuffer();
            propKey.append(lo.getLanguage()).append(C_UNDER_SCORE).append(lo.getCountry()).append(C_UNDER_SCORE).append(lo.getVariant());
            key = (String)this.mMessageHash.get(propKey.toString());
            if (key == null) {
                propKey.setLength(0);
                propKey.append(lo.getLanguage()).append(C_UNDER_SCORE).append(lo.getCountry());
                key = (String)this.mMessageHash.get(propKey.toString());
            }
            if (key == null) {
                propKey.setLength(0);
                propKey.append(lo.getLanguage());
                key = (String)this.mMessageHash.get(propKey.toString());
            }
            if (key == null) {
                if (!lo.equals(Locale.getDefault())) {
                    Locale loDafault = Locale.getDefault();
                    propKey.setLength(0);
                    propKey.append(loDafault.getLanguage()).append(C_UNDER_SCORE).append(loDafault.getCountry()).append(C_UNDER_SCORE).append(loDafault.getVariant());
                    key = (String)this.mMessageHash.get(propKey.toString());
                    if (key == null) {
                        propKey.setLength(0);
                        propKey.append(loDafault.getLanguage()).append(C_UNDER_SCORE).append(loDafault.getCountry());
                        key = (String)this.mMessageHash.get(propKey.toString());
                    }
                    if (key == null) {
                        propKey.setLength(0);
                        propKey.append(loDafault.getLanguage());
                        key = (String)this.mMessageHash.get(propKey.toString());
                    }
                }
                key = (String)this.mMessageHash.get(C_DFAUTL_LOCALE);
            }
            this.mLocaleHash.put(lo, key);
        }
        return key;
    }

    @Override
    public void setFactory(MessageRecordFactory fac) {
        this.mFac = fac;
        if (this.mFac instanceof ServiceBase) {
            this.mFacName = ((ServiceBase)((Object)this.mFac)).getServiceNameObject();
        } else if (this.mFac instanceof Service) {
            Service service = (Service)((Object)this.mFac);
            this.mFacName = new ServiceName(service.getServiceManagerName(), service.getServiceName());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.mFacName == null && this.mFac != null) {
            out.writeObject(this.mFac);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.mFacName == null) {
            this.mFac = (MessageRecordFactory)in.readObject();
        } else {
            try {
                this.mFac = (MessageRecordFactory)ServiceManagerFactory.getServiceObject(this.mFacName);
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
        }
    }
}

